/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.ArrayListIterator;
import org.eclipse.dali.utility.tests.iterators.ArrayIteratorTests;

public class ArrayListIteratorTests
extends ArrayIteratorTests {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.ArrayListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.ArrayListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ArrayListIteratorTests(String name) {
        super(name);
    }

    public void testHasPrevious() {
        ListIterator stream = this.buildListIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        int i = 0;
        while (stream.hasPrevious()) {
            stream.previous();
            ++i;
        }
        ArrayListIteratorTests.assertEquals((int)this.buildArray().length, (int)i);
    }

    public void testPrevious() {
        ListIterator stream = this.buildListIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        int i = this.buildArray().length;
        while (stream.hasPrevious()) {
            ArrayListIteratorTests.assertEquals((String)"bogus element", (int)i--, (int)Integer.parseInt((String)stream.previous()));
        }
    }

    public void testNextIndex() {
        int i = 0;
        ListIterator stream = this.buildListIterator();
        while (stream.hasNext()) {
            ArrayListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
            stream.next();
            ++i;
        }
        ArrayListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
    }

    public void testPreviousIndex() {
        int i = 0;
        ListIterator stream = this.buildListIterator();
        while (stream.hasNext()) {
            ArrayListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
            stream.next();
            ++i;
        }
        ArrayListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator stream = this.buildListIterator();
        String string = null;
        try {
            string = (String)stream.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ArrayListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testUnsupportedOperationExceptionAdd() {
        boolean exCaught = false;
        ListIterator stream = this.buildListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("3")) continue;
            try {
                stream.add("3.5");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ArrayListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testUnsupportedOperationExceptionSet() {
        boolean exCaught = false;
        ListIterator stream = this.buildListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("3")) continue;
            try {
                stream.set("three");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ArrayListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private ListIterator buildListIterator() {
        return this.buildListIterator(this.buildArray());
    }

    private ListIterator buildListIterator(Object[] array) {
        return new ArrayListIterator(array);
    }

    Iterator buildIterator(Object[] array) {
        return new ArrayListIterator(array);
    }

    Iterator buildIterator(Object[] array, int start, int length) {
        return new ArrayListIterator(array, start, length);
    }
}

