/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.ReverseComparator;
import org.eclipse.dali.utility.tests.TestTools;

public class ReverseComparatorTests
extends TestCase {
    private Comparator naturalReverseComparator;
    private Comparator customComparator;
    private Comparator customReverseComparator;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.ReverseComparatorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.ReverseComparatorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ReverseComparatorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.naturalReverseComparator = new ReverseComparator();
        this.customComparator = this.buildCustomComparator();
        this.customReverseComparator = new ReverseComparator(this.customComparator);
    }

    private Comparator buildCustomComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                String lower2;
                String s1 = (String)o1;
                String s2 = (String)o2;
                String lower1 = s1.toLowerCase();
                int result = lower1.compareTo(lower2 = s2.toLowerCase());
                if (result == 0) {
                    return s1.compareTo(s2);
                }
                return result;
            }
        };
    }

    private List buildUnsortedList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("T");
        result.add("Z");
        result.add("Y");
        result.add("M");
        result.add("m");
        result.add("a");
        result.add("B");
        result.add("b");
        result.add("A");
        return result;
    }

    private List buildNaturallySortedList() {
        ArrayList result = new ArrayList(this.buildUnsortedList());
        Collections.sort(result);
        return result;
    }

    private List buildCustomSortedList() {
        ArrayList result = new ArrayList(this.buildUnsortedList());
        Collections.sort(result, this.customComparator);
        return result;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testNatural() {
        List list = this.buildUnsortedList();
        Collections.sort(list, this.naturalReverseComparator);
        this.verifyList(this.buildNaturallySortedList(), list);
    }

    public void testCustom() {
        List list = this.buildUnsortedList();
        Collections.sort(list, this.customReverseComparator);
        this.verifyList(this.buildCustomSortedList(), list);
    }

    private void verifyList(List normal, List reverse) {
        int size = normal.size();
        int max = size - 1;
        int i = 0;
        while (i < size) {
            ReverseComparatorTests.assertEquals(normal.get(i), reverse.get(max - i));
            ++i;
        }
    }
}

