/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: TypeMetaDataImpl.java,v 1.12 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Type Meta Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.TypeMetaDataImpl#getEntityModel <em>Entity Model</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.TypeMetaDataImpl#getClassName <em>Class Name</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.TypeMetaDataImpl#getCls <em>Cls</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TypeMetaDataImpl extends MetadataElementImpl implements
		TypeMetaData {
	/**
	 * The default value of the '{@link #getClassName() <em>Class Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getClassName()
	 * @generated
	 * @ordered
	 */
	protected static final String CLASS_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getClassName() <em>Class Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getClassName()
	 * @generated
	 * @ordered
	 */
	protected String className = CLASS_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCls() <em>Cls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCls()
	 * @generated
	 * @ordered
	 */
	protected static final Class CLS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCls() <em>Cls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCls()
	 * @generated
	 * @ordered
	 */
	protected Class cls = CLS_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeMetaDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getTypeMetaData();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EntityModel getEntityModel() {
		if (eContainerFeatureID != MetadataPackage.TYPE_META_DATA__ENTITY_MODEL) return null;
		return (EntityModel)eContainer;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setEntityModel(EntityModel newEntityModel) {
		if (newEntityModel != eContainer || (eContainerFeatureID != MetadataPackage.TYPE_META_DATA__ENTITY_MODEL && newEntityModel != null)) {
			if (EcoreUtil.isAncestor(this, newEntityModel))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newEntityModel != null)
				msgs = ((InternalEObject)newEntityModel).eInverseAdd(this, MetadataPackage.ENTITY_MODEL__TYPE_LIST, EntityModel.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newEntityModel, MetadataPackage.TYPE_META_DATA__ENTITY_MODEL, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.TYPE_META_DATA__ENTITY_MODEL, newEntityModel, newEntityModel));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setClassName(String newClassName) {
		String oldClassName = className;
		className = newClassName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.TYPE_META_DATA__CLASS_NAME, oldClassName, className));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Class getCls() {
		return cls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCls(Class newCls) {
		Class oldCls = cls;
		cls = newCls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.TYPE_META_DATA__CLS, oldCls, cls));
	}

	public String getShortName() {
		if (className == null) {
			return "(null)";
		}
		int i = className.lastIndexOf('.');
		if (i < 0) {
			return className;
		}
		return className.substring(i + 1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.TYPE_META_DATA__ENTITY_MODEL:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, MetadataPackage.TYPE_META_DATA__ENTITY_MODEL, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.TYPE_META_DATA__ENTITY_MODEL:
					return eBasicSetContainer(null, MetadataPackage.TYPE_META_DATA__ENTITY_MODEL, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case MetadataPackage.TYPE_META_DATA__ENTITY_MODEL:
					return eContainer.eInverseRemove(this, MetadataPackage.ENTITY_MODEL__TYPE_LIST, EntityModel.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.TYPE_META_DATA__ENTITY_MODEL:
				return getEntityModel();
			case MetadataPackage.TYPE_META_DATA__CLASS_NAME:
				return getClassName();
			case MetadataPackage.TYPE_META_DATA__CLS:
				return getCls();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.TYPE_META_DATA__ENTITY_MODEL:
				setEntityModel((EntityModel)newValue);
				return;
			case MetadataPackage.TYPE_META_DATA__CLASS_NAME:
				setClassName((String)newValue);
				return;
			case MetadataPackage.TYPE_META_DATA__CLS:
				setCls((Class)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.TYPE_META_DATA__ENTITY_MODEL:
				setEntityModel((EntityModel)null);
				return;
			case MetadataPackage.TYPE_META_DATA__CLASS_NAME:
				setClassName(CLASS_NAME_EDEFAULT);
				return;
			case MetadataPackage.TYPE_META_DATA__CLS:
				setCls(CLS_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.TYPE_META_DATA__ENTITY_MODEL:
				return getEntityModel() != null;
			case MetadataPackage.TYPE_META_DATA__CLASS_NAME:
				return CLASS_NAME_EDEFAULT == null ? className != null : !CLASS_NAME_EDEFAULT.equals(className);
			case MetadataPackage.TYPE_META_DATA__CLS:
				return CLS_EDEFAULT == null ? cls != null : !CLS_EDEFAULT.equals(cls);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (className: ");
		result.append(className);
		result.append(", cls: ");
		result.append(cls);
		result.append(')');
		return result.toString();
	}

	public MetadataElement getParentElement() {
		return getEntityModel();
	}
} // TypeMetaDataImpl
