/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: MetadataElementImpl.java,v 1.12 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;

/**
 * @generated
 */
public abstract class MetadataElementImpl extends EObjectImpl implements
		MetadataElement {
	
	private HashMap adapterFactories = new HashMap();
	
	/**
	 * @generated
	 */
	protected MetadataElementImpl() {
		super();
	}

	/**
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getMetadataElement();
	}

	public void delete() {
		eAdapters = null;
	}

	public MetadataElement getAncestor(Class type) {
		if (type == null) {
			return null;
		}
		MetadataElement element = this;
		while (element != null) {
			if (type.isInstance(element)) {
				return element;
			}
			element = element.getParentElement();
		}
		return null;
	}

	public void registerAdapterFactory(IAdapterFactory adapterFactory) {
		Class[] adapterList = adapterFactory.getAdapterList();
		for(int x = 0; x < adapterList.length; x++){
			registerAdapterFactory(adapterList[x], adapterFactory);
		}
	}

	private void registerAdapterFactory(Class adapterClass, IAdapterFactory adapterFactory) {
		List adapters = (List) adapterFactories.get(adapterClass);
		if(adapters == null){
			adapters = Collections.singletonList(adapterFactory);
		}else{
			if(adapters.size() == 1){
				ArrayList newAdapters = new ArrayList(adapters.size()+1);
				newAdapters.add(adapterFactory);
				newAdapters.addAll(adapters);
				adapters = newAdapters;
			}else{
				adapters.add(0, adapterFactory);
			}
		}
		adapterFactories.put(adapterClass, adapters);
	}

	public void unregisterAdapterFactory(IAdapterFactory adapterFactory) {
		Class[] adapterList = adapterFactory.getAdapterList();
		for(int x = 0; x < adapterList.length; x++){
			unregisterAdapterFactory(adapterList[x], adapterFactory);
		}
		
	}
	
	private void unregisterAdapterFactory(Class adapterClass, IAdapterFactory adapterFactory) {
		List adapters = (List) adapterFactories.get(adapterClass);
		if(adapters != null){
			if(adapters.size() == 1 && adapters.contains(adapterFactory)){
				adapterFactories.remove(adapterClass);
			}else{
				adapters.remove(adapterFactory);
			}
		}
	}

	public Object adapt(Class adapterType){
		List adapters = (List) adapterFactories.get(adapterType);
		if(adapters != null){
			IAdapterFactory adapterFactory = (IAdapterFactory) adapters.get(0);
			return adapterFactory.getAdapter(this, adapterType);
		}
        if(getParentElement() != null){
            return getParentElement().adapt(adapterType);
        }
		return null;
	}

} // MetadataElementImpl
