/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: JoinPairImpl.java,v 1.13 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Join Pair</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.JoinPairImpl#getJoin <em>Join</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.JoinPairImpl#getSrc <em>Src</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.JoinPairImpl#getDest <em>Dest</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class JoinPairImpl extends MetadataElementImpl implements JoinPair {
	/**
	 * The cached value of the '{@link #getJoin() <em>Join</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJoin()
	 * @generated
	 * @ordered
	 */
	protected Join join = null;

	/**
	 * The cached value of the '{@link #getSrc() <em>Src</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSrc()
	 * @generated
	 * @ordered
	 */
	protected OrmColumn src = null;

	/**
	 * The cached value of the '{@link #getDest() <em>Dest</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDest()
	 * @generated
	 * @ordered
	 */
	protected OrmColumn dest = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JoinPairImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getJoinPair();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join getJoin() {
		if (join != null && join.eIsProxy()) {
			Join oldJoin = join;
			join = (Join)eResolveProxy((InternalEObject)join);
			if (join != oldJoin) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.JOIN_PAIR__JOIN, oldJoin, join));
			}
		}
		return join;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join basicGetJoin() {
		return join;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetJoin(Join newJoin, NotificationChain msgs) {
		Join oldJoin = join;
		join = newJoin;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.JOIN_PAIR__JOIN, oldJoin, newJoin);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setJoin(Join newJoin) {
		if (newJoin != join) {
			NotificationChain msgs = null;
			if (join != null)
				msgs = ((InternalEObject)join).eInverseRemove(this, MetadataPackage.JOIN__PAIR_LIST, Join.class, msgs);
			if (newJoin != null)
				msgs = ((InternalEObject)newJoin).eInverseAdd(this, MetadataPackage.JOIN__PAIR_LIST, Join.class, msgs);
			msgs = basicSetJoin(newJoin, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.JOIN_PAIR__JOIN, newJoin, newJoin));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn getSrc() {
		if (src != null && src.eIsProxy()) {
			OrmColumn oldSrc = src;
			src = (OrmColumn)eResolveProxy((InternalEObject)src);
			if (src != oldSrc) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.JOIN_PAIR__SRC, oldSrc, src));
			}
		}
		return src;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn basicGetSrc() {
		return src;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSrc(OrmColumn newSrc, NotificationChain msgs) {
		OrmColumn oldSrc = src;
		src = newSrc;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.JOIN_PAIR__SRC, oldSrc, newSrc);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSrc(OrmColumn newSrc) {
		if (newSrc != src) {
			NotificationChain msgs = null;
			if (src != null)
				msgs = ((InternalEObject)src).eInverseRemove(this, MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS, OrmColumn.class, msgs);
			if (newSrc != null)
				msgs = ((InternalEObject)newSrc).eInverseAdd(this, MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS, OrmColumn.class, msgs);
			msgs = basicSetSrc(newSrc, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.JOIN_PAIR__SRC, newSrc, newSrc));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn getDest() {
		if (dest != null && dest.eIsProxy()) {
			OrmColumn oldDest = dest;
			dest = (OrmColumn)eResolveProxy((InternalEObject)dest);
			if (dest != oldDest) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.JOIN_PAIR__DEST, oldDest, dest));
			}
		}
		return dest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn basicGetDest() {
		return dest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDest(OrmColumn newDest, NotificationChain msgs) {
		OrmColumn oldDest = dest;
		dest = newDest;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MetadataPackage.JOIN_PAIR__DEST, oldDest, newDest);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDest(OrmColumn newDest) {
		if (newDest != dest) {
			NotificationChain msgs = null;
			if (dest != null)
				msgs = ((InternalEObject)dest).eInverseRemove(this, MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS, OrmColumn.class, msgs);
			if (newDest != null)
				msgs = ((InternalEObject)newDest).eInverseAdd(this, MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS, OrmColumn.class, msgs);
			msgs = basicSetDest(newDest, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.JOIN_PAIR__DEST, newDest, newDest));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.JOIN_PAIR__JOIN:
					if (join != null)
						msgs = ((InternalEObject)join).eInverseRemove(this, MetadataPackage.JOIN__PAIR_LIST, Join.class, msgs);
					return basicSetJoin((Join)otherEnd, msgs);
				case MetadataPackage.JOIN_PAIR__SRC:
					if (src != null)
						msgs = ((InternalEObject)src).eInverseRemove(this, MetadataPackage.ORM_COLUMN__SRC_JOIN_PAIRS, OrmColumn.class, msgs);
					return basicSetSrc((OrmColumn)otherEnd, msgs);
				case MetadataPackage.JOIN_PAIR__DEST:
					if (dest != null)
						msgs = ((InternalEObject)dest).eInverseRemove(this, MetadataPackage.ORM_COLUMN__DEST_JOIN_PAIRS, OrmColumn.class, msgs);
					return basicSetDest((OrmColumn)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.JOIN_PAIR__JOIN:
					return basicSetJoin(null, msgs);
				case MetadataPackage.JOIN_PAIR__SRC:
					return basicSetSrc(null, msgs);
				case MetadataPackage.JOIN_PAIR__DEST:
					return basicSetDest(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JOIN_PAIR__JOIN:
				if (resolve) return getJoin();
				return basicGetJoin();
			case MetadataPackage.JOIN_PAIR__SRC:
				if (resolve) return getSrc();
				return basicGetSrc();
			case MetadataPackage.JOIN_PAIR__DEST:
				if (resolve) return getDest();
				return basicGetDest();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JOIN_PAIR__JOIN:
				setJoin((Join)newValue);
				return;
			case MetadataPackage.JOIN_PAIR__SRC:
				setSrc((OrmColumn)newValue);
				return;
			case MetadataPackage.JOIN_PAIR__DEST:
				setDest((OrmColumn)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JOIN_PAIR__JOIN:
				setJoin((Join)null);
				return;
			case MetadataPackage.JOIN_PAIR__SRC:
				setSrc((OrmColumn)null);
				return;
			case MetadataPackage.JOIN_PAIR__DEST:
				setDest((OrmColumn)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.JOIN_PAIR__JOIN:
				return join != null;
			case MetadataPackage.JOIN_PAIR__SRC:
				return src != null;
			case MetadataPackage.JOIN_PAIR__DEST:
				return dest != null;
		}
		return eDynamicIsSet(eFeature);
	}

	public MetadataElement getParentElement() {
		return join;
	}

	public void delete() {
		if (join != null) {
			setDest(null);
			setSrc(null);
			join.getPairList().remove(this);
		}
		super.delete();
	}

} //JoinPairImpl
