/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: EntityModelImpl.java,v 1.13 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Entity Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.EntityModelImpl#getTypeList <em>Type List</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EntityModelImpl extends MetadataElementImpl implements EntityModel {
	/**
	 * The cached value of the '{@link #getTypeList() <em>Type List</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getTypeList()
	 * @generated
	 * @ordered
	 */
	protected EList typeList = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EntityModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getEntityModel();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTypeList() {
		if (typeList == null) {
			typeList = new EObjectContainmentWithInverseEList(TypeMetaData.class, this, MetadataPackage.ENTITY_MODEL__TYPE_LIST, MetadataPackage.TYPE_META_DATA__ENTITY_MODEL);
		}
		return typeList;
	}

	public TypeMetaData findTypeByClassName(String className) {
        if(className == null){
            return null;
        }
        for(Iterator it = getTypeList().iterator(); it.hasNext();){
            TypeMetaData metaData = (TypeMetaData) it.next();
            String className2 = metaData.getClassName();
            if(className2 == null){
                continue;
            }
            if(className.equals(className2)){
                return metaData;
            }
            className2 = className2.substring(className2.lastIndexOf('.')+1);
            if(className.equals(className2)){
                return metaData;
            }
        }
        return null;
    }

	public EntityMetaData findEntityBySchemaName(String schemaName) {
        if(schemaName == null){
            return null;
        }
        for(Iterator it = getTypeList().iterator(); it.hasNext();){
            TypeMetaData metaData = (TypeMetaData) it.next();
            if (metaData instanceof EntityMetaData) {
                EntityMetaData entity = (EntityMetaData) metaData;
                if(schemaName.equals(entity.getSchemaName())){
                    return entity;
                }
            }
        }
        return null;
    }

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ENTITY_MODEL__TYPE_LIST:
					return ((InternalEList)getTypeList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ENTITY_MODEL__TYPE_LIST:
					return ((InternalEList)getTypeList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ENTITY_MODEL__TYPE_LIST:
				return getTypeList();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ENTITY_MODEL__TYPE_LIST:
				getTypeList().clear();
				getTypeList().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ENTITY_MODEL__TYPE_LIST:
				getTypeList().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ENTITY_MODEL__TYPE_LIST:
				return typeList != null && !typeList.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	public MetadataElement getParentElement() {
		return null;
	}

    public Set getTopLevelSqlObjects() {
        HashSet sqlObjects = new HashSet();
        for(Iterator types = getTypeList().iterator(); types.hasNext();){
            TypeMetaData typeMetaData = (TypeMetaData) types.next();
            if(typeMetaData instanceof EntityMetaData){
                ((EntityMetaData)typeMetaData).getTopLevelSqlObjects(sqlObjects);
            }
        }
        return sqlObjects;
    }
} // EntityModelImpl
