/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

import org.eclipse.emf.common.util.EList;

/**
 * A table in a database.
 * 
 * @model
 * @generated
 */
public interface OrmTable extends MetadataElement{

	/**
	 * The name of the table.
	 * 
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * @generated
	 */
	void setName(String value);

	/**
	 * The catalog of the table (null if none).
	 * 
	 * @model
	 * @generated
	 */
	String getCatalog();

	/**
	 * @generated
	 */
	void setCatalog(String value);

	/**
	 * The schema of the table (null if none).
	 * 
	 * @model
	 * @generated
	 */
	String getSchema();

	/**
	 * @generated
	 */
	void setSchema(String value);

	/**
	 * The columns making up this table.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.mapping.OrmColumn"
	 *        opposite="table"
	 * @generated
	 */
	EList getColumnList();

	/**
	 * Get the primary key columns of this table.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.OrmColumn"
	 * @generated
	 */
	EList getPrimaryKeyList();

	/**
	 * Virtual tables are not created in the database and just used for
	 * visualization and so on in tooling (e.g. for an embeddable class).
	 * 
	 * @model
	 * @generated
	 */
	boolean isVirtual();

	void setVirtual(boolean value);

	/**
	 * Find the column with name or null if none.
	 * 
	 * @model
	 * @generated
	 */
	OrmColumn findColumn(String name);

	/**
	 * Sort our {@link #getColumnList()} and {@link #getPrimaryKeyList()} by
	 * {@link OrmColumn#getRelativePositionInTable()}.
	 * 
	 * @model
	 * @generated
	 */
	boolean sortColumns();

	/**
	 * The columns making up this table.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.MetadataElement"
	 * @generated
	 */
	MetadataElement getParentElement();

	/**
	 * @generated
	 */
	void setParentElement(MetadataElement value);

    /**
     * @model
     * @generated
     */
    String getComment();

    /**
     * @generated
     */
    void setComment(String value);

} // OrmTable
