/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: MetadataPackage.java,v 1.15 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.jsr220orm.metadata.MetadataFactory
 * @model kind="package"
 * @generated
 */
public interface MetadataPackage extends EPackage{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "metadata";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///org/eclipse/jsr220orm/metadata.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.eclipse.jsr220orm.metadata";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	MetadataPackage eINSTANCE = org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.MetadataElementImpl <em>Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataElementImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getMetadataElement()
	 * @generated
	 */
	int METADATA_ELEMENT = 6;

	/**
	 * The number of structural features of the the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METADATA_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl <em>Attribute Meta Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.AttributeMetaDataImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getAttributeMetaData()
	 * @generated
	 */
	int ATTRIBUTE_META_DATA = 0;

	/**
	 * The feature id for the '<em><b>Entity Meta Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__ENTITY_META_DATA = METADATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Embedded In</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__EMBEDDED_IN = METADATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__NAME = METADATA_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Java Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__JAVA_TYPE = METADATA_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Fetch Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__FETCH_TYPE = METADATA_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__OPTIONAL = METADATA_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Getter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__GETTER_METHOD_NAME = METADATA_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Setter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__SETTER_METHOD_NAME = METADATA_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Mapped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__MAPPED_BY = METADATA_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Inverse List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__INVERSE_LIST = METADATA_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Override Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__OVERRIDE_OF = METADATA_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Override List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA__OVERRIDE_LIST = METADATA_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the the '<em>Attribute Meta Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_META_DATA_FEATURE_COUNT = METADATA_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl <em>Collection Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getCollectionAttribute()
	 * @generated
	 */
	int COLLECTION_ATTRIBUTE = 1;

	/**
	 * The feature id for the '<em><b>Entity Meta Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__ENTITY_META_DATA = ATTRIBUTE_META_DATA__ENTITY_META_DATA;

	/**
	 * The feature id for the '<em><b>Embedded In</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__EMBEDDED_IN = ATTRIBUTE_META_DATA__EMBEDDED_IN;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__NAME = ATTRIBUTE_META_DATA__NAME;

	/**
	 * The feature id for the '<em><b>Java Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__JAVA_TYPE = ATTRIBUTE_META_DATA__JAVA_TYPE;

	/**
	 * The feature id for the '<em><b>Fetch Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__FETCH_TYPE = ATTRIBUTE_META_DATA__FETCH_TYPE;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__OPTIONAL = ATTRIBUTE_META_DATA__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Getter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__GETTER_METHOD_NAME = ATTRIBUTE_META_DATA__GETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Setter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__SETTER_METHOD_NAME = ATTRIBUTE_META_DATA__SETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Mapped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__MAPPED_BY = ATTRIBUTE_META_DATA__MAPPED_BY;

	/**
	 * The feature id for the '<em><b>Inverse List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__INVERSE_LIST = ATTRIBUTE_META_DATA__INVERSE_LIST;

	/**
	 * The feature id for the '<em><b>Override Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__OVERRIDE_OF = ATTRIBUTE_META_DATA__OVERRIDE_OF;

	/**
	 * The feature id for the '<em><b>Override List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__OVERRIDE_LIST = ATTRIBUTE_META_DATA__OVERRIDE_LIST;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__ELEMENT_TYPE = ATTRIBUTE_META_DATA_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>One To Many</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__ONE_TO_MANY = ATTRIBUTE_META_DATA_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Join Table</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__JOIN_TABLE = ATTRIBUTE_META_DATA_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Src Join</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__SRC_JOIN = ATTRIBUTE_META_DATA_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Dest Join</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__DEST_JOIN = ATTRIBUTE_META_DATA_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Cascade Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__CASCADE_TYPE = ATTRIBUTE_META_DATA_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Order By</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE__ORDER_BY = ATTRIBUTE_META_DATA_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the the '<em>Collection Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_ATTRIBUTE_FEATURE_COUNT = ATTRIBUTE_META_DATA_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.TypeMetaDataImpl <em>Type Meta Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.TypeMetaDataImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getTypeMetaData()
	 * @generated
	 */
	int TYPE_META_DATA = 7;

	/**
	 * The feature id for the '<em><b>Entity Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_META_DATA__ENTITY_MODEL = METADATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_META_DATA__CLASS_NAME = METADATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_META_DATA__CLS = METADATA_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>Type Meta Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_META_DATA_FEATURE_COUNT = METADATA_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl <em>Entity Meta Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.EntityMetaDataImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getEntityMetaData()
	 * @generated
	 */
	int ENTITY_META_DATA = 2;

	/**
	 * The feature id for the '<em><b>Entity Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__ENTITY_MODEL = TYPE_META_DATA__ENTITY_MODEL;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__CLASS_NAME = TYPE_META_DATA__CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Cls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__CLS = TYPE_META_DATA__CLS;

	/**
	 * The feature id for the '<em><b>Entity Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__ENTITY_TYPE = TYPE_META_DATA_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Schema Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__SCHEMA_NAME = TYPE_META_DATA_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Super Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__SUPER_ENTITY = TYPE_META_DATA_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Sub Entity List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__SUB_ENTITY_LIST = TYPE_META_DATA_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Attribute List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__ATTRIBUTE_LIST = TYPE_META_DATA_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Primary Key List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__PRIMARY_KEY_LIST = TYPE_META_DATA_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Version List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__VERSION_LIST = TYPE_META_DATA_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Id Generator Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__ID_GENERATOR_TYPE = TYPE_META_DATA_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Id Generator Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__ID_GENERATOR_NAME = TYPE_META_DATA_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Id Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__ID_CLASS = TYPE_META_DATA_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Table</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__TABLE = TYPE_META_DATA_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Secondary Table Join List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST = TYPE_META_DATA_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Access Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__ACCESS_TYPE = TYPE_META_DATA_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Inheritance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__INHERITANCE = TYPE_META_DATA_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Inheritance Specified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__INHERITANCE_SPECIFIED = TYPE_META_DATA_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Discriminator Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__DISCRIMINATOR_TYPE = TYPE_META_DATA_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Discriminator Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__DISCRIMINATOR_VALUE = TYPE_META_DATA_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Discriminator Column</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__DISCRIMINATOR_COLUMN = TYPE_META_DATA_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Super Join</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA__SUPER_JOIN = TYPE_META_DATA_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the the '<em>Entity Meta Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_META_DATA_FEATURE_COUNT = TYPE_META_DATA_FEATURE_COUNT + 19;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.EntityModelImpl <em>Entity Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.EntityModelImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getEntityModel()
	 * @generated
	 */
	int ENTITY_MODEL = 3;

	/**
	 * The feature id for the '<em><b>Type List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_MODEL__TYPE_LIST = METADATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Entity Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_MODEL_FEATURE_COUNT = METADATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.JdoEntityImpl <em>Jdo Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.JdoEntityImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getJdoEntity()
	 * @generated
	 */
	int JDO_ENTITY = 4;

	/**
	 * The feature id for the '<em><b>Entity Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__ENTITY_MODEL = ENTITY_META_DATA__ENTITY_MODEL;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__CLASS_NAME = ENTITY_META_DATA__CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Cls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__CLS = ENTITY_META_DATA__CLS;

	/**
	 * The feature id for the '<em><b>Entity Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__ENTITY_TYPE = ENTITY_META_DATA__ENTITY_TYPE;

	/**
	 * The feature id for the '<em><b>Schema Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__SCHEMA_NAME = ENTITY_META_DATA__SCHEMA_NAME;

	/**
	 * The feature id for the '<em><b>Super Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__SUPER_ENTITY = ENTITY_META_DATA__SUPER_ENTITY;

	/**
	 * The feature id for the '<em><b>Sub Entity List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__SUB_ENTITY_LIST = ENTITY_META_DATA__SUB_ENTITY_LIST;

	/**
	 * The feature id for the '<em><b>Attribute List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__ATTRIBUTE_LIST = ENTITY_META_DATA__ATTRIBUTE_LIST;

	/**
	 * The feature id for the '<em><b>Primary Key List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__PRIMARY_KEY_LIST = ENTITY_META_DATA__PRIMARY_KEY_LIST;

	/**
	 * The feature id for the '<em><b>Version List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__VERSION_LIST = ENTITY_META_DATA__VERSION_LIST;

	/**
	 * The feature id for the '<em><b>Id Generator Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__ID_GENERATOR_TYPE = ENTITY_META_DATA__ID_GENERATOR_TYPE;

	/**
	 * The feature id for the '<em><b>Id Generator Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__ID_GENERATOR_NAME = ENTITY_META_DATA__ID_GENERATOR_NAME;

	/**
	 * The feature id for the '<em><b>Id Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__ID_CLASS = ENTITY_META_DATA__ID_CLASS;

	/**
	 * The feature id for the '<em><b>Table</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__TABLE = ENTITY_META_DATA__TABLE;

	/**
	 * The feature id for the '<em><b>Secondary Table Join List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__SECONDARY_TABLE_JOIN_LIST = ENTITY_META_DATA__SECONDARY_TABLE_JOIN_LIST;

	/**
	 * The feature id for the '<em><b>Access Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__ACCESS_TYPE = ENTITY_META_DATA__ACCESS_TYPE;

	/**
	 * The feature id for the '<em><b>Inheritance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__INHERITANCE = ENTITY_META_DATA__INHERITANCE;

	/**
	 * The feature id for the '<em><b>Inheritance Specified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__INHERITANCE_SPECIFIED = ENTITY_META_DATA__INHERITANCE_SPECIFIED;

	/**
	 * The feature id for the '<em><b>Discriminator Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__DISCRIMINATOR_TYPE = ENTITY_META_DATA__DISCRIMINATOR_TYPE;

	/**
	 * The feature id for the '<em><b>Discriminator Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__DISCRIMINATOR_VALUE = ENTITY_META_DATA__DISCRIMINATOR_VALUE;

	/**
	 * The feature id for the '<em><b>Discriminator Column</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__DISCRIMINATOR_COLUMN = ENTITY_META_DATA__DISCRIMINATOR_COLUMN;

	/**
	 * The feature id for the '<em><b>Super Join</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__SUPER_JOIN = ENTITY_META_DATA__SUPER_JOIN;

	/**
	 * The feature id for the '<em><b>Identity Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY__IDENTITY_TYPE = ENTITY_META_DATA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Jdo Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JDO_ENTITY_FEATURE_COUNT = ENTITY_META_DATA_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.MapAttributeImpl <em>Map Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.MapAttributeImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getMapAttribute()
	 * @generated
	 */
	int MAP_ATTRIBUTE = 5;

	/**
	 * The feature id for the '<em><b>Entity Meta Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__ENTITY_META_DATA = ATTRIBUTE_META_DATA__ENTITY_META_DATA;

	/**
	 * The feature id for the '<em><b>Embedded In</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__EMBEDDED_IN = ATTRIBUTE_META_DATA__EMBEDDED_IN;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__NAME = ATTRIBUTE_META_DATA__NAME;

	/**
	 * The feature id for the '<em><b>Java Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__JAVA_TYPE = ATTRIBUTE_META_DATA__JAVA_TYPE;

	/**
	 * The feature id for the '<em><b>Fetch Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__FETCH_TYPE = ATTRIBUTE_META_DATA__FETCH_TYPE;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__OPTIONAL = ATTRIBUTE_META_DATA__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Getter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__GETTER_METHOD_NAME = ATTRIBUTE_META_DATA__GETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Setter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__SETTER_METHOD_NAME = ATTRIBUTE_META_DATA__SETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Mapped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__MAPPED_BY = ATTRIBUTE_META_DATA__MAPPED_BY;

	/**
	 * The feature id for the '<em><b>Inverse List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__INVERSE_LIST = ATTRIBUTE_META_DATA__INVERSE_LIST;

	/**
	 * The feature id for the '<em><b>Override Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__OVERRIDE_OF = ATTRIBUTE_META_DATA__OVERRIDE_OF;

	/**
	 * The feature id for the '<em><b>Override List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__OVERRIDE_LIST = ATTRIBUTE_META_DATA__OVERRIDE_LIST;

	/**
	 * The feature id for the '<em><b>Key Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__KEY_TYPE = ATTRIBUTE_META_DATA_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE__VALUE_TYPE = ATTRIBUTE_META_DATA_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>Map Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAP_ATTRIBUTE_FEATURE_COUNT = ATTRIBUTE_META_DATA_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.BasicAttributeImpl <em>Basic Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.BasicAttributeImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getBasicAttribute()
	 * @generated
	 */
	int BASIC_ATTRIBUTE = 8;

	/**
	 * The feature id for the '<em><b>Entity Meta Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__ENTITY_META_DATA = ATTRIBUTE_META_DATA__ENTITY_META_DATA;

	/**
	 * The feature id for the '<em><b>Embedded In</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__EMBEDDED_IN = ATTRIBUTE_META_DATA__EMBEDDED_IN;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__NAME = ATTRIBUTE_META_DATA__NAME;

	/**
	 * The feature id for the '<em><b>Java Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__JAVA_TYPE = ATTRIBUTE_META_DATA__JAVA_TYPE;

	/**
	 * The feature id for the '<em><b>Fetch Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__FETCH_TYPE = ATTRIBUTE_META_DATA__FETCH_TYPE;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__OPTIONAL = ATTRIBUTE_META_DATA__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Getter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__GETTER_METHOD_NAME = ATTRIBUTE_META_DATA__GETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Setter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__SETTER_METHOD_NAME = ATTRIBUTE_META_DATA__SETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Mapped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__MAPPED_BY = ATTRIBUTE_META_DATA__MAPPED_BY;

	/**
	 * The feature id for the '<em><b>Inverse List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__INVERSE_LIST = ATTRIBUTE_META_DATA__INVERSE_LIST;

	/**
	 * The feature id for the '<em><b>Override Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__OVERRIDE_OF = ATTRIBUTE_META_DATA__OVERRIDE_OF;

	/**
	 * The feature id for the '<em><b>Override List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__OVERRIDE_LIST = ATTRIBUTE_META_DATA__OVERRIDE_LIST;

	/**
	 * The feature id for the '<em><b>Column</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE__COLUMN = ATTRIBUTE_META_DATA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Basic Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_ATTRIBUTE_FEATURE_COUNT = ATTRIBUTE_META_DATA_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.ReferenceAttributeImpl <em>Reference Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.ReferenceAttributeImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getReferenceAttribute()
	 * @generated
	 */
	int REFERENCE_ATTRIBUTE = 9;

	/**
	 * The feature id for the '<em><b>Entity Meta Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__ENTITY_META_DATA = ATTRIBUTE_META_DATA__ENTITY_META_DATA;

	/**
	 * The feature id for the '<em><b>Embedded In</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__EMBEDDED_IN = ATTRIBUTE_META_DATA__EMBEDDED_IN;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__NAME = ATTRIBUTE_META_DATA__NAME;

	/**
	 * The feature id for the '<em><b>Java Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__JAVA_TYPE = ATTRIBUTE_META_DATA__JAVA_TYPE;

	/**
	 * The feature id for the '<em><b>Fetch Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__FETCH_TYPE = ATTRIBUTE_META_DATA__FETCH_TYPE;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__OPTIONAL = ATTRIBUTE_META_DATA__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Getter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__GETTER_METHOD_NAME = ATTRIBUTE_META_DATA__GETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Setter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__SETTER_METHOD_NAME = ATTRIBUTE_META_DATA__SETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Mapped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__MAPPED_BY = ATTRIBUTE_META_DATA__MAPPED_BY;

	/**
	 * The feature id for the '<em><b>Inverse List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__INVERSE_LIST = ATTRIBUTE_META_DATA__INVERSE_LIST;

	/**
	 * The feature id for the '<em><b>Override Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__OVERRIDE_OF = ATTRIBUTE_META_DATA__OVERRIDE_OF;

	/**
	 * The feature id for the '<em><b>Override List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__OVERRIDE_LIST = ATTRIBUTE_META_DATA__OVERRIDE_LIST;

	/**
	 * The feature id for the '<em><b>Cascade Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__CASCADE_TYPE = ATTRIBUTE_META_DATA_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Join</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__JOIN = ATTRIBUTE_META_DATA_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>One To One</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE__ONE_TO_ONE = ATTRIBUTE_META_DATA_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>Reference Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_ATTRIBUTE_FEATURE_COUNT = ATTRIBUTE_META_DATA_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.JoinImpl <em>Join</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.JoinImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getJoin()
	 * @generated
	 */
	int JOIN = 10;

	/**
	 * The feature id for the '<em><b>Pair List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__PAIR_LIST = METADATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN__COMMENT = METADATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>Join</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_FEATURE_COUNT = METADATA_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.JoinPairImpl <em>Join Pair</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.JoinPairImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getJoinPair()
	 * @generated
	 */
	int JOIN_PAIR = 11;

	/**
	 * The feature id for the '<em><b>Join</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_PAIR__JOIN = METADATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Src</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_PAIR__SRC = METADATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dest</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_PAIR__DEST = METADATA_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>Join Pair</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOIN_PAIR_FEATURE_COUNT = METADATA_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl <em>Orm Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.OrmColumnImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getOrmColumn()
	 * @generated
	 */
	int ORM_COLUMN = 12;

	/**
	 * The feature id for the '<em><b>Table</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__TABLE = METADATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__NAME = METADATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Jdbc Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__JDBC_TYPE = METADATA_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Nullable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__NULLABLE = METADATA_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Insertable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__INSERTABLE = METADATA_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Updatable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__UPDATABLE = METADATA_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__LENGTH = METADATA_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__SCALE = METADATA_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Column Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__COLUMN_DEFINITION = METADATA_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Column Definition Specified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__COLUMN_DEFINITION_SPECIFIED = METADATA_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Original Column Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__ORIGINAL_COLUMN_DEFINITION = METADATA_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Src Join Pairs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__SRC_JOIN_PAIRS = METADATA_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Dest Join Pairs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__DEST_JOIN_PAIRS = METADATA_ELEMENT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Database Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__DATABASE_TYPE = METADATA_ELEMENT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__COMMENT = METADATA_ELEMENT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Relative Position In Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__RELATIVE_POSITION_IN_TABLE = METADATA_ELEMENT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Identity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN__IDENTITY = METADATA_ELEMENT_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the the '<em>Orm Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_COLUMN_FEATURE_COUNT = METADATA_ELEMENT_FEATURE_COUNT + 17;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl <em>Orm Table</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.OrmTableImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getOrmTable()
	 * @generated
	 */
	int ORM_TABLE = 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE__NAME = METADATA_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Catalog</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE__CATALOG = METADATA_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE__SCHEMA = METADATA_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Column List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE__COLUMN_LIST = METADATA_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parent Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE__PARENT_ELEMENT = METADATA_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE__COMMENT = METADATA_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Primary Key List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE__PRIMARY_KEY_LIST = METADATA_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE__VIRTUAL = METADATA_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the the '<em>Orm Table</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORM_TABLE_FEATURE_COUNT = METADATA_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.SimpleTypeMetaDataImpl <em>Simple Type Meta Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.SimpleTypeMetaDataImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getSimpleTypeMetaData()
	 * @generated
	 */
	int SIMPLE_TYPE_META_DATA = 14;

	/**
	 * The feature id for the '<em><b>Entity Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_TYPE_META_DATA__ENTITY_MODEL = TYPE_META_DATA__ENTITY_MODEL;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_TYPE_META_DATA__CLASS_NAME = TYPE_META_DATA__CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Cls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_TYPE_META_DATA__CLS = TYPE_META_DATA__CLS;

	/**
	 * The feature id for the '<em><b>Column</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_TYPE_META_DATA__COLUMN = TYPE_META_DATA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Simple Type Meta Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_TYPE_META_DATA_FEATURE_COUNT = TYPE_META_DATA_FEATURE_COUNT + 1;


	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.CollectionTypeMetaDataImpl <em>Collection Type Meta Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.CollectionTypeMetaDataImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getCollectionTypeMetaData()
	 * @generated
	 */
	int COLLECTION_TYPE_META_DATA = 15;

	/**
	 * The feature id for the '<em><b>Entity Model</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_TYPE_META_DATA__ENTITY_MODEL = TYPE_META_DATA__ENTITY_MODEL;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_TYPE_META_DATA__CLASS_NAME = TYPE_META_DATA__CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Cls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_TYPE_META_DATA__CLS = TYPE_META_DATA__CLS;

	/**
	 * The number of structural features of the the '<em>Collection Type Meta Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_TYPE_META_DATA_FEATURE_COUNT = TYPE_META_DATA_FEATURE_COUNT + 0;


	/**
	 * The meta object id for the '{@link org.eclipse.jsr220orm.metadata.impl.EmbeddedAttributeImpl <em>Embedded Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jsr220orm.metadata.impl.EmbeddedAttributeImpl
	 * @see org.eclipse.jsr220orm.metadata.impl.MetadataPackageImpl#getEmbeddedAttribute()
	 * @generated
	 */
	int EMBEDDED_ATTRIBUTE = 16;

	/**
	 * The feature id for the '<em><b>Entity Meta Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__ENTITY_META_DATA = ATTRIBUTE_META_DATA__ENTITY_META_DATA;

	/**
	 * The feature id for the '<em><b>Embedded In</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__EMBEDDED_IN = ATTRIBUTE_META_DATA__EMBEDDED_IN;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__NAME = ATTRIBUTE_META_DATA__NAME;

	/**
	 * The feature id for the '<em><b>Java Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__JAVA_TYPE = ATTRIBUTE_META_DATA__JAVA_TYPE;

	/**
	 * The feature id for the '<em><b>Fetch Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__FETCH_TYPE = ATTRIBUTE_META_DATA__FETCH_TYPE;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__OPTIONAL = ATTRIBUTE_META_DATA__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Getter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__GETTER_METHOD_NAME = ATTRIBUTE_META_DATA__GETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Setter Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__SETTER_METHOD_NAME = ATTRIBUTE_META_DATA__SETTER_METHOD_NAME;

	/**
	 * The feature id for the '<em><b>Mapped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__MAPPED_BY = ATTRIBUTE_META_DATA__MAPPED_BY;

	/**
	 * The feature id for the '<em><b>Inverse List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__INVERSE_LIST = ATTRIBUTE_META_DATA__INVERSE_LIST;

	/**
	 * The feature id for the '<em><b>Override Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__OVERRIDE_OF = ATTRIBUTE_META_DATA__OVERRIDE_OF;

	/**
	 * The feature id for the '<em><b>Override List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__OVERRIDE_LIST = ATTRIBUTE_META_DATA__OVERRIDE_LIST;

	/**
	 * The feature id for the '<em><b>Attribute List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE__ATTRIBUTE_LIST = ATTRIBUTE_META_DATA_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Embedded Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_ATTRIBUTE_FEATURE_COUNT = ATTRIBUTE_META_DATA_FEATURE_COUNT + 1;

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData <em>Attribute Meta Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Meta Data</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData
	 * @generated
	 */
	EClass getAttributeMetaData();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getEntityMetaData <em>Entity Meta Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Entity Meta Data</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getEntityMetaData()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EReference getAttributeMetaData_EntityMetaData();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getEmbeddedIn <em>Embedded In</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Embedded In</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getEmbeddedIn()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EReference getAttributeMetaData_EmbeddedIn();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getName()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EAttribute getAttributeMetaData_Name();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getJavaType <em>Java Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Java Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getJavaType()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EReference getAttributeMetaData_JavaType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getFetchType <em>Fetch Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fetch Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getFetchType()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EAttribute getAttributeMetaData_FetchType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#isOptional <em>Optional</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Optional</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#isOptional()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EAttribute getAttributeMetaData_Optional();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getGetterMethodName <em>Getter Method Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Getter Method Name</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getGetterMethodName()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EAttribute getAttributeMetaData_GetterMethodName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getSetterMethodName <em>Setter Method Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Setter Method Name</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getSetterMethodName()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EAttribute getAttributeMetaData_SetterMethodName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getMappedBy <em>Mapped By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Mapped By</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getMappedBy()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EReference getAttributeMetaData_MappedBy();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getInverseList <em>Inverse List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Inverse List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getInverseList()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EReference getAttributeMetaData_InverseList();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getOverrideOf <em>Override Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Override Of</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getOverrideOf()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EReference getAttributeMetaData_OverrideOf();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.AttributeMetaData#getOverrideList <em>Override List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Override List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.AttributeMetaData#getOverrideList()
	 * @see #getAttributeMetaData()
	 * @generated
	 */
	EReference getAttributeMetaData_OverrideList();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.CollectionAttribute <em>Collection Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collection Attribute</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionAttribute
	 * @generated
	 */
	EClass getCollectionAttribute();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.CollectionAttribute#getElementType <em>Element Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Element Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionAttribute#getElementType()
	 * @see #getCollectionAttribute()
	 * @generated
	 */
	EReference getCollectionAttribute_ElementType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.CollectionAttribute#getJoinTable <em>Join Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Join Table</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionAttribute#getJoinTable()
	 * @see #getCollectionAttribute()
	 * @generated
	 */
	EReference getCollectionAttribute_JoinTable();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.CollectionAttribute#getSrcJoin <em>Src Join</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Src Join</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionAttribute#getSrcJoin()
	 * @see #getCollectionAttribute()
	 * @generated
	 */
	EReference getCollectionAttribute_SrcJoin();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.CollectionAttribute#getDestJoin <em>Dest Join</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Dest Join</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionAttribute#getDestJoin()
	 * @see #getCollectionAttribute()
	 * @generated
	 */
	EReference getCollectionAttribute_DestJoin();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.CollectionAttribute#getCascadeType <em>Cascade Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cascade Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionAttribute#getCascadeType()
	 * @see #getCollectionAttribute()
	 * @generated
	 */
	EAttribute getCollectionAttribute_CascadeType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.CollectionAttribute#getOrderBy <em>Order By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Order By</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionAttribute#getOrderBy()
	 * @see #getCollectionAttribute()
	 * @generated
	 */
	EAttribute getCollectionAttribute_OrderBy();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.CollectionAttribute#isOneToMany <em>One To Many</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>One To Many</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionAttribute#isOneToMany()
	 * @see #getCollectionAttribute()
	 * @generated
	 */
	EAttribute getCollectionAttribute_OneToMany();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.EntityMetaData <em>Entity Meta Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity Meta Data</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData
	 * @generated
	 */
	EClass getEntityMetaData();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getEntityType <em>Entity Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Entity Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getEntityType()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_EntityType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getSchemaName <em>Schema Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Schema Name</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getSchemaName()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_SchemaName();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getSuperEntity <em>Super Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Super Entity</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getSuperEntity()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_SuperEntity();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getSubEntityList <em>Sub Entity List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Sub Entity List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getSubEntityList()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_SubEntityList();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getAttributeList <em>Attribute List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Attribute List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getAttributeList()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_AttributeList();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getPrimaryKeyList <em>Primary Key List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Primary Key List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getPrimaryKeyList()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_PrimaryKeyList();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getVersionList <em>Version List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Version List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getVersionList()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_VersionList();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getIdGeneratorType <em>Id Generator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id Generator Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getIdGeneratorType()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_IdGeneratorType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getIdGeneratorName <em>Id Generator Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id Generator Name</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getIdGeneratorName()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_IdGeneratorName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getIdClass <em>Id Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id Class</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getIdClass()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_IdClass();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getTable <em>Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Table</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getTable()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_Table();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getSecondaryTableJoinList <em>Secondary Table Join List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Secondary Table Join List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getSecondaryTableJoinList()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_SecondaryTableJoinList();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getAccessType <em>Access Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Access Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getAccessType()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_AccessType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getInheritance <em>Inheritance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inheritance</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getInheritance()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_Inheritance();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#isInheritanceSpecified <em>Inheritance Specified</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inheritance Specified</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#isInheritanceSpecified()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_InheritanceSpecified();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getDiscriminatorType <em>Discriminator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Discriminator Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getDiscriminatorType()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_DiscriminatorType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getDiscriminatorValue <em>Discriminator Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Discriminator Value</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getDiscriminatorValue()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EAttribute getEntityMetaData_DiscriminatorValue();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getDiscriminatorColumn <em>Discriminator Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Discriminator Column</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getDiscriminatorColumn()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_DiscriminatorColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.EntityMetaData#getSuperJoin <em>Super Join</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Super Join</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityMetaData#getSuperJoin()
	 * @see #getEntityMetaData()
	 * @generated
	 */
	EReference getEntityMetaData_SuperJoin();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.EntityModel <em>Entity Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity Model</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityModel
	 * @generated
	 */
	EClass getEntityModel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.jsr220orm.metadata.EntityModel#getTypeList <em>Type List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Type List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EntityModel#getTypeList()
	 * @see #getEntityModel()
	 * @generated
	 */
	EReference getEntityModel_TypeList();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.JdoEntity <em>Jdo Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Jdo Entity</em>'.
	 * @see org.eclipse.jsr220orm.metadata.JdoEntity
	 * @generated
	 */
	EClass getJdoEntity();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.JdoEntity#getIdentityType <em>Identity Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Identity Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.JdoEntity#getIdentityType()
	 * @see #getJdoEntity()
	 * @generated
	 */
	EAttribute getJdoEntity_IdentityType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.MapAttribute <em>Map Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Map Attribute</em>'.
	 * @see org.eclipse.jsr220orm.metadata.MapAttribute
	 * @generated
	 */
	EClass getMapAttribute();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.MapAttribute#getKeyType <em>Key Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Key Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.MapAttribute#getKeyType()
	 * @see #getMapAttribute()
	 * @generated
	 */
	EReference getMapAttribute_KeyType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.MapAttribute#getValueType <em>Value Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Value Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.MapAttribute#getValueType()
	 * @see #getMapAttribute()
	 * @generated
	 */
	EReference getMapAttribute_ValueType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.MetadataElement <em>Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Element</em>'.
	 * @see org.eclipse.jsr220orm.metadata.MetadataElement
	 * @generated
	 */
	EClass getMetadataElement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.TypeMetaData <em>Type Meta Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Meta Data</em>'.
	 * @see org.eclipse.jsr220orm.metadata.TypeMetaData
	 * @generated
	 */
	EClass getTypeMetaData();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.jsr220orm.metadata.TypeMetaData#getEntityModel <em>Entity Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Entity Model</em>'.
	 * @see org.eclipse.jsr220orm.metadata.TypeMetaData#getEntityModel()
	 * @see #getTypeMetaData()
	 * @generated
	 */
	EReference getTypeMetaData_EntityModel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.TypeMetaData#getClassName <em>Class Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class Name</em>'.
	 * @see org.eclipse.jsr220orm.metadata.TypeMetaData#getClassName()
	 * @see #getTypeMetaData()
	 * @generated
	 */
	EAttribute getTypeMetaData_ClassName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.TypeMetaData#getCls <em>Cls</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cls</em>'.
	 * @see org.eclipse.jsr220orm.metadata.TypeMetaData#getCls()
	 * @see #getTypeMetaData()
	 * @generated
	 */
	EAttribute getTypeMetaData_Cls();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.BasicAttribute <em>Basic Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Basic Attribute</em>'.
	 * @see org.eclipse.jsr220orm.metadata.BasicAttribute
	 * @generated
	 */
	EClass getBasicAttribute();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.BasicAttribute#getColumn <em>Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Column</em>'.
	 * @see org.eclipse.jsr220orm.metadata.BasicAttribute#getColumn()
	 * @see #getBasicAttribute()
	 * @generated
	 */
	EReference getBasicAttribute_Column();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.ReferenceAttribute <em>Reference Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference Attribute</em>'.
	 * @see org.eclipse.jsr220orm.metadata.ReferenceAttribute
	 * @generated
	 */
	EClass getReferenceAttribute();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.ReferenceAttribute#getCascadeType <em>Cascade Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cascade Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.ReferenceAttribute#getCascadeType()
	 * @see #getReferenceAttribute()
	 * @generated
	 */
	EAttribute getReferenceAttribute_CascadeType();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.ReferenceAttribute#getJoin <em>Join</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Join</em>'.
	 * @see org.eclipse.jsr220orm.metadata.ReferenceAttribute#getJoin()
	 * @see #getReferenceAttribute()
	 * @generated
	 */
	EReference getReferenceAttribute_Join();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.ReferenceAttribute#isOneToOne <em>One To One</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>One To One</em>'.
	 * @see org.eclipse.jsr220orm.metadata.ReferenceAttribute#isOneToOne()
	 * @see #getReferenceAttribute()
	 * @generated
	 */
	EAttribute getReferenceAttribute_OneToOne();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.Join <em>Join</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Join</em>'.
	 * @see org.eclipse.jsr220orm.metadata.Join
	 * @generated
	 */
	EClass getJoin();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.Join#getPairList <em>Pair List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Pair List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.Join#getPairList()
	 * @see #getJoin()
	 * @generated
	 */
	EReference getJoin_PairList();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.Join#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comment</em>'.
	 * @see org.eclipse.jsr220orm.metadata.Join#getComment()
	 * @see #getJoin()
	 * @generated
	 */
	EAttribute getJoin_Comment();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.JoinPair <em>Join Pair</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Join Pair</em>'.
	 * @see org.eclipse.jsr220orm.metadata.JoinPair
	 * @generated
	 */
	EClass getJoinPair();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.JoinPair#getJoin <em>Join</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Join</em>'.
	 * @see org.eclipse.jsr220orm.metadata.JoinPair#getJoin()
	 * @see #getJoinPair()
	 * @generated
	 */
	EReference getJoinPair_Join();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.JoinPair#getSrc <em>Src</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Src</em>'.
	 * @see org.eclipse.jsr220orm.metadata.JoinPair#getSrc()
	 * @see #getJoinPair()
	 * @generated
	 */
	EReference getJoinPair_Src();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.JoinPair#getDest <em>Dest</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Dest</em>'.
	 * @see org.eclipse.jsr220orm.metadata.JoinPair#getDest()
	 * @see #getJoinPair()
	 * @generated
	 */
	EReference getJoinPair_Dest();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.OrmColumn <em>Orm Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Orm Column</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn
	 * @generated
	 */
	EClass getOrmColumn();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getTable <em>Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Table</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getTable()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EReference getOrmColumn_Table();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getName()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getJdbcType <em>Jdbc Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Jdbc Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getJdbcType()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_JdbcType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#isNullable <em>Nullable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nullable</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#isNullable()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_Nullable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#isInsertable <em>Insertable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Insertable</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#isInsertable()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_Insertable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#isUpdatable <em>Updatable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Updatable</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#isUpdatable()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_Updatable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getLength <em>Length</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Length</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getLength()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_Length();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getScale <em>Scale</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Scale</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getScale()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_Scale();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getColumnDefinition <em>Column Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Column Definition</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getColumnDefinition()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_ColumnDefinition();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#isColumnDefinitionSpecified <em>Column Definition Specified</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Column Definition Specified</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#isColumnDefinitionSpecified()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_ColumnDefinitionSpecified();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getSrcJoinPairs <em>Src Join Pairs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Src Join Pairs</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getSrcJoinPairs()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EReference getOrmColumn_SrcJoinPairs();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getDestJoinPairs <em>Dest Join Pairs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Dest Join Pairs</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getDestJoinPairs()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EReference getOrmColumn_DestJoinPairs();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getDatabaseType <em>Database Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Database Type</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getDatabaseType()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_DatabaseType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comment</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getComment()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_Comment();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getOriginalColumnDefinition <em>Original Column Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Original Column Definition</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getOriginalColumnDefinition()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_OriginalColumnDefinition();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#getRelativePositionInTable <em>Relative Position In Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Relative Position In Table</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#getRelativePositionInTable()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_RelativePositionInTable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmColumn#isIdentity <em>Identity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Identity</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmColumn#isIdentity()
	 * @see #getOrmColumn()
	 * @generated
	 */
	EAttribute getOrmColumn_Identity();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.OrmTable <em>Orm Table</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Orm Table</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable
	 * @generated
	 */
	EClass getOrmTable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmTable#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable#getName()
	 * @see #getOrmTable()
	 * @generated
	 */
	EAttribute getOrmTable_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmTable#getCatalog <em>Catalog</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Catalog</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable#getCatalog()
	 * @see #getOrmTable()
	 * @generated
	 */
	EAttribute getOrmTable_Catalog();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmTable#getSchema <em>Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Schema</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable#getSchema()
	 * @see #getOrmTable()
	 * @generated
	 */
	EAttribute getOrmTable_Schema();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.OrmTable#getColumnList <em>Column List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Column List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable#getColumnList()
	 * @see #getOrmTable()
	 * @generated
	 */
	EReference getOrmTable_ColumnList();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.OrmTable#getParentElement <em>Parent Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Parent Element</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable#getParentElement()
	 * @see #getOrmTable()
	 * @generated
	 */
	EReference getOrmTable_ParentElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmTable#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comment</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable#getComment()
	 * @see #getOrmTable()
	 * @generated
	 */
	EAttribute getOrmTable_Comment();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.OrmTable#getPrimaryKeyList <em>Primary Key List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Primary Key List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable#getPrimaryKeyList()
	 * @see #getOrmTable()
	 * @generated
	 */
	EReference getOrmTable_PrimaryKeyList();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.jsr220orm.metadata.OrmTable#isVirtual <em>Virtual</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Virtual</em>'.
	 * @see org.eclipse.jsr220orm.metadata.OrmTable#isVirtual()
	 * @see #getOrmTable()
	 * @generated
	 */
	EAttribute getOrmTable_Virtual();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.SimpleTypeMetaData <em>Simple Type Meta Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Type Meta Data</em>'.
	 * @see org.eclipse.jsr220orm.metadata.SimpleTypeMetaData
	 * @generated
	 */
	EClass getSimpleTypeMetaData();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.jsr220orm.metadata.SimpleTypeMetaData#getColumn <em>Column</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Column</em>'.
	 * @see org.eclipse.jsr220orm.metadata.SimpleTypeMetaData#getColumn()
	 * @see #getSimpleTypeMetaData()
	 * @generated
	 */
	EReference getSimpleTypeMetaData_Column();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.CollectionTypeMetaData <em>Collection Type Meta Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collection Type Meta Data</em>'.
	 * @see org.eclipse.jsr220orm.metadata.CollectionTypeMetaData
	 * @generated
	 */
	EClass getCollectionTypeMetaData();

	/**
	 * Returns the meta object for class '{@link org.eclipse.jsr220orm.metadata.EmbeddedAttribute <em>Embedded Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Embedded Attribute</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EmbeddedAttribute
	 * @generated
	 */
	EClass getEmbeddedAttribute();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.jsr220orm.metadata.EmbeddedAttribute#getAttributeList <em>Attribute List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Attribute List</em>'.
	 * @see org.eclipse.jsr220orm.metadata.EmbeddedAttribute#getAttributeList()
	 * @see #getEmbeddedAttribute()
	 * @generated
	 */
	EReference getEmbeddedAttribute_AttributeList();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	MetadataFactory getMetadataFactory();

} //MetadataPackage
