/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.ecore.EObject;

/**
 * @model abstract="true"
 * @generated
 */
public interface MetadataElement extends EObject {

	/**
	 * Remove us and things that we own from the model.
	 * 
	 * @model
	 * @generated
	 */
	void delete();

	/**
	 * Returns the first ancestor of this element that has the Class type.
	 * Returns <code>null</code> if no such an ancestor can be found.
	 */
	MetadataElement getAncestor(Class type);

	/**
	 * Returns the element directly containing this element, or
	 * <code>null</code> if this element has no parent.
	 */
	MetadataElement getParentElement();
	
	void registerAdapterFactory(IAdapterFactory adapterFactory);
	
	void unregisterAdapterFactory(IAdapterFactory adapterFactory);

	public Object adapt(Class adapterType);
} // MetadataElement
