/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

import org.eclipse.emf.common.util.EList;

/**
 * A join between two tables.
 * 
 * @model
 * @generated
 */
public interface Join extends MetadataElement {

	/**
	 * The pairs of columns making up this Join ({@link JoinPair}).
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.mapping.JoinPair"
	 *        opposite="join"
	 * @generated
	 */
	EList getPairList();

	/**
	 * Get the source table for the Join i.e. the table that all the source
	 * columns belong to ({@link JoinPair#getSrc()}. This is null if
	 * {@link #getPairList()} is empty.
	 * 
	 * @model
	 */
	OrmTable getSrcTable();

	/**
	 * Get the destination table for the Join i.e. the table that all the dest
	 * columns belong to ({@link JoinPair#getDest()}. This is null if
	 * {@link #getPairList()} is empty.
	 * 
	 * @model
	 */
	OrmTable getDestTable();

	/**
	 * Set comment information for this Join. Typically this will identify
	 * the owner (e.g. the persistent field) in some way.
	 * 
	 * @model
	 * @generated
	 */
	String getComment();

	void setComment(String comment);

	/**
	 * Find the first JoinPair from our {@link #getPairList()} with 
	 * {@link JoinPair#getDest()} == dest or null if none.
	 * 
	 * @model
	 */
	JoinPair findPairForDest(OrmColumn dest);

	/**
	 * Find the first JoinPair from our {@link #getPairList()} with 
	 * {@link JoinPair#getSrc()} == src or null if none.
	 * 
	 * @model
	 */
	JoinPair findPairForSrc(OrmColumn src);

	/**
	 * Find the first JoinPair from our {@link #getPairList()} with 
	 * srcColName.equals({@link JoinPair#getSrc()}.getName()) or null if none.
	 * 
	 * @model
	 */
	JoinPair findPairForSrc(String srcColName);

	/**
	 * Get the {@link JoinPair#getSrc()} columns from all of our pairs in
	 * order.
	 * 
	 * @model kind="operation" type="org.eclipse.jsr220orm.metadata.OrmColumn"
	 */
	EList getSrcColumns();

	/**
	 * Get the {@link JoinPair#getDest()} columns from all of our pairs in
	 * order.
	 * 
	 * @model kind="operation" type="org.eclipse.jsr220orm.metadata.OrmColumn"
	 */
	EList getDestColumns();

}
