/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.internal.adaptors;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;

public class RdbSchemaFactory implements IAdapterFactory{

    private OrmNature nature;

    public RdbSchemaFactory(OrmNature nature) {
        this.nature = nature;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        return nature.getActiveSchema();
    }

    public Class[] getAdapterList() {
        return new Class[] {Schema.class};
    }

}
