/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class OrmPlugin extends AbstractUIPlugin {
	// The shared instance.
	private static OrmPlugin plugin;

	// Resource bundle.
	private ResourceBundle resourceBundle;

	static public final String ID = "org.eclipse.jsr220orm.core";

	/**
	 * The constructor.
	 */
	public OrmPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle
					.getBundle("org.eclipse.jsr220orm.core.CorePluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 */
	public static OrmPlugin getDefault() {
		return plugin;
	}

	public static void log(String title, String message, Throwable e, 
			int severity) {
		log(title, message, new Status(severity, ID, 0, message, e));
	}

	public static void log(Throwable e) {
		String msg = e.toString();
		e.printStackTrace();
		log("Persistence", msg, new Status(IStatus.ERROR, ID, 0, msg, e));
	}
	
	public static void log(String msg, Throwable e) {
		msg = msg + ": " + e;
		e.printStackTrace();
		log("Persistence", msg, new Status(IStatus.ERROR, ID, 0, msg, e));
	}
	
	private static boolean errorDialogUp;
	
	public static void log(String title, String message, IStatus status) {
		getDefault().getLog().log(status);
//        if(status.getSeverity() == IStatus.ERROR){
//            ErrorDialog.openError(PlatformUI.getWorkbench().getDisplay().getActiveShell(), title, message, status);
//        }
	}

	/**
	 * Returns the string from the plugin's resource bundle, or 'key' if not
	 * found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = OrmPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
