/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import java.util.Collections;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.JoinPair;

/**
 * @author dirk
 */
public class ErConnectionEditPart extends AbstractConnectionEditPart {

	private static final PrecisionPoint P_POINT = new PrecisionPoint();

  	private Label label = new Label();

    private GraphicalEditPart mainPart;
  	
	public ErConnectionEditPart(Object object, GraphicalEditPart mainPart) {
        this.mainPart = mainPart;
		setModel(object);
		label.setOpaque(true);
	}
	
	protected IFigure createFigure() {
		PolylineConnection polylineConnection = new PolylineConnection();
//        polylineConnection.setConnectionRouter(new ManhattanConnectionRouter());
//        polylineConnection.setConnectionRouter(new ShortestPathConnectionRouter(mainPart.getFigure()));
        polylineConnection.setRoutingConstraint(Collections.EMPTY_LIST);
        polylineConnection.setTargetDecoration(new PolygonDecoration());
//      PolygonDecoration dec = new PolygonDecoration();
//      dec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
////        ((PolylineConnection)connection).setTargetDecoration(dec);
//		FlowLayout flowLayout = new FlowLayout();
//		flowLayout.setMajorAlignment(FlowLayout.ALIGN_CENTER);
//		polylineConnection.setLayoutManager(flowLayout);
//		polylineConnection.add(label);
//		polylineConnection.setConnectionRouter(new ConnectionRouter() {
//			public Object getConstraint(Connection connection) {
//				// TODO Auto-generated method stub
//				return null;
//			}
//
//			public void invalidate(Connection connection) {
//				// TODO Auto-generated method stub
//
//			}
//
//			public void route(Connection connection) {
//				PointList points = connection.getPoints();
//				points.removeAllPoints();
//				
//				Point src = connection.getSourceAnchor().getReferencePoint();
//				Point tar = connection.getTargetAnchor().getReferencePoint();
//				int x = Math.min(tar.x,src.x)+ Math.abs(tar.x-src.x)/2;
//				Point t1 = new Point(x, tar.y);
//				Point s1 = new Point(x, src.y);
//
//				P_POINT.setLocation(connection.getSourceAnchor().getLocation(s1));
//				connection.translateToRelative(P_POINT);
//				src = new Point(P_POINT);
//
//				P_POINT.setLocation(connection.getTargetAnchor().getLocation(t1));
//				connection.translateToRelative(P_POINT);
//				tar = new Point(P_POINT);
//				x = Math.min(tar.x,src.x)+ Math.abs(tar.x-src.x)/2;
//				t1 = new Point(x, tar.y);
//				s1 = new Point(x, src.y);
//				points.addPoint(src);
//				points.addPoint(s1);
//				points.addPoint(t1);
//				points.addPoint(tar);
//				PolygonDecoration dec = new PolygonDecoration();
//				dec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
////				((PolylineConnection)connection).setTargetDecoration(dec);
//			}
//
//			public void remove(Connection connection) {
//				// TODO Auto-generated method stub
////				PolygonDecoration 
//			}
//
//			public void setConstraint(Connection connection, Object constraint) {
//				// TODO Auto-generated method stub
//
//			}
//		});
		return polylineConnection;
    }

	protected void createEditPolicies() {
	}

    protected void refreshVisuals() {
    	JoinPair joinPair = (JoinPair) getModel();
    	Join join = joinPair.getJoin();
    	if (join != null) {
            label.setText(join.getComment());
        }
    	super.refreshVisuals();
    }
    public void setConstraint(Connection connection, Object constraint) { 
        
    }
}
