/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/*
 * Created on Mar 22, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.part;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/**
 * @author dirk
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ColumnListEditPart extends AbstractGraphicalEditPart {

    private Color color = Display.getCurrent().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND);
 
	public ColumnListEditPart(Object colList) {
		setModel(colList);
	}

	protected IFigure createFigure() {
        Figure f = new Figure();
        f.setBorder(new BaseBorder());
        f.setOpaque(false);
        f.setBackgroundColor(color);
//        GraphLayoutManager contentLayout = new GraphLayoutManager(this); 
//        f.setLayoutManager(contentLayout);
        FlowLayout flowLayout = new FlowLayout(true);
        flowLayout.setMajorSpacing(25);
        flowLayout.setMinorSpacing(25);
        f.setLayoutManager(flowLayout);
        return f;
    }

    protected void createEditPolicies() {
    }

    protected List getModelChildren() {
        ArrayList diagramTables = new ArrayList();
        List columns = (List) getModel();
        for(Iterator it = columns.iterator(); it.hasNext();){
            OrmColumn ormColumn = (OrmColumn) it.next();
            OrmTable ormTable = ormColumn.getTable();
            if(!diagramTables.contains(ormTable)){
                diagramTables.add(ormTable);
            }
        }
        return diagramTables;
    }
   

    public class BaseBorder extends AbstractBorder {
        
        private Color color = Display.getCurrent().getSystemColor(SWT.COLOR_WIDGET_NORMAL_SHADOW);
        private Insets insets = new Insets(3, 3, 4, 1);
        
        public Insets getInsets(IFigure figure) {
            return insets;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setForegroundColor(color);
            tempRect.setBounds(getPaintRectangle(figure, insets));
//            graphics.setForegroundColor(figure.getForegroundColor());
            graphics.drawLine(tempRect.right()-1, tempRect.y, tempRect.right()-1, tempRect.bottom());

            // graphics.drawLine(getPaintRectangle(figure,
            // insets).getBottomLeft(),
            // tempRect.getBottomRight());
        }
    }

}

