/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.io.ast;

import java.util.Map;

import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.generic.reflect.RField;

/**
 * Implementation using an Eclipse AST tree to provide the data. 
 */
public class AstRField extends AstRAnnotatedElement implements RField {

	protected final AstRClass cls;
	protected final VariableDeclarationFragment varDec;
	protected final FieldDeclaration fieldDec;
	protected final ITypeBinding binding;

	public AstRField(AstRClass cls, FieldDeclaration fieldDec, 
			VariableDeclarationFragment varDec, int relativeIndexInOwner) {
		super(cls.getFactory(), fieldDec.modifiers(), 
				cls.getImportListHelper(), relativeIndexInOwner);
		this.cls = cls;
		this.varDec = varDec;
		this.fieldDec = fieldDec;
		binding = fieldDec.getType().resolveBinding();
		initAnnotations();
	}

	public String getName() {
		return varDec.getName().getFullyQualifiedName();
	}

	public String getTypeName() {
		return Utils.getTypeName(binding);
	}
	
	public String toString() {
		return getName();
	}

	public String getFullyQualifiedName() {
		return cls.getFullyQualifiedName() + "." + getName();
	}

	public boolean isField() {
		return true;
	}

	public Map getLocation() {
		return Utils.createMarkerLocation(varDec.getName());
	}

	public RClass getRClass() {
		return cls;
	}

	public String[] getActualTypeArguments() {
		if (binding == null) {
			return null;
		}
		ITypeBinding[] ta = binding.getTypeArguments();
		int n = ta.length;
		if (n == 0) {
			return null;
		}
		String[] ans = new String[n];
		for (int i = 0; i < n; i++) {
			ans[i] = Utils.getTypeName(ta[i]);
		}
		return ans;
	}

}
