/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.views.AbstractMetadataView;
import org.eclipse.jsr220orm.ui.internal.views.provider.OutlineContentProvider;
import org.eclipse.jsr220orm.ui.internal.views.provider.OutlineLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class PersistenceOutline
extends AbstractMetadataView
implements ISelectionProvider {
    public static final String ID = "org.eclipse.jsr220orm.ui.internal.views.PersistenceOutline";
    private TreeViewer treeViewer;
    private Tree tree;
    private MetadataElement rootElement;
    private PropertySheetPage propertySheetPage;
    private ComposedAdapterFactory adapterFactory;
    private boolean busy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void createPartControl(Composite parent) {
        GridLayout parentLayout = new GridLayout();
        parent.setLayout((Layout)parentLayout);
        GridData treeViewerLData = new GridData();
        treeViewerLData.grabExcessHorizontalSpace = true;
        treeViewerLData.grabExcessVerticalSpace = true;
        treeViewerLData.horizontalAlignment = 4;
        treeViewerLData.verticalAlignment = 4;
        this.treeViewer = new TreeViewer(parent, 0);
        this.tree = (Tree)this.treeViewer.getControl();
        this.tree.setLayoutData((Object)treeViewerLData);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new MetadataItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        this.treeViewer.setContentProvider((IContentProvider)new OutlineContentProvider(this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (PersistenceOutline.this.getSite().getPage().getActivePart() == PersistenceOutline.this) {
                    try {
                        PersistenceOutline.this.navigateToSource(event.getSelection());
                    }
                    catch (Exception e) {
                        OrmUiPlugin.logException(e, PersistenceOutline.this.getSite().getShell());
                    }
                }
            }
        });
    }

    protected void navigateToSource(ISelection selection) throws JavaModelException, PartInitException {
        IStructuredSelection sSel = (IStructuredSelection)selection;
        Object obj = sSel.getFirstElement();
        if (obj instanceof MetadataElement) {
            MetadataElement element = (MetadataElement)obj;
            IProject project = (IProject)element.adapt(IProject.class);
            EntityMetaData entity = (EntityMetaData)element.getAncestor(EntityMetaData.class);
            if (project == null || entity == null) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null) {
                return;
            }
            IType iType = javaProject.findType(entity.getClassName());
            if (iType == null) {
                return;
            }
            Object javaElement = iType;
            AttributeMetaData att = (AttributeMetaData)element.getAncestor(AttributeMetaData.class);
            if (att != null) {
                javaElement = att.isField() ? iType.getField(att.getName()) : iType.getMethod(att.getGetterMethodName(), new String[0]);
            }
            if (javaElement != null) {
                this.treeViewer.getControl().setRedraw(false);
                this.busy = true;
                try {
                    IEditorPart openInEditor = EditorUtility.openInEditor((Object)javaElement, (boolean)false);
                    JavaUI.revealInEditor((IEditorPart)openInEditor, (IJavaElement)javaElement);
                }
                finally {
                    this.busy = false;
                    this.treeViewer.getControl().setRedraw(true);
                }
            }
        }
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    private void setTreeRoot(MetadataElement element) {
        Object[] objectArray;
        if (this.treeViewer == null) {
            return;
        }
        this.rootElement = element;
        if (element == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = element;
        }
        Object[] roots = objectArray;
        this.treeViewer.setInput((Object)roots);
        this.treeViewer.setExpandedElements(roots);
    }

    protected void doUpdate(MetadataElement metadataElement) {
        MetadataElement element;
        if (this.busy) {
            return;
        }
        if (metadataElement == null) {
            element = null;
        } else {
            element = metadataElement.getAncestor(EntityMetaData.class);
            if (element == null) {
                element = metadataElement;
            }
        }
        if (element == null || !element.equals(this.rootElement)) {
            this.setTreeRoot(element);
        }
        if (this.treeViewer != null && element != null) {
            IStructuredSelection sSel = (IStructuredSelection)this.treeViewer.getSelection();
            if (sSel != null && sSel.getFirstElement() == metadataElement) {
                return;
            }
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)metadataElement));
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public void dispose() {
        this.adapterFactory.dispose();
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        super.dispose();
    }
}

