/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.ui.internal.views.AbstractMetadataView;
import org.eclipse.jsr220orm.ui.internal.views.provider.ModelContentProvider;
import org.eclipse.jsr220orm.ui.internal.views.provider.ModelLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ModelOutline
extends AbstractMetadataView
implements ISelectionProvider {
    private TreeViewer treeViewer;
    private Tree tree;
    private MetadataElement rootElement;
    private PropertySheetPage propertySheetPage;
    private ComposedAdapterFactory adapterFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createPartControl(Composite parent) {
        GridLayout parentLayout = new GridLayout();
        parent.setLayout((Layout)parentLayout);
        GridData treeViewerLData = new GridData();
        treeViewerLData.grabExcessHorizontalSpace = true;
        treeViewerLData.grabExcessVerticalSpace = true;
        treeViewerLData.horizontalAlignment = 4;
        treeViewerLData.verticalAlignment = 4;
        this.treeViewer = new TreeViewer(parent, 0);
        this.tree = (Tree)this.treeViewer.getControl();
        this.tree.setLayoutData((Object)treeViewerLData);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new MetadataItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        this.treeViewer.setContentProvider((IContentProvider)new ModelContentProvider(this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider(this.adapterFactory));
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    private void setTreeRoot(MetadataElement element) {
        if (element == null || this.treeViewer == null) {
            return;
        }
        this.rootElement = element;
        Object[] roots = new Object[]{this.rootElement};
        this.treeViewer.setInput((Object)roots);
        this.treeViewer.setExpandedElements(roots);
    }

    protected void doUpdate(MetadataElement metadataElement) {
        if (metadataElement == null) {
            return;
        }
        MetadataElement element = metadataElement.getAncestor(EntityMetaData.class);
        if (element == null) {
            element = metadataElement;
        }
        if (element != null && !element.equals(this.rootElement)) {
            this.setTreeRoot(element);
        }
        if (this.treeViewer != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)metadataElement));
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage();
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ModelOutline.this.propertySheetPage.selectionChanged((IWorkbenchPart)ModelOutline.this, event.getSelection());
                }
            });
        }
        return this.propertySheetPage;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public void dispose() {
        this.adapterFactory.dispose();
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        super.dispose();
    }
}

