/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.mapping.AddPersistenceComposite;
import org.eclipse.jsr220orm.ui.internal.mapping.MainMetadataUISelector;
import org.eclipse.jsr220orm.ui.internal.mapping.NewEntityComposite;
import org.eclipse.jsr220orm.ui.internal.views.AbstractMetadataView;
import org.eclipse.jsr220orm.ui.mapping.MappingUIProvider;
import org.eclipse.jsr220orm.ui.mapping.MetadataUISelector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;

public class MappingView
extends AbstractMetadataView {
    public static final String ID_VIEW = "org.eclipse.jsr220orm.ui.internal.views.MappingView";
    private MetadataUISelector mappingUISelector;
    private NewEntityComposite newEntityComposite;
    private AddPersistenceComposite addPersistenceComposite;
    private PageBook book;
    private Control defaultPage;
    private FormToolkit toolkit;
    private boolean foundEntity;

    public Control getDefaultPage() {
        if (this.defaultPage == null) {
            this.defaultPage = this.createDefaultPage(this.book, this.toolkit);
        }
        return this.defaultPage;
    }

    protected Control createDefaultPage(PageBook book, FormToolkit toolkit) {
        FormText message = toolkit.createFormText((Composite)book, false);
        message.setText("No Mapping info to display.", false, false);
        return message;
    }

    protected void doUpdate(MetadataElement element) {
        MappingUIProvider provider = null;
        if (element != null) {
            provider = this.getMappingUISelector().getMappingUIProvider(element, (Composite)this.book, this.toolkit);
        }
        if (provider == null) {
            this.unknownPartSelected();
        } else {
            this.book.showPage(provider.getControl(element, (Composite)this.book, this.toolkit));
        }
    }

    public MetadataUISelector getMappingUISelector() {
        if (this.mappingUISelector == null) {
            this.mappingUISelector = this.createMappingUISelector();
        }
        return this.mappingUISelector;
    }

    private MetadataUISelector createMappingUISelector() {
        return new MainMetadataUISelector();
    }

    public void createPartControl(Composite parent) {
        this.toolkit = this.createToolkit(parent.getDisplay());
        this.book = new PageBook(parent, 0);
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(OrmUiPlugin.getDefault().getFormColors(display));
    }

    public void setFocus() {
        this.book.setFocus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unknownPartSelected() {
        try {
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
            if (activeEditor == null) {
                this.book.showPage(this.getDefaultPage());
                return;
            }
            IEditorInput editorInput = activeEditor.getEditorInput();
            ICompilationUnit unit = manager.getWorkingCopy(editorInput);
            if (unit != null) {
                this.unknownUnitSelected(unit);
                return;
            }
            try {
                manager.connect(editorInput);
                unit = manager.getWorkingCopy(editorInput);
                this.unknownUnitSelected(unit);
                return;
            }
            catch (CoreException coreException) {
                this.book.showPage(this.getDefaultPage());
            }
            finally {
                manager.disconnect(editorInput);
            }
            manager.disconnect(editorInput);
            return;
        }
        catch (Exception e) {
            this.book.showPage(this.getDefaultPage());
            OrmUiPlugin.log(e);
        }
    }

    protected void unknownUnitSelected(ICompilationUnit unit) throws CoreException {
        if (unit == null) {
            this.book.showPage(this.getDefaultPage());
            return;
        }
        IJavaProject javaProject = (IJavaProject)unit.getAncestor(2);
        IProject project = javaProject.getProject();
        OrmNature nature = (OrmNature)project.getNature("org.eclipse.jsr220orm.core.nature");
        if (nature != null) {
            NewEntityComposite newEntity = this.getNewEntityComposite(this.book, this.toolkit);
            newEntity.setCompilationUnit(unit);
            this.book.showPage((Control)newEntity.getComposite());
        } else {
            AddPersistenceComposite addPersistenceComposite = this.getAddPersistenceComposite(this.book, this.toolkit);
            addPersistenceComposite.setIProject(project);
            this.book.showPage((Control)addPersistenceComposite.getComposite());
        }
    }

    private NewEntityComposite getNewEntityComposite(PageBook book2, FormToolkit toolkit2) {
        if (this.newEntityComposite == null) {
            this.newEntityComposite = new NewEntityComposite(this);
            this.newEntityComposite.createComposite((Composite)book2, 0, toolkit2);
        }
        return this.newEntityComposite;
    }

    private AddPersistenceComposite getAddPersistenceComposite(PageBook book2, FormToolkit toolkit2) {
        if (this.addPersistenceComposite == null) {
            this.addPersistenceComposite = new AddPersistenceComposite(this);
            this.addPersistenceComposite.createComposite((Composite)book2, 0, toolkit2);
        }
        return this.addPersistenceComposite;
    }
}

