/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.TypeMetaData;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.selection.PersistenceSelection;
import org.eclipse.jsr220orm.ui.internal.selection.PersistenceSelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ITextEditorSelectionProvider
implements ISelectionChangedListener,
PersistenceSelectionProvider {
    private ITextEditor textEditor;
    private List listeners = new ArrayList(5);
    private ICompilationUnit unit;
    private Object lastSelection;

    public void installITextEditor(ITextEditor textEditor, ICompilationUnit unit) {
        this.textEditor = textEditor;
        this.unit = unit;
        ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
        this.install(selectionProvider);
    }

    public void uninstallITextEditor() {
        if (this.textEditor != null) {
            ISelectionProvider selectionProvider = this.textEditor.getSelectionProvider();
            if (selectionProvider != null) {
                this.uninstall(selectionProvider);
            }
            this.textEditor = null;
        }
    }

    private void install(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private void uninstall(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        PersistenceSelection selection = this.getNewSelection(event.getSelection());
        if (selection != null && !selection.isEmpty()) {
            this.setSelection(selection);
        }
    }

    public PersistenceSelection getNewSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            Object firstElement = structSel.getFirstElement();
            if (firstElement instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)firstElement;
                try {
                    return this.getSelectionForJavaElement(element);
                }
                catch (CoreException e) {
                    OrmUiPlugin.log(e);
                }
            }
        } else if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int offset = textSelection.getOffset();
            try {
                return this.getSelectionForJavaElement(this.getJavaElement(this.unit, offset));
            }
            catch (CoreException e1) {
                OrmUiPlugin.log(e1);
                return null;
            }
        }
        return null;
    }

    public IJavaElement getJavaElement(ICompilationUnit unit, int offset) {
        block4: {
            if (unit != null) {
                try {
                    IJavaElement element = unit.getElementAt(offset);
                    if (element == null) {
                        return unit;
                    }
                    return element;
                }
                catch (JavaModelException x) {
                    if (x.isDoesNotExist()) break block4;
                    OrmUiPlugin.log(x);
                }
            }
        }
        return null;
    }

    private PersistenceSelection getSelectionForJavaElement(IJavaElement element) throws CoreException {
        ICompilationUnit unit;
        if (element == null) {
            return null;
        }
        String className = null;
        String fieldName = null;
        String methodName = null;
        IType classElement = (IType)element.getAncestor(7);
        IJavaElement fieldElement = element.getAncestor(8);
        IJavaElement methodElement = element.getAncestor(9);
        if (classElement == null && (unit = (ICompilationUnit)element.getAncestor(5)) != null) {
            classElement = unit.findPrimaryType();
        }
        if (classElement != null) {
            className = classElement.getFullyQualifiedName();
        }
        if (fieldElement != null) {
            fieldName = fieldElement.getElementName();
        }
        if (methodElement != null) {
            methodName = methodElement.getElementName();
        }
        if (className != null) {
            IProject project = element.getJavaProject().getProject();
            OrmNature nature = (OrmNature)project.getNature("org.eclipse.jsr220orm.core.nature");
            if (nature == null) {
                return null;
            }
            OrmProject ormProject = nature.getActiveOrmProject();
            if (ormProject == null) {
                return null;
            }
            EntityModel model = ormProject.getModel();
            if (model == null) {
                return null;
            }
            TypeMetaData typeMetaData = model.findTypeByClassName(className);
            if (typeMetaData instanceof EntityMetaData) {
                EntityMetaData entityMetaData = (EntityMetaData)typeMetaData;
                IEntityModelManager modelManager = ormProject.getModelManager();
                AttributeMetaData attributeMetaData = null;
                if (fieldName != null) {
                    attributeMetaData = modelManager.getAttributeMetaData(entityMetaData, fieldName, false);
                } else if (methodName != null) {
                    attributeMetaData = modelManager.getAttributeMetaData(entityMetaData, methodName, true);
                }
                if (attributeMetaData != null) {
                    return this.createSelection((MetadataElement)attributeMetaData);
                }
                return this.createSelection((MetadataElement)typeMetaData);
            }
        }
        return null;
    }

    private PersistenceSelection createSelection(final MetadataElement element) {
        PersistenceSelection selection = new PersistenceSelection(){

            public boolean isEmpty() {
                return element == null;
            }

            public MetadataElement getSelectedElement() {
                return element;
            }
        };
        return selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        PersistenceSelection selection;
        ISelectionProvider selectionProvider = this.textEditor.getSelectionProvider();
        if (selectionProvider != null && (selection = this.getNewSelection(selectionProvider.getSelection())) != null && !selection.isEmpty()) {
            return selection;
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof PersistenceSelection)) {
            return;
        }
        ((PersistenceSelection)selection).getSelectedElement();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        this.fireSelectionChanged(event);
    }

    private void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listenersArray = this.listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listenersArray[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }
}

