/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ColumnConnectionAnchor
extends AbstractConnectionAnchor {
    protected ColumnConnectionAnchor() {
    }

    public ColumnConnectionAnchor(IFigure owner) {
        super(owner);
    }

    public Point getLocation(Point reference) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBox());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute((Translatable)r);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        int x = centerX < (float)reference.x ? r.x + r.width : r.x;
        return new Point(x, Math.round(centerY));
    }

    protected Rectangle getBox() {
        return this.getOwner().getBounds();
    }

    public Point getReferencePoint() {
        Point ref = this.getBox().getCenter();
        this.getOwner().translateToAbsolute((Translatable)ref);
        return ref;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnConnectionAnchor) {
            ColumnConnectionAnchor other = (ColumnConnectionAnchor)((Object)obj);
            return other.getOwner() == this.getOwner() && other.getBox().equals((Object)this.getBox());
        }
        return false;
    }

    public int hashCode() {
        if (this.getOwner() != null) {
            return this.getOwner().hashCode();
        }
        return super.hashCode();
    }
}

