/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io.ast;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.jsr220orm.generic.io.AnnotationRegistry;
import org.eclipse.jsr220orm.generic.io.ast.AstAnnotationProxyHandler;
import org.eclipse.jsr220orm.generic.io.ast.AstRAnnotatedElement;
import org.eclipse.jsr220orm.generic.io.ast.AstRClass;
import org.eclipse.jsr220orm.generic.io.ast.AstState;
import org.eclipse.jsr220orm.generic.io.ast.ImportListHelper;
import org.eclipse.jsr220orm.generic.reflect.RClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstRClassFactory {
    protected final IJavaProject javaProject;
    protected final ASTParser parser;
    protected final AnnotationRegistry annotationRegistry;
    protected Map<String, RClass> nameClassMap = new HashMap<String, RClass>();
    protected AstState astState;
    protected static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    public AstRClassFactory(IJavaProject javaProject, AnnotationRegistry annotationRegistry) {
        this.javaProject = javaProject;
        this.annotationRegistry = annotationRegistry;
        this.parser = ASTParser.newParser((int)3);
    }

    public void begin() {
        this.begin(null);
    }

    public void begin(AstState astState) {
        this.nameClassMap.clear();
        if (astState == null) {
            astState = new AstState();
        }
        this.astState = astState;
    }

    public AstState finish() {
        this.nameClassMap.clear();
        AstState ans = this.astState;
        this.astState = null;
        return ans;
    }

    public RClass findClass(String fullClassName, boolean forModification) {
        RClass ans = this.nameClassMap.get(fullClassName);
        if (ans == null) {
            try {
                if (!this.javaProject.isOpen()) {
                    return null;
                }
                IType type = this.javaProject.findType(fullClassName);
                if (type == null) {
                    return null;
                }
                ICompilationUnit cu = type.getCompilationUnit();
                boolean wasWC = cu.isWorkingCopy();
                if (forModification && !wasWC) {
                    EditorUtility.openInEditor((Object)type, (boolean)false);
                }
                if (cu == null) {
                    return null;
                }
                this.parser.setSource(cu);
                this.parser.setResolveBindings(true);
                CompilationUnit root = (CompilationUnit)this.parser.createAST(null);
                TypeDeclaration td = this.findTypeDeclaration(root, type.getElementName());
                ImportListHelper importListHelper = new ImportListHelper(root);
                ans = new AstRClass(this, td, fullClassName, cu, root, importListHelper);
                this.nameClassMap.put(fullClassName, ans);
            }
            catch (Exception e) {
                OrmPlugin.log((Throwable)e);
            }
        }
        return ans;
    }

    protected TypeDeclaration findTypeDeclaration(CompilationUnit root, String className) {
        for (Object o : root.types()) {
            TypeDeclaration td;
            if (!(o instanceof TypeDeclaration) || !(td = (TypeDeclaration)o).getName().getFullyQualifiedName().equals(className)) continue;
            return td;
        }
        return null;
    }

    public AnnotationRegistry getAnnotationRegistry() {
        return this.annotationRegistry;
    }

    public AstState getAstState() {
        return this.astState;
    }

    public Map<Class, Annotation> createAnnotations(AstRAnnotatedElement owner, Iterator i, ImportListHelper importListHelper) {
        HashMap<Class, Annotation> ans = new HashMap<Class, Annotation>();
        while (i.hasNext()) {
            org.eclipse.jdt.core.dom.Annotation ann;
            Class annotationType;
            Object o = i.next();
            if (!(o instanceof org.eclipse.jdt.core.dom.Annotation) || (annotationType = this.annotationRegistry.getClass((ann = (org.eclipse.jdt.core.dom.Annotation)o).getTypeName().getFullyQualifiedName())) == null) continue;
            AstAnnotationProxyHandler h = new AstAnnotationProxyHandler(owner, annotationType, importListHelper, ann, null);
            ans.put(annotationType, h.newProxy());
        }
        return ans;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }
}

