/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.generic.io.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jsr220orm.generic.Utils;
import org.eclipse.jsr220orm.generic.io.ast.AstRAnnotatedElement;
import org.eclipse.jsr220orm.generic.io.ast.AstRClassFactory;
import org.eclipse.jsr220orm.generic.io.ast.AstRField;
import org.eclipse.jsr220orm.generic.io.ast.AstRMethod;
import org.eclipse.jsr220orm.generic.io.ast.ImportListHelper;
import org.eclipse.jsr220orm.generic.reflect.RClass;
import org.eclipse.jsr220orm.generic.reflect.RField;
import org.eclipse.jsr220orm.generic.reflect.RMethod;

public class AstRClass
extends AstRAnnotatedElement
implements RClass {
    protected final TypeDeclaration typeDec;
    protected final ICompilationUnit typeCu;
    protected final CompilationUnit root;
    protected final String fullClassName;
    protected AstRField[] fields;
    protected Map<String, RField> fieldMap;
    protected AstRMethod[] methods;
    protected Map<String, RMethod> methodMap;
    protected int modifiers = -1;

    public AstRClass(AstRClassFactory factory, TypeDeclaration typeDec, String fullClassName, ICompilationUnit typeCu, CompilationUnit root, ImportListHelper importListHelper) {
        super(factory, typeDec.modifiers(), importListHelper, 0);
        this.typeDec = typeDec;
        this.fullClassName = fullClassName;
        this.typeCu = typeCu;
        this.root = root;
        this.initAnnotations();
    }

    public TypeDeclaration getTypeDec() {
        return this.typeDec;
    }

    public ICompilationUnit getTypeCu() {
        return this.typeCu;
    }

    public CompilationUnit getRoot() {
        return this.root;
    }

    public String getName() {
        return this.fullClassName;
    }

    public String getSimpleName() {
        return this.typeDec.getName().getFullyQualifiedName();
    }

    public String getFullyQualifiedName() {
        return this.fullClassName;
    }

    public String getTypeName() {
        return this.getFullyQualifiedName();
    }

    public boolean isTypeEnum() {
        return false;
    }

    public boolean isTypeSerializable() {
        return false;
    }

    public RField[] getDeclaredFields() {
        if (this.fields == null) {
            FieldDeclaration[] all = this.typeDec.getFields();
            int n = all.length;
            ArrayList<AstRField> list = new ArrayList<AstRField>(n);
            int i = 0;
            while (i < n) {
                for (VariableDeclarationFragment varDecl : all[i].fragments()) {
                    list.add(new AstRField(this, (FieldDeclaration)varDecl.getParent(), varDecl, i));
                }
                ++i;
            }
            n = list.size();
            this.fields = new AstRField[n];
            list.toArray(this.fields);
        }
        return this.fields;
    }

    public RMethod[] getDeclaredMethods() {
        if (this.methods == null) {
            MethodDeclaration[] all = this.typeDec.getMethods();
            int n = all.length;
            this.methods = new AstRMethod[n];
            int i = 0;
            while (i < n) {
                this.methods[i] = new AstRMethod(this, all[i], i);
                ++i;
            }
        }
        return this.methods;
    }

    public String getSuperclassName() {
        Type st = this.typeDec.getSuperclassType();
        if (st == null) {
            return null;
        }
        ITypeBinding resolveBinding = st.resolveBinding();
        if (resolveBinding != null) {
            return resolveBinding.getQualifiedName();
        }
        return null;
    }

    public RField getDeclaredField(String name) {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap<String, RField>();
            this.getDeclaredFields();
            int i = this.fields.length - 1;
            while (i >= 0) {
                AstRField f = this.fields[i];
                this.fieldMap.put(f.getName(), f);
                --i;
            }
        }
        return this.fieldMap.get(name);
    }

    public RMethod getDeclaredMethod(String name) {
        if (this.methodMap == null) {
            this.methodMap = new HashMap<String, RMethod>();
            this.getDeclaredMethods();
            int i = this.methods.length - 1;
            while (i >= 0) {
                AstRMethod m = this.methods[i];
                this.methodMap.put(m.getName(), m);
                --i;
            }
        }
        return this.methodMap.get(name);
    }

    public boolean isField() {
        return false;
    }

    public Map getLocation() {
        return Utils.createMarkerLocation((ASTNode)this.typeDec.getName());
    }

    public RClass getRClass() {
        return null;
    }

    public String[] getActualTypeArguments() {
        return null;
    }
}

