/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaNode;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaResourceModel;
import org.eclipse.jpt.core.context.JoiningStrategy;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.MappedByJoiningStrategy;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaManyToOneMapping;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.SynchronousJpaProjectUpdater;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.JPADiagramEditor;
import org.eclipse.jpt.ui.diagrameditor.internal.facade.EclipseFacade;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.AddAttributeFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.AddRelationFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.RemoveAttributeFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.RemoveRelationFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.JPAEditorDiagramTypeProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.AbstractRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.BidirectionalRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.IRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.util.EntityChangeListener;
import org.eclipse.jpt.ui.diagrameditor.internal.util.GraphicsUpdater;
import org.eclipse.jpt.ui.diagrameditor.internal.util.IEclipseFacade;
import org.eclipse.jpt.ui.diagrameditor.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.ui.diagrameditor.internal.util.IJpaSolver;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorConstants;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtilImpl;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPASolver
implements IResourceChangeListener,
IJpaSolver {
    private static Set<JPASolver> solversSet = new HashSet<JPASolver>();
    private static WorkingCopyChangeListener wclsnr = null;
    private Hashtable<String, Object> keyToBO;
    private WeakHashMap<JpaProject, WeakReference<CollectionChangeListener>> projectToEntityListener;
    private WeakHashMap<JavaPersistentType, WeakReference<PropertyChangeListener>> entityToPropListener;
    private WeakHashMap<JavaPersistentAttribute, WeakReference<AttributePropertyChangeListener>> attributeToPropListener;
    private WeakHashMap<JavaPersistentAttribute, WeakReference<AttributeMappingOptionalityChangeListener>> attributeMappingOptionalityToPropListener;
    private WeakHashMap<JavaPersistentAttribute, WeakReference<AttributeJoiningStrategyPropertyChangeListener>> attributeJoiningStrategyToPropListener;
    private WeakHashMap<JavaPersistentAttribute, WeakReference<AttributeRelationshipReferencePropertyChangeListener>> attributeRelationshipReferenceToPropListener;
    private WeakHashMap<JavaPersistentType, WeakReference<ListChangeListener>> entityToAtListener;
    private WeakHashMap<JavaPersistentType, WeakReference<StateChangeListener>> entityToStateListener;
    private EntityChangeListener entityNameListener;
    private IJPAEditorFeatureProvider featureProvider;
    private HashSet<String> removeIgnore = new HashSet();
    private HashSet<String> removeRelIgnore = new HashSet();
    private HashSet<String> addIgnore = new HashSet();
    private Hashtable<String, IRelation> attribToRel = new Hashtable();
    private static final String SEPARATOR = "-";
    private IEclipseFacade eclipseFacade;
    private IJPAEditorUtil util = null;
    public static boolean ignoreEvents = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPASolver() {
        this(EclipseFacade.INSTANCE, new JPAEditorUtilImpl());
        Class<JPASolver> clazz = JPASolver.class;
        synchronized (JPASolver.class) {
            if (wclsnr == null) {
                wclsnr = new WorkingCopyChangeListener();
                JavaCore.addElementChangedListener((IElementChangedListener)wclsnr, (int)5);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            solversSet.add(this);
            return;
        }
    }

    public JPASolver(IEclipseFacade eclipseFacade, IJPAEditorUtil util) {
        this.eclipseFacade = eclipseFacade;
        eclipseFacade.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
        this.keyToBO = new Hashtable();
        this.projectToEntityListener = new WeakHashMap();
        this.entityToPropListener = new WeakHashMap();
        this.attributeToPropListener = new WeakHashMap();
        this.attributeMappingOptionalityToPropListener = new WeakHashMap();
        this.attributeJoiningStrategyToPropListener = new WeakHashMap();
        this.attributeRelationshipReferenceToPropListener = new WeakHashMap();
        this.entityToAtListener = new WeakHashMap();
        this.entityToStateListener = new WeakHashMap();
        this.entityNameListener = new EntityChangeListener(this);
        this.entityNameListener.setName("Entity Name Change Listener");
        this.util = util;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.closeDiagramEditorIfProjectIsDeleted(event);
        this.unregisterDeltedEntity(event);
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(null, true);
        HashSet<IFile> filesToUpdate = new HashSet<IFile>();
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().getType() == 1) {
                filesToUpdate.add((IFile)delta.getResource());
            }
            ++n2;
        }
        boolean updateEditor = false;
        block1: for (IFile file : filesToUpdate) {
            for (JavaPersistentType jpt : this.entityToPropListener.keySet()) {
                if (!jpt.getResource().equals((Object)file)) continue;
                PictogramElement element = this.featureProvider.getPictogramElementForBusinessObject(jpt);
                if (element == null) continue block1;
                updateEditor = true;
                break block1;
            }
        }
        if (updateEditor) {
            this.eclipseFacade.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JPASolver.this.featureProvider.getDiagramTypeProvider().getDiagramEditor().refresh();
                }
            });
        }
    }

    public void addRemoveIgnore(String atName) {
        this.removeIgnore.add(atName);
    }

    public void addRemoveRelIgnore(String atName) {
        this.removeRelIgnore.add(atName);
    }

    public void addJPTForUpdate(String jptName) {
        this.entityNameListener.addJPTForUpdate(jptName);
    }

    public void addAddIgnore(String atName) {
        this.addIgnore.add(atName);
    }

    public HashSet<String> getAddIgnore() {
        return this.addIgnore;
    }

    public void stopThread() {
        this.entityNameListener.stopThread();
        this.entityNameListener = null;
    }

    public synchronized EntityChangeListener getMonitor() {
        if (this.entityNameListener == null) {
            this.entityNameListener = new EntityChangeListener(this);
            this.entityNameListener.setName("Entity Name Change Listener");
        }
        return this.entityNameListener;
    }

    @Override
    public void setFeatureProvider(IJPAEditorFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
        this.entityNameListener.setFeatureProvider(featureProvider);
        this.entityNameListener.setDaemon(true);
        this.entityNameListener.start();
    }

    public String getKeyForBusinessObject(Object bo) {
        if (bo == null) {
            return "";
        }
        if (bo instanceof JavaPersistentType) {
            JavaPersistentType jpt = (JavaPersistentType)bo;
            String name = jpt.getName();
            return name;
        }
        if (bo instanceof AbstractRelation) {
            return ((AbstractRelation)bo).getId();
        }
        if (bo instanceof JavaPersistentAttribute) {
            JavaPersistentAttribute at = (JavaPersistentAttribute)bo;
            return String.valueOf(((PersistentType)at.getParent()).getName()) + SEPARATOR + at.getName();
        }
        return bo.toString();
    }

    public Object getBusinessObjectForKey(String key) {
        if (key == null) {
            return null;
        }
        return this.keyToBO.get(key);
    }

    protected String produceOwnerKeyForRel(AbstractRelation rel) {
        return this.produceKeyForRel(rel.getOwner(), rel.getOwnerAttributeName());
    }

    protected String produceInverseKeyForRel(AbstractRelation rel) {
        return this.produceKeyForRel(rel.getInverse(), rel.getInverseAttributeName());
    }

    public String produceKeyForRel(JavaPersistentType jpt, String attributeName) {
        return String.valueOf(jpt.getName()) + SEPARATOR + attributeName;
    }

    public void addKeyBusinessObject(String key, Object bo) {
        this.keyToBO.put(key, bo);
        if (bo instanceof JavaPersistentType) {
            JavaPersistentType jpt = (JavaPersistentType)bo;
            JpaProject proj = jpt.getJpaProject();
            this.addListenersToProject(proj);
            this.addListenersToEntity(jpt);
            PictogramElement pe = this.featureProvider.getPictogramElementForBusinessObject(jpt);
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, JPAEditorConstants.PROP_ENTITY_CLASS_NAME, jpt.getName());
        } else if (bo instanceof AbstractRelation) {
            AbstractRelation rel = (AbstractRelation)bo;
            this.attribToRel.put(this.produceOwnerKeyForRel(rel), rel);
            if (rel instanceof BidirectionalRelation) {
                this.attribToRel.put(this.produceInverseKeyForRel(rel), rel);
            }
        } else if (bo instanceof JavaPersistentAttribute) {
            this.addPropertiesListenerToAttribute((JavaPersistentAttribute)bo);
        }
    }

    public Object remove(String key) {
        if (key == null) {
            return null;
        }
        Object o = this.keyToBO.remove(key);
        if (o instanceof JavaPersistentType) {
            CollectionChangeListener ch;
            WeakReference<CollectionChangeListener> ref;
            JavaPersistentType jpt = (JavaPersistentType)o;
            ListIterator atts = jpt.attributes();
            while (atts.hasNext()) {
                JavaPersistentAttribute at = (JavaPersistentAttribute)atts.next();
                String k = this.getKeyForBusinessObject(at);
                this.remove(k);
            }
            this.removeListenersFromEntity(jpt);
            Diagram d = this.featureProvider.getDiagramTypeProvider().getDiagram();
            if (d.getChildren().size() == 1 && (ref = this.projectToEntityListener.remove(jpt.getJpaProject())) != null && (ch = (CollectionChangeListener)ref.get()) != null) {
                jpt.getJpaProject().removeCollectionChangeListener("jpaFiles", ch);
            }
            ICompilationUnit cu = this.getCompilationUnit(jpt);
            JPAEditorUtil.discardWorkingCopyOnce(cu);
        } else if (o instanceof AbstractRelation) {
            AbstractRelation rel = (AbstractRelation)o;
            this.attribToRel.remove(this.produceOwnerKeyForRel(rel));
            if (rel instanceof BidirectionalRelation) {
                this.attribToRel.remove(this.produceInverseKeyForRel(rel));
            }
        } else if (o instanceof JavaPersistentAttribute) {
            this.removeListenersFromAttribute((JavaPersistentAttribute)o);
        }
        return o;
    }

    public ICompilationUnit getCompilationUnit(JavaPersistentType jpt) {
        return this.util.getCompilationUnit(jpt);
    }

    public boolean isRelationRelatedToAttribute(JavaPersistentAttribute jpa) {
        String key = this.produceKeyForRel((JavaPersistentType)jpa.getParent(), jpa.getName());
        return this.attribToRel.containsKey(key);
    }

    public IRelation getRelationRelatedToAttribute(JavaPersistentAttribute jpa) {
        String key = this.produceKeyForRel((JavaPersistentType)jpa.getParent(), jpa.getName());
        return this.attribToRel.get(key);
    }

    public Set<IRelation> getRelationsRelatedToEntity(JavaPersistentType jpt) {
        ListIterator it = jpt.attributes();
        HashSet<IRelation> res = new HashSet<IRelation>();
        while (it.hasNext()) {
            JavaPersistentAttribute at = (JavaPersistentAttribute)it.next();
            IRelation rel = this.getRelationRelatedToAttribute(at);
            if (rel == null) continue;
            res.add(rel);
        }
        return res;
    }

    public boolean existsRelation(JavaPersistentType jpt1, JavaPersistentType jpt2) {
        Set<IRelation> rels = this.getRelationsRelatedToEntity(jpt1);
        if (this.existsRelation(jpt1, jpt2, rels)) {
            return true;
        }
        rels = this.getRelationsRelatedToEntity(jpt2);
        return this.existsRelation(jpt1, jpt2, rels);
    }

    public boolean existsRelation(JavaPersistentType jpt1, JavaPersistentType jpt2, Set<IRelation> rels) {
        for (IRelation rel : rels) {
            if ((!jpt1.equals(rel.getOwner()) || !jpt2.equals(rel.getInverse())) && (!jpt2.equals(rel.getOwner()) || !jpt1.equals(rel.getInverse()))) continue;
            return true;
        }
        return false;
    }

    public Collection<Object> getVisualizedObjects() {
        return this.keyToBO.values();
    }

    public void renewAttributeMappingPropListener(JavaPersistentAttribute jpa) {
        this.renewAttributeJoiningStrategyPropertyListener(jpa);
        this.renewAttributeMappingOptPropListener(jpa);
    }

    public void renewAttributeJoiningStrategyPropertyListener(JavaPersistentAttribute jpa) {
        JavaAttributeMapping jam;
        AttributeJoiningStrategyPropertyChangeListener lsn = null;
        WeakReference<AttributeJoiningStrategyPropertyChangeListener> ref = this.attributeJoiningStrategyToPropListener.remove(jpa);
        if (ref != null) {
            lsn = (AttributeJoiningStrategyPropertyChangeListener)ref.get();
        }
        if ((jam = jpa.getMapping()) == null || !RelationshipMapping.class.isInstance(jam)) {
            return;
        }
        RelationshipReference rr = ((RelationshipMapping)jam).getRelationshipReference();
        if (rr == null) {
            return;
        }
        JoiningStrategy js = rr.getPredominantJoiningStrategy();
        if (js == null || !MappedByJoiningStrategy.class.isInstance(js)) {
            return;
        }
        try {
            if (lsn != null) {
                js.removePropertyChangeListener("mappedByAttribute", (PropertyChangeListener)lsn);
            }
        }
        catch (Exception exception) {}
        lsn = new AttributeJoiningStrategyPropertyChangeListener();
        js.addPropertyChangeListener("mappedByAttribute", (PropertyChangeListener)lsn);
        ref = new WeakReference<AttributeJoiningStrategyPropertyChangeListener>(lsn);
        this.attributeJoiningStrategyToPropListener.put(jpa, ref);
    }

    public void renewAttributeMappingOptPropListener(JavaPersistentAttribute jpa) {
        JavaAttributeMapping jam;
        AttributeMappingOptionalityChangeListener lsn = null;
        WeakReference<AttributeMappingOptionalityChangeListener> ref = this.attributeMappingOptionalityToPropListener.remove(jpa);
        if (ref != null) {
            lsn = (AttributeMappingOptionalityChangeListener)ref.get();
        }
        if ((jam = jpa.getMapping()) == null) {
            return;
        }
        if (!ManyToOneMapping.class.isInstance(jam) && !OneToOneMapping.class.isInstance(jam)) {
            return;
        }
        try {
            if (lsn != null) {
                jam.removePropertyChangeListener("specifiedOptional", (PropertyChangeListener)lsn);
            }
        }
        catch (Exception exception) {}
        lsn = new AttributeMappingOptionalityChangeListener();
        jam.addPropertyChangeListener("specifiedOptional", (PropertyChangeListener)lsn);
        ref = new WeakReference<AttributeMappingOptionalityChangeListener>(lsn);
        this.attributeMappingOptionalityToPropListener.put(jpa, ref);
    }

    private void addListenersToProject(JpaProject proj) {
        this.addEntitiesListenerToProject(proj);
    }

    private void addEntitiesListenerToProject(JpaProject proj) {
        WeakReference<CollectionChangeListener> lsnrRef = this.projectToEntityListener.get(proj);
        CollectionChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (CollectionChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            if (!proj.getUpdater().getClass().isInstance(SynchronousJpaProjectUpdater.class)) {
                proj.setUpdater((JpaProject.Updater)new SynchronousJpaProjectUpdater(proj));
            }
            lsnr = new JPAProjectListener();
            proj.addCollectionChangeListener("jpaFiles", lsnr);
            lsnrRef = new WeakReference<CollectionChangeListener>(lsnr);
            this.projectToEntityListener.put(proj, lsnrRef);
        }
    }

    private void addListenersToEntity(JavaPersistentType jpt) {
        this.addAtListenerToEntity(jpt);
        this.addPropertiesListenerToEntity(jpt);
        this.addStateListenerToEntity(jpt);
    }

    private void addAtListenerToEntity(JavaPersistentType jpt) {
        WeakReference<ListChangeListener> lsnrRef = this.entityToAtListener.get(jpt);
        ListChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (ListChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new EntityAttributesChangeListener();
            jpt.addListChangeListener("attributes", lsnr);
            lsnrRef = new WeakReference<ListChangeListener>(lsnr);
            this.entityToAtListener.put(jpt, lsnrRef);
        }
    }

    private void addPropertiesListenerToEntity(JavaPersistentType jpt) {
        WeakReference<PropertyChangeListener> lsnrRef = this.entityToPropListener.get(jpt);
        PropertyChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new EntityPropertyChangeListener();
            jpt.getMapping().addPropertyChangeListener("name", lsnr);
            lsnrRef = new WeakReference<PropertyChangeListener>(lsnr);
            this.entityToPropListener.put(jpt, lsnrRef);
        }
    }

    private void addPropertiesListenerToAttribute(JavaPersistentAttribute jpa) {
        this.addPropertiesListenerToAttributeItself(jpa);
        this.addPropertiesListenerToJoiningStrategy(jpa);
        this.addPropertiesListenerToRelationshipReference(jpa);
        this.addOptPropListenerToAttributeMapping(jpa);
    }

    private void addPropertiesListenerToAttributeItself(JavaPersistentAttribute jpa) {
        WeakReference<AttributePropertyChangeListener> lsnrRef = this.attributeToPropListener.get(jpa);
        AttributePropertyChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (AttributePropertyChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new AttributePropertyChangeListener();
            jpa.addPropertyChangeListener("specifiedMapping", (PropertyChangeListener)lsnr);
            lsnrRef = new WeakReference<AttributePropertyChangeListener>(lsnr);
            this.attributeToPropListener.put(jpa, lsnrRef);
        }
    }

    private void addOptPropListenerToAttributeMapping(JavaPersistentAttribute jpa) {
        WeakReference<AttributeMappingOptionalityChangeListener> lsnrRef = this.attributeMappingOptionalityToPropListener.get(jpa);
        AttributeMappingOptionalityChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (AttributeMappingOptionalityChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new AttributeMappingOptionalityChangeListener();
            JavaAttributeMapping jam = jpa.getMapping();
            if (jam == null) {
                return;
            }
            if (!JavaManyToOneMapping.class.isInstance(jam) && !JavaOneToOneMapping.class.isInstance(jam)) {
                return;
            }
            jam.addPropertyChangeListener("specifiedOptional", (PropertyChangeListener)lsnr);
            lsnrRef = new WeakReference<AttributeMappingOptionalityChangeListener>(lsnr);
            this.attributeMappingOptionalityToPropListener.put(jpa, lsnrRef);
        }
    }

    private void addPropertiesListenerToJoiningStrategy(JavaPersistentAttribute jpa) {
        WeakReference<AttributeJoiningStrategyPropertyChangeListener> lsnrRef = this.attributeJoiningStrategyToPropListener.get(jpa);
        AttributeJoiningStrategyPropertyChangeListener lsnr = null;
        lsnrRef = this.attributeJoiningStrategyToPropListener.get(jpa);
        lsnr = null;
        if (lsnrRef != null) {
            lsnr = (AttributeJoiningStrategyPropertyChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new AttributeJoiningStrategyPropertyChangeListener();
            JavaAttributeMapping jam = jpa.getMapping();
            if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                return;
            }
            RelationshipReference rr = ((RelationshipMapping)jam).getRelationshipReference();
            if (rr == null) {
                return;
            }
            JoiningStrategy js = rr.getPredominantJoiningStrategy();
            if (js == null || !MappedByJoiningStrategy.class.isInstance(js)) {
                return;
            }
            js.addPropertyChangeListener("mappedByAttribute", (PropertyChangeListener)lsnr);
            lsnrRef = new WeakReference<AttributeJoiningStrategyPropertyChangeListener>(lsnr);
            this.attributeJoiningStrategyToPropListener.put(jpa, lsnrRef);
        }
    }

    private void addPropertiesListenerToRelationshipReference(JavaPersistentAttribute jpa) {
        WeakReference<AttributeRelationshipReferencePropertyChangeListener> lsnrRef = this.attributeRelationshipReferenceToPropListener.get(jpa);
        AttributeRelationshipReferencePropertyChangeListener lsnr = null;
        lsnrRef = this.attributeRelationshipReferenceToPropListener.get(jpa);
        lsnr = null;
        if (lsnrRef != null) {
            lsnr = (AttributeRelationshipReferencePropertyChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new AttributeRelationshipReferencePropertyChangeListener();
            JavaAttributeMapping jam = jpa.getMapping();
            if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                return;
            }
            RelationshipReference rr = ((RelationshipMapping)jam).getRelationshipReference();
            if (rr == null) {
                return;
            }
            rr.addPropertyChangeListener("predominantStrategy", (PropertyChangeListener)lsnr);
            rr.addPropertyChangeListener("specifiedOptional", (PropertyChangeListener)new AttributeMappingOptionalityChangeListener());
            lsnrRef = new WeakReference<AttributeRelationshipReferencePropertyChangeListener>(lsnr);
            this.attributeRelationshipReferenceToPropListener.put(jpa, lsnrRef);
        }
    }

    private void addStateListenerToEntity(JavaPersistentType jpt) {
        WeakReference<StateChangeListener> lsnrRef = this.entityToStateListener.get(jpt);
        StateChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (StateChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new EntityStateChangeListener();
            jpt.addStateChangeListener(lsnr);
            lsnrRef = new WeakReference<StateChangeListener>(lsnr);
            this.entityToStateListener.put(jpt, lsnrRef);
        }
    }

    private void removeListenersFromEntity(JavaPersistentType jpt) {
        this.removeAtListenerFromEntity(jpt);
        this.removePropListenerFromEntity(jpt);
        this.removeStateListenerFromEntity(jpt);
    }

    private void removeListenersFromAttribute(JavaPersistentAttribute jpa) {
        this.removePropListenerFromAttribute(jpa);
    }

    private void removeAtListenerFromEntity(JavaPersistentType jpt) {
        WeakReference<ListChangeListener> lsnrRef = this.entityToAtListener.get(jpt);
        ListChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (ListChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.entityToAtListener.remove(jpt);
            jpt.removeListChangeListener("attributes", lsnr);
        }
    }

    private void removePropListenerFromEntity(JavaPersistentType jpt) {
        WeakReference<PropertyChangeListener> lsnrRef = this.entityToPropListener.get(jpt);
        PropertyChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.entityToPropListener.remove(jpt);
            try {
                jpt.getMapping().removePropertyChangeListener("name", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removePropListenerFromAttribute(JavaPersistentAttribute jpa) {
        this.removePropListenerFromAttributeItself(jpa);
        this.removePropListenerFromJoiningStrategy(jpa);
        this.removePropListenerFromRelationshipReference(jpa);
        this.removeOptPropListenerFromAttributeMapping(jpa);
    }

    private void removePropListenerFromAttributeItself(JavaPersistentAttribute jpa) {
        WeakReference<AttributePropertyChangeListener> lsnrRef = this.attributeToPropListener.get(jpa);
        PropertyChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.attributeToPropListener.remove(jpa);
            try {
                jpa.removePropertyChangeListener("specifiedMapping", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removePropListenerFromJoiningStrategy(JavaPersistentAttribute jpa) {
        WeakReference<AttributeJoiningStrategyPropertyChangeListener> lsnrRef = this.attributeJoiningStrategyToPropListener.get(jpa);
        PropertyChangeListener lsnr = null;
        lsnrRef = this.attributeJoiningStrategyToPropListener.get(jpa);
        lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.attributeJoiningStrategyToPropListener.remove(jpa);
            try {
                JavaAttributeMapping jam = jpa.getMapping();
                if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                    return;
                }
                RelationshipReference rr = ((RelationshipMapping)jam).getRelationshipReference();
                if (rr == null) {
                    return;
                }
                JoiningStrategy js = rr.getPredominantJoiningStrategy();
                if (js == null || !MappedByJoiningStrategy.class.isInstance(js)) {
                    return;
                }
                js.removePropertyChangeListener("mappedByAttribute", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removeOptPropListenerFromAttributeMapping(JavaPersistentAttribute jpa) {
        WeakReference<AttributeMappingOptionalityChangeListener> lsnrRef = this.attributeMappingOptionalityToPropListener.get(jpa);
        PropertyChangeListener lsnr = null;
        lsnrRef = this.attributeMappingOptionalityToPropListener.get(jpa);
        lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.attributeMappingOptionalityToPropListener.remove(jpa);
            try {
                JavaAttributeMapping jam = jpa.getMapping();
                if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                    return;
                }
                jam.removePropertyChangeListener("specifiedOptional", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removePropListenerFromRelationshipReference(JavaPersistentAttribute jpa) {
        WeakReference<AttributeRelationshipReferencePropertyChangeListener> lsnrRef = this.attributeRelationshipReferenceToPropListener.get(jpa);
        PropertyChangeListener lsnr = null;
        lsnrRef = this.attributeRelationshipReferenceToPropListener.get(jpa);
        lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.attributeRelationshipReferenceToPropListener.remove(jpa);
            try {
                JavaAttributeMapping jam = jpa.getMapping();
                if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                    return;
                }
                RelationshipReference rr = ((RelationshipMapping)jam).getRelationshipReference();
                if (rr == null) {
                    return;
                }
                rr.removePropertyChangeListener("predominantStrategy", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removeStateListenerFromEntity(JavaPersistentType jpt) {
        WeakReference<StateChangeListener> lsnrRef = this.entityToStateListener.get(jpt);
        StateChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (StateChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.entityToStateListener.remove(jpt);
            jpt.removeStateChangeListener(lsnr);
        }
    }

    private void removeEntityStateChangeListeners() {
        Iterator<Object> it = this.entityToStateListener.keySet().iterator();
        HashSet<JavaPersistentType> s = new HashSet<JavaPersistentType>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (JavaPersistentType jpt : s) {
            WeakReference<StateChangeListener> ref = this.entityToStateListener.remove(jpt);
            StateChangeListener lsn = (StateChangeListener)ref.get();
            if (lsn == null) continue;
            jpt.removeStateChangeListener(lsn);
        }
        this.entityToStateListener.clear();
        this.entityToStateListener = null;
    }

    private void removeEntityPropChangeListeners() {
        Iterator<Object> it = this.entityToPropListener.keySet().iterator();
        HashSet<JavaPersistentType> s = new HashSet<JavaPersistentType>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (JavaPersistentType jpt : s) {
            WeakReference<PropertyChangeListener> ref = this.entityToPropListener.remove(jpt);
            PropertyChangeListener lsn = (PropertyChangeListener)ref.get();
            if (lsn == null) continue;
            jpt.getMapping().removePropertyChangeListener("name", lsn);
        }
        this.entityToPropListener.clear();
        this.entityToPropListener = null;
    }

    private void removeAttributePropChangeListeners() {
        Iterator<Object> it = this.attributeToPropListener.keySet().iterator();
        HashSet<JavaPersistentAttribute> s = new HashSet<JavaPersistentAttribute>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (JavaPersistentAttribute jpa : s) {
            WeakReference<AttributePropertyChangeListener> ref = this.attributeToPropListener.remove(jpa);
            PropertyChangeListener lsn = (PropertyChangeListener)ref.get();
            if (lsn == null) continue;
            try {
                jpa.removePropertyChangeListener("specifiedMapping", lsn);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.attributeToPropListener.clear();
        this.attributeToPropListener = null;
    }

    private void removeAttributeJoiningStrategyPropChangeListeners() {
        Iterator<Object> it = this.attributeJoiningStrategyToPropListener.keySet().iterator();
        HashSet<JavaPersistentAttribute> s = new HashSet<JavaPersistentAttribute>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (JavaPersistentAttribute jpa : s) {
            WeakReference<AttributeJoiningStrategyPropertyChangeListener> ref = this.attributeJoiningStrategyToPropListener.remove(jpa);
            PropertyChangeListener lsn = (PropertyChangeListener)ref.get();
            if (lsn == null) continue;
            try {
                jpa.getMapping().removePropertyChangeListener("mappedByAttribute", lsn);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.attributeJoiningStrategyToPropListener.clear();
        this.attributeJoiningStrategyToPropListener = null;
    }

    private void removeOptPropListeners() {
        Iterator<Object> it = this.attributeMappingOptionalityToPropListener.keySet().iterator();
        HashSet<JavaPersistentAttribute> s = new HashSet<JavaPersistentAttribute>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (JavaPersistentAttribute jpa : s) {
            JavaAttributeMapping jam;
            PropertyChangeListener lsn;
            WeakReference<AttributeMappingOptionalityChangeListener> ref = this.attributeMappingOptionalityToPropListener.remove(jpa);
            if (ref == null || (lsn = (PropertyChangeListener)ref.get()) == null || (jam = jpa.getMapping()) == null || !RelationshipMapping.class.isInstance(jam)) continue;
            try {
                jam.removePropertyChangeListener("specifiedOptional", lsn);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.attributeRelationshipReferenceToPropListener.clear();
        this.attributeRelationshipReferenceToPropListener = null;
    }

    private void removeEntityAttributeChangeListeners() {
        Iterator<Object> it = this.entityToAtListener.keySet().iterator();
        HashSet<JavaPersistentType> s = new HashSet<JavaPersistentType>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (JavaPersistentType jpt : s) {
            WeakReference<ListChangeListener> ref = this.entityToAtListener.remove(jpt);
            ListChangeListener lsn = (ListChangeListener)ref.get();
            if (lsn == null) continue;
            jpt.removeListChangeListener("attributes", lsn);
        }
        this.entityToAtListener.clear();
        this.entityToAtListener = null;
    }

    private void removeProjectListeners() {
        Iterator<Object> it = this.projectToEntityListener.keySet().iterator();
        HashSet<JpaProject> s = new HashSet<JpaProject>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (JpaProject project : s) {
            WeakReference<CollectionChangeListener> ref = this.projectToEntityListener.remove(project);
            CollectionChangeListener lsn = (CollectionChangeListener)ref.get();
            if (lsn == null) continue;
            project.removeCollectionChangeListener("jpaFiles", lsn);
        }
        this.projectToEntityListener.clear();
        this.projectToEntityListener = null;
    }

    private void removeAllListeners() {
        this.removeOptPropListeners();
        this.removeAttributeJoiningStrategyPropChangeListeners();
        this.removeAttributePropChangeListeners();
        this.removeEntityStateChangeListeners();
        this.removeEntityPropChangeListeners();
        this.removeEntityAttributeChangeListeners();
        this.removeProjectListeners();
        this.eclipseFacade.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        for (Object bo : this.keyToBO.values()) {
            if (!JavaPersistentType.class.isInstance(bo)) continue;
            ICompilationUnit cu = this.util.getCompilationUnit((JavaPersistentType)bo);
            this.util.discardWorkingCopyOnce(cu);
        }
        this.util = null;
        this.keyToBO.clear();
        this.attribToRel.clear();
        this.keyToBO = null;
        this.attribToRel = null;
        this.removeAllListeners();
        this.featureProvider = null;
        Class<JPASolver> clazz = JPASolver.class;
        synchronized (JPASolver.class) {
            solversSet.remove(this);
            if (solversSet.isEmpty()) {
                JavaCore.removeElementChangedListener((IElementChangedListener)wclsnr);
                wclsnr = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean containsKey(String key) {
        return this.keyToBO.containsKey(key);
    }

    public void restoreEntity(JavaPersistentType jpt) {
        if (jpt == null) {
            return;
        }
        ICompilationUnit cu = this.getCompilationUnit(jpt);
        try {
            if (JPAEditorUtil.isEntityOpenElsewhere(jpt, true)) {
                String shortEntName = JPAEditorUtil.cutFromLastDot(JpaArtifactFactory.instance().getEntityName(jpt));
                String message = NLS.bind((String)JPAEditorMessages.JPASolver_closeWarningMsg, (Object)shortEntName);
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), JPAEditorMessages.JPASolver_closeEditors, null, message, 4, new String[]{JPAEditorMessages.BTN_OK}, 0){

                    protected int getShellStyle() {
                        return 0x10860 | 2.getDefaultOrientation();
                    }
                };
                dialog.open();
                return;
            }
            JPAEditorUtil.discardWorkingCopyOnce(cu);
            cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            System.err.println("Cannot recreate a working copy of " + jpt.getName());
            e.printStackTrace();
        }
    }

    public void addAttribForUpdate(PersistenceUnit pu, String entAtMappedBy) {
        this.entityNameListener.addAttribForUpdate(pu, entAtMappedBy);
    }

    private void updateJPTName(JavaPersistentType jpt) {
        String entName = JpaArtifactFactory.instance().getEntityName(jpt);
        entName = JPAEditorUtil.cutFromLastDot(entName);
        ContainerShape entShape = (ContainerShape)this.featureProvider.getPictogramElementForBusinessObject(jpt);
        JPAEditorUtil.setJPTNameInShape(entShape, entName);
    }

    private void closeDiagramEditorIfProjectIsDeleted(IResourceChangeEvent event) {
        IResourceDelta[] deltas;
        IResourceDelta changedDelta = event.getDelta();
        IResourceDelta[] iResourceDeltaArray = deltas = changedDelta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagramTypeProvider provider;
            IResourceDelta delta = iResourceDeltaArray[n2];
            final IResource resource = delta.getResource();
            if (!resource.exists() && resource instanceof IProject && (provider = this.featureProvider.getDiagramTypeProvider()) instanceof JPAEditorDiagramTypeProvider) {
                final JPADiagramEditor diagramBySelectedProject = ((JPAEditorDiagramTypeProvider)provider).getDiagramEditor();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (diagramBySelectedProject.getPartName().equals(resource.getName())) {
                            page.closeEditor((IEditorPart)diagramBySelectedProject, false);
                        }
                    }
                });
            }
            ++n2;
        }
    }

    private void unregisterDeltedEntity(IResourceChangeEvent event) {
        IResourceDelta[] deltas;
        IResourceDelta changedDelta = event.getDelta();
        IResourceDelta[] iResourceDeltaArray = deltas = changedDelta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            IResource resource = delta.getResource();
            if (resource.exists() && resource instanceof IProject) {
                IProject project = (IProject)resource;
                IResourceDelta[] iResourceDeltaArray2 = delta.getAffectedChildren();
                int n3 = iResourceDeltaArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResourceDelta deltaResource = iResourceDeltaArray2[n4];
                    List<IResourceDelta> resources = new ArrayList<IResourceDelta>();
                    resources = this.findDeletedResource(deltaResource, resources);
                    for (IResourceDelta resourceDelta : resources) {
                        IFile file;
                        if (!(resourceDelta.getResource() instanceof File) || (file = this.eclipseFacade.getWorkspace().getRoot().getFile(((File)resourceDelta.getResource()).getFullPath())).exists() || !file.getFileExtension().equals("java")) continue;
                        try {
                            IPackageFragmentRoot[] fragmentRoots;
                            JpaProject jpaProject = JpaArtifactFactory.instance().getJpaProject((IProject)resource);
                            if (jpaProject == null) continue;
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = javaProject.getAllPackageFragmentRoots();
                            int n5 = fragmentRoots.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n6];
                                if (fragmentRoot instanceof PackageFragmentRoot && fragmentRoot.getKind() == 1) {
                                    PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)fragmentRoot;
                                    String sourcefolder = packageFragmentRoot.getResource().getName();
                                    String[] fq = file.getFullPath().toString().split(sourcefolder);
                                    String fqName = fq[1].replace("/", ".");
                                    fqName = fqName.replaceFirst(".", "").replace(".java", "");
                                }
                                ++n6;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private List<IResourceDelta> findDeletedResource(IResourceDelta delta, List<IResourceDelta> resources) {
        IResourceDelta[] deltas;
        IResourceDelta[] iResourceDeltaArray = deltas = delta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta del = iResourceDeltaArray[n2];
            this.findDeletedResource(del, resources);
            if (del.getAffectedChildren().length == 0) {
                resources.add(del);
            }
            ++n2;
        }
        return resources;
    }

    public class AddEntityAttributes
    implements Runnable {
        ListAddEvent event = null;

        public AddEntityAttributes(ListAddEvent event) {
            this.event = event;
        }

        public synchronized void run() {
            try {
                JavaPersistentType jpt = (JavaPersistentType)this.event.getSource();
                ContainerShape entShape = (ContainerShape)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(jpt);
                ArrayIterator it = (ArrayIterator)this.event.getItems().iterator();
                while (it.hasNext()) {
                    JavaPersistentAttribute at = (JavaPersistentAttribute)it.next();
                    if (JPASolver.this.addIgnore.remove(String.valueOf(((PersistentType)at.getParent()).getName()) + "." + at.getName())) continue;
                    AddContext ctx = new AddContext();
                    ctx.setNewObject((Object)at);
                    ctx.setTargetContainer(entShape);
                    AddAttributeFeature ft = new AddAttributeFeature(JPASolver.this.featureProvider);
                    ft.add((IAddContext)ctx);
                }
                JPASolver.this.featureProvider.addJPTForUpdate(jpt.getName());
            }
            catch (Exception exception) {}
        }
    }

    public class AttributeJoiningStrategyPropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            Model m = event.getSource();
            if (!MappedByJoiningStrategy.class.isInstance(m)) {
                return;
            }
            MappedByJoiningStrategy js = (MappedByJoiningStrategy)m;
            JpaNode nd = js.getParent();
            if (nd == null) {
                return;
            }
            if ((nd = nd.getParent()) == null) {
                return;
            }
            if ((nd = nd.getParent()) == null || !JavaPersistentAttribute.class.isInstance(nd)) {
                return;
            }
            JavaPersistentAttribute at = (JavaPersistentAttribute)nd;
            if (!at.getParent().getParent().getResource().exists()) {
                return;
            }
            PictogramElement pe = JPASolver.this.featureProvider.getPictogramElementForBusinessObject(at.getParent());
            final UpdateAttributeFeature ft = new UpdateAttributeFeature(JPASolver.this.featureProvider);
            final CustomContext ctx = new CustomContext();
            ctx.setInnerPictogramElement(pe);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        ft.execute((ICustomContext)ctx);
                    }
                    catch (Exception exception) {}
                }
            };
            Display.getDefault().asyncExec(runnable);
        }
    }

    public class AttributeMappingOptionalityChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            Boolean optional = (Boolean)event.getNewValue();
            boolean isOptional = optional == null ? true : optional;
            Nullable nm = (Nullable)event.getSource();
            JavaPersistentAttribute jpa = (JavaPersistentAttribute)nm.getParent();
            IRelation rel = JPASolver.this.featureProvider.getRelationRelatedToAttribute(jpa);
            boolean atBeginning = !rel.getOwner().equals(jpa.getParent()) || !rel.getOwnerAttributeName().equals(jpa.getName());
            final Connection c = (Connection)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(rel);
            EList conDecs = c.getConnectionDecorators();
            Iterator it = conDecs.iterator();
            final String newLabelText = isOptional ? JPAEditorConstants.CARDINALITY_ZERO_ONE : JPAEditorConstants.CARDINALITY_ONE;
            while (it.hasNext()) {
                final ConnectionDecorator cd = (ConnectionDecorator)it.next();
                if (!JPAEditorUtil.isCardinalityDecorator(cd)) continue;
                double d = cd.getLocation();
                if (atBeginning && d > 0.5 || !atBeginning && d <= 0.5) continue;
                TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)cd);
                ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                    protected void doExecute() {
                        Text txt = (Text)cd.getGraphicsAlgorithm();
                        txt.setValue(newLabelText);
                        Point pt = JPAEditorUtil.recalcTextDecoratorPosition((FreeFormConnection)c, cd);
                        Graphiti.getGaService().setLocation((GraphicsAlgorithm)txt, pt.x, pt.y, false);
                    }
                });
                break;
            }
        }
    }

    public class AttributePropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            Model source = event.getSource();
            if (!JavaPersistentAttribute.class.isInstance(source)) {
                return;
            }
            PictogramElement pe = JPASolver.this.featureProvider.getPictogramElementForBusinessObject(((JavaPersistentAttribute)source).getParent());
            final UpdateAttributeFeature ft = new UpdateAttributeFeature(JPASolver.this.featureProvider);
            final CustomContext ctx = new CustomContext();
            ctx.setInnerPictogramElement(pe);
            Runnable runnable = new Runnable(){

                public void run() {
                    ft.execute((ICustomContext)ctx);
                }
            };
            Display.getDefault().asyncExec(runnable);
            String propName = event.getPropertyName();
            if (propName.equals("specifiedMapping")) {
                JPASolver.this.renewAttributeMappingPropListener((JavaPersistentAttribute)source);
            }
        }
    }

    public class AttributeRelationshipReferencePropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            RelationshipReference rr = (RelationshipReference)event.getSource();
            JpaNode p = rr.getParent();
            if (p == null) {
                return;
            }
            if ((p = p.getParent()) == null) {
                return;
            }
            if (!JavaPersistentAttribute.class.isInstance(p)) {
                return;
            }
            JavaPersistentAttribute jpa = (JavaPersistentAttribute)p;
            JPASolver.this.renewAttributeJoiningStrategyPropertyListener(jpa);
            if (!jpa.getParent().getParent().getResource().exists()) {
                return;
            }
            PictogramElement pe = JPASolver.this.featureProvider.getPictogramElementForBusinessObject(jpa.getParent());
            final UpdateAttributeFeature ft = new UpdateAttributeFeature(JPASolver.this.featureProvider);
            final CustomContext ctx = new CustomContext();
            ctx.setInnerPictogramElement(pe);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        ft.execute((ICustomContext)ctx);
                    }
                    catch (Exception exception) {}
                }
            };
            Display.getDefault().asyncExec(runnable);
        }
    }

    public class EntityAttributesChangeListener
    implements ListChangeListener {
        public void itemsAdded(ListAddEvent event) {
            AddEntityAttributes task = new AddEntityAttributes(event);
            Display.getDefault().asyncExec((Runnable)task);
        }

        public void itemsRemoved(ListRemoveEvent event) {
            RemoveEntityAttributes task = new RemoveEntityAttributes(event);
            Display.getDefault().asyncExec((Runnable)task);
        }

        public void listChanged(ListChangeEvent event) {
        }

        public void itemsMoved(ListMoveEvent arg0) {
        }

        public void itemsReplaced(ListReplaceEvent arg0) {
        }

        public void listCleared(ListClearEvent arg0) {
        }
    }

    public class EntityPropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            if (propName.equals(JPAEditorConstants.PROP_SPECIFIED_NAME)) {
                final JavaEntity je = (JavaEntity)event.getSource();
                Runnable job = new Runnable(){

                    public void run() {
                        TransactionalEditingDomain ted = JPASolver.this.featureProvider.getTransactionalEditingDomain();
                        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                            protected void doExecute() {
                                JavaPersistentType jpt = je.getPersistentType();
                                JPASolver.this.updateJPTName(jpt);
                                String tableName = JPAEditorUtil.formTableName(jpt);
                                JpaArtifactFactory.instance().setTableName(jpt, tableName);
                            }
                        });
                    }
                };
                Display.getDefault().syncExec(job);
            }
        }
    }

    public class EntityStateChangeListener
    implements StateChangeListener {
        public void stateChanged(StateChangeEvent event) {
        }
    }

    public class JPAProjectListener
    implements CollectionChangeListener {
        public synchronized void itemsRemoved(CollectionRemoveEvent event) {
            if (ignoreEvents) {
                return;
            }
            for (Object o : event.getItems()) {
                if (!(o instanceof JpaFile)) continue;
                JpaFile jpaFile = (JpaFile)o;
                JpaResourceModel jrm = ((JpaFile)o).getResourceModel();
                if (!JavaResourceCompilationUnit.class.isInstance(jrm)) continue;
                JavaResourceCompilationUnit jrcu = (JavaResourceCompilationUnit)jrm;
                JavaResourcePersistentType jrpt = (JavaResourcePersistentType)jrcu.persistentTypes().next();
                String name = jrpt.getQualifiedName();
                JpaProject jpaProject = jpaFile.getJpaProject();
                PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
                if (pu == null) continue;
                JavaPersistentType jpt = (JavaPersistentType)pu.getPersistentType(name);
                final ContainerShape cs = (ContainerShape)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(jpt);
                if (cs == null) {
                    return;
                }
                final RemoveContext ctx = new RemoveContext((PictogramElement)cs);
                final IRemoveFeature ft = JPASolver.this.featureProvider.getRemoveFeature((IRemoveContext)ctx);
                Runnable r = new Runnable(){

                    public void run() {
                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)cs);
                        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                            protected void doExecute() {
                                ft.remove((IRemoveContext)ctx);
                            }
                        });
                    }
                };
                Display.getDefault().syncExec(r);
            }
        }

        public void collectionCleared(CollectionClearEvent arg0) {
        }

        public void collectionChanged(CollectionChangeEvent event) {
        }

        public void itemsAdded(CollectionAddEvent event) {
        }
    }

    public class RemoveEntityAttributes
    implements Runnable {
        ListRemoveEvent event = null;

        public RemoveEntityAttributes(ListRemoveEvent event) {
            this.event = event;
        }

        public synchronized void run() {
            try {
                Object ft;
                ArrayIterator it = (ArrayIterator)this.event.getItems().iterator();
                HashSet<Shape> shapesToRemove = new HashSet<Shape>();
                while (it.hasNext()) {
                    Shape atShape;
                    JavaPersistentAttribute at = (JavaPersistentAttribute)it.next();
                    if (JPASolver.this.removeIgnore.remove(String.valueOf(((PersistentType)at.getParent()).getName()) + "." + at.getName()) || (atShape = (Shape)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(at)) == null) continue;
                    JavaPersistentType jpt = (JavaPersistentType)this.event.getSource();
                    JavaPersistentAttribute newAt = jpt.getAttributeNamed(at.getName());
                    if (newAt != null) {
                        RemoveAttributeFeature ft2 = new RemoveAttributeFeature(JPASolver.this.featureProvider, true, true);
                        RemoveContext c = new RemoveContext((PictogramElement)atShape);
                        try {
                            ft2.remove((IRemoveContext)c);
                        }
                        catch (Exception exception) {}
                        AddAttributeFeature ft1 = new AddAttributeFeature(JPASolver.this.featureProvider);
                        AddContext c1 = new AddContext();
                        c1.setNewObject((Object)newAt);
                        ft1.add((IAddContext)c1);
                        return;
                    }
                    shapesToRemove.add(atShape);
                    IRelation rel = JPASolver.this.featureProvider.getRelationRelatedToAttribute(at);
                    if (rel == null) continue;
                    Connection conn = (Connection)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(rel);
                    while (conn != null) {
                        RemoveContext ctx = new RemoveContext((PictogramElement)conn);
                        ft = new RemoveRelationFeature(JPASolver.this.featureProvider);
                        ((RemoveRelationFeature)((Object)ft)).remove((IRemoveContext)ctx);
                        conn = (Connection)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(rel);
                    }
                }
                for (Shape atShape : shapesToRemove) {
                    RemoveContext ctx = new RemoveContext((PictogramElement)atShape);
                    RemoveAttributeFeature ft3 = new RemoveAttributeFeature(JPASolver.this.featureProvider, true, true);
                    ft3.remove((IRemoveContext)ctx);
                }
                Collection<IRelation> rels = JpaArtifactFactory.instance().produceAllRelations((JavaPersistentType)this.event.getSource(), JPASolver.this.featureProvider);
                for (IRelation rel : rels) {
                    ContainerShape ownerShape = (ContainerShape)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(rel.getOwner());
                    ContainerShape inverseShape = (ContainerShape)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(rel.getInverse());
                    AddConnectionContext cntx = new AddConnectionContext(JPAEditorUtil.getAnchor(ownerShape), JPAEditorUtil.getAnchor(inverseShape));
                    cntx.setNewObject((Object)rel);
                    ft = new AddRelationFeature(JPASolver.this.featureProvider);
                    ((AddRelationFeature)((Object)ft)).add((IAddContext)cntx);
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WorkingCopyChangeListener
    implements IElementChangedListener {
        public synchronized void elementChanged(ElementChangedEvent event) {
            Object o = event.getSource();
            if (!IJavaElementDelta.class.isInstance(o)) {
                return;
            }
            IJavaElementDelta jed = (IJavaElementDelta)o;
            Set<ICompilationUnit> affectedCompilationUnits = this.getAffectedCompilationUnits(jed);
            for (ICompilationUnit cu : affectedCompilationUnits) {
                JavaPersistentType jpt = JPAEditorUtil.getJPType(cu);
                for (JPASolver solver : solversSet) {
                    final ContainerShape cs = (ContainerShape)solver.featureProvider.getPictogramElementForBusinessObject(jpt);
                    if (cs == null) {
                        return;
                    }
                    String entName = JPAEditorUtil.getText(jpt);
                    try {
                        final String newHeader = String.valueOf(cu.hasUnsavedChanges() ? "* " : "") + entName;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                GraphicsUpdater.updateHeader(cs, newHeader);
                            }
                        });
                    }
                    catch (JavaModelException e) {
                        System.err.println("Cannot check compilation unit for unsaved changes");
                        e.printStackTrace();
                    }
                }
            }
        }

        private Set<ICompilationUnit> getAffectedCompilationUnits(IJavaElementDelta delta) {
            IJavaElementDelta[] children;
            HashSet<ICompilationUnit> res = new HashSet<ICompilationUnit>();
            IJavaElement el = delta.getElement();
            if (ICompilationUnit.class.isInstance(el)) {
                res.add((ICompilationUnit)el);
            }
            IJavaElementDelta[] iJavaElementDeltaArray = children = delta.getChangedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                Set<ICompilationUnit> cus = this.getAffectedCompilationUnits(child);
                res.addAll(cus);
                ++n2;
            }
            return res;
        }
    }
}

