/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.relations;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.IRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.ManyToOneRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.UnidirectionalRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;

public class ManyToOneUniDirRelation
extends ManyToOneRelation
implements UnidirectionalRelation {
    public ManyToOneUniDirRelation(IFeatureProvider fp, JavaPersistentType owner, JavaPersistentType inverse, String ownerAttributeName, boolean createAttribs, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        if (createAttribs) {
            this.createRelation(fp, ownerCU, inverseCU);
        }
    }

    public JavaPersistentAttribute getAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    public void setAnnotatedAttribute(JavaPersistentAttribute annotatedAttribute) {
        this.ownerAnnotatedAttribute = annotatedAttribute;
    }

    private void createRelation(IFeatureProvider fp, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        String name = JPAEditorUtil.cutFromLastDot(this.inverse.getName());
        String actName = JPAEditorUtil.cutFromLastDot(JpaArtifactFactory.instance().getEntityName(this.inverse));
        String nameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(name);
        String actNameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(actName);
        if (JpaArtifactFactory.instance().isMethodAnnotated(this.owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(name);
            actNameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(actName);
        }
        nameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.owner, nameWithNonCapitalLetter);
        actNameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.owner, actNameWithNonCapitalLetter);
        this.ownerAnnotatedAttribute = JpaArtifactFactory.instance().addAttribute(fp, this.owner, this.inverse, nameWithNonCapitalLetter, actNameWithNonCapitalLetter, false, ownerCU, inverseCU);
        JpaArtifactFactory.instance().addManyToOneUnidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute);
    }

    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.UNI;
    }
}

