/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.relations;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.BidirectionalRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.IRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.ManyToOneRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;

public class ManyToOneBiDirRelation
extends ManyToOneRelation
implements BidirectionalRelation {
    public ManyToOneBiDirRelation(IFeatureProvider fp, JavaPersistentType owner, JavaPersistentType inverse, String ownerAttributeName, String inverseAttributeName, boolean createAttribs, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        this.inverseAttributeName = inverseAttributeName;
        if (createAttribs) {
            this.createRelation(fp, ownerCU, inverseCU);
        }
    }

    public JavaPersistentAttribute getOwnerAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    public void setOwnerAnnotatedAttribute(JavaPersistentAttribute ownerAnnotatedAttribute) {
        this.ownerAnnotatedAttribute = ownerAnnotatedAttribute;
    }

    public JavaPersistentAttribute getInverseAnnotatedAttribute() {
        return this.inverseAnnotatedAttribute;
    }

    public void setInverseAnnotatedAttribute(JavaPersistentAttribute inverseAnnotatedAttribute) {
        this.inverseAnnotatedAttribute = inverseAnnotatedAttribute;
    }

    private void createRelation(IFeatureProvider fp, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        String name = JPAEditorUtil.cutFromLastDot(this.inverse.getName());
        String actName = JPAEditorUtil.cutFromLastDot(JpaArtifactFactory.instance().getEntityName(this.inverse));
        String nameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(name);
        String actNameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(actName);
        if (JpaArtifactFactory.instance().isMethodAnnotated(this.owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(name);
            actNameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(actName);
        }
        nameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.owner, nameWithNonCapitalLetter);
        actNameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.owner, actNameWithNonCapitalLetter);
        this.ownerAnnotatedAttribute = JpaArtifactFactory.instance().addAttribute(fp, this.owner, this.inverse, nameWithNonCapitalLetter, actNameWithNonCapitalLetter, false, ownerCU, inverseCU);
        name = JPAEditorUtil.cutFromLastDot(this.owner.getName());
        actName = JPAEditorUtil.cutFromLastDot(JpaArtifactFactory.instance().getEntityName(this.owner));
        nameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(name);
        actNameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(actName);
        if (JpaArtifactFactory.instance().isMethodAnnotated(this.inverse)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(name);
            actNameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(actName);
        }
        nameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.inverse, nameWithNonCapitalLetter);
        actNameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.inverse, actNameWithNonCapitalLetter);
        this.inverseAnnotatedAttribute = JpaArtifactFactory.instance().addAttribute(fp, this.inverse, this.owner, nameWithNonCapitalLetter, actNameWithNonCapitalLetter, true, inverseCU, ownerCU);
        JpaArtifactFactory.instance().addManyToOneBidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute, this.inverse, this.inverseAnnotatedAttribute);
    }

    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.BI;
    }
}

