/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.modelintegration.util;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.JPAEditorDiagramTypeProvider;

public class ModelIntegrationUtil {
    public static final String DIAGRAM_FILE_EXTENSION = "xmi";
    public static final String JPA_DIAGRAM_TYPE = "JPA Diagram";
    public static final String DIAGRAMS_SUBFOLDER = "diagrams";
    public static final String DEFAULT_RES_FOLDER = "src";
    private static WeakHashMap<Diagram, WeakReference<JpaProject>> diagramsToProjects = new WeakHashMap();
    private static WeakHashMap<Diagram, WeakReference<JPAEditorDiagramTypeProvider>> diagramsToProviders = new WeakHashMap();
    private static HashMap<Diagram, Resource> diagramsToResources = new HashMap();

    public static IPath createDiagramPath(PersistenceUnit persistenceUnit) throws CoreException {
        IProject project = persistenceUnit.getJpaProject().getProject();
        IPath projectPath = project.getFullPath();
        String diagramName = persistenceUnit.getName();
        IPath path = ModelIntegrationUtil.getDiagramsFolderPath(project).append(diagramName).addFileExtension(DIAGRAM_FILE_EXTENSION);
        path = projectPath.append(path);
        return path;
    }

    public static Diagram createDiagram(PersistenceUnit persistenceUnit, int grid, boolean snap) throws CoreException {
        IPath path = ModelIntegrationUtil.createDiagramPath(persistenceUnit);
        Diagram d = ModelIntegrationUtil.createDiagram(persistenceUnit.getJpaProject().getProject(), path, persistenceUnit.getName(), grid, snap);
        return d;
    }

    public static TransactionalEditingDomain getTransactionalEditingDomain(Diagram diagram) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        return editingDomain;
    }

    public static ResourceSet getResourceSet(Diagram diagram) {
        WeakReference<JpaProject> ref = diagramsToProjects.get(diagram);
        TransactionalEditingDomain defaultTransEditDomain = (TransactionalEditingDomain)((JpaProject)ref.get()).getProject().getAdapter(TransactionalEditingDomain.class);
        ResourceSet resourceSet = defaultTransEditDomain.getResourceSet();
        return resourceSet;
    }

    public static Diagram createDiagram(IProject project, IPath diagramFileName, String diagramName, int grid, boolean snap) {
        TransactionalEditingDomain defaultTransEditDomain = DiagramEditorFactory.createResourceSetAndEditingDomain();
        ResourceSet resourceSet = defaultTransEditDomain.getResourceSet();
        IFile diagramFile = project.getFile(diagramFileName.removeFirstSegments(1));
        IPath diagramFilePath = diagramFile.getFullPath();
        String pathName = diagramFilePath.toString();
        URI resourceURI = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        final Resource resource = resourceSet.createResource(resourceURI);
        defaultTransEditDomain.getCommandStack().execute((Command)new RecordingCommand(defaultTransEditDomain){

            protected void doExecute() {
                try {
                    resource.load(null);
                }
                catch (IOException e) {
                    System.out.println("The diagram file does not exist. It will be created");
                    System.out.println(e.getLocalizedMessage());
                }
            }
        });
        if (!resource.isLoaded()) {
            return ModelIntegrationUtil.createNewDiagram(defaultTransEditDomain, resourceSet, resource, diagramName, grid, snap);
        }
        EList objs = resource.getContents();
        if (objs == null) {
            return ModelIntegrationUtil.createNewDiagram(defaultTransEditDomain, resourceSet, resource, diagramName, grid, snap);
        }
        for (EObject obj : objs) {
            if (obj == null && !Diagram.class.isInstance(obj)) continue;
            Diagram d = (Diagram)obj;
            diagramsToResources.put(d, resource);
            defaultTransEditDomain.getCommandStack().flush();
            return d;
        }
        return ModelIntegrationUtil.createNewDiagram(defaultTransEditDomain, resourceSet, resource, diagramName, grid, snap);
    }

    private static Diagram createNewDiagram(TransactionalEditingDomain editingDomain, ResourceSet resourceSet, final Resource resource, final String diagramName, final int grid, final boolean snap) {
        final Wrp wrp = new Wrp();
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                Diagram diagram = Graphiti.getPeService().createDiagram(ModelIntegrationUtil.JPA_DIAGRAM_TYPE, diagramName, grid, snap);
                wrp.setObject(diagram);
                resource.getContents().add((Object)diagram);
                try {
                    resource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    System.err.println("Cannot create new diagram");
                    e.printStackTrace();
                }
            }
        });
        editingDomain.getCommandStack().flush();
        ModelIntegrationUtil.mapDiagramToProject((Diagram)wrp.getObject(), resource);
        return (Diagram)wrp.getObject();
    }

    public static IPath getResourceFolderPath(IProject project) {
        return ModelIntegrationUtil.getEMFResourceFolderPath(project);
    }

    public static IPath getEMFResourceFolderPath(IProject project) {
        return project.getProjectRelativePath().append(DEFAULT_RES_FOLDER);
    }

    public static IPath getDiagramsFolderPath(IProject project) {
        IPath resFolderPath = ModelIntegrationUtil.getResourceFolderPath(project);
        if (resFolderPath == null) {
            return null;
        }
        IPath diagramsFolderPath = resFolderPath.append(DIAGRAMS_SUBFOLDER);
        return diagramsFolderPath;
    }

    public static void mapDiagramToProject(Diagram diagram, JpaProject project) {
        diagramsToProjects.put(diagram, new WeakReference<JpaProject>(project));
    }

    public static void mapDiagramToProject(Diagram diagram, Resource resource) {
        diagramsToResources.put(diagram, resource);
    }

    public static JpaProject removeDiagramProjectMapping(Diagram diagram) {
        WeakReference<JpaProject> ref = diagramsToProjects.remove(diagram);
        diagramsToProviders.remove(diagram);
        if (ref == null) {
            return null;
        }
        return (JpaProject)ref.get();
    }

    public static Resource removeDiagramResourceMapping(Diagram diagram) {
        return diagramsToResources.remove(diagram);
    }

    public static JpaProject getProjectByDiagram(Diagram diagram) {
        WeakReference<JpaProject> ref = diagramsToProjects.get(diagram);
        if (ref == null) {
            return null;
        }
        return (JpaProject)ref.get();
    }

    public static Resource getResourceByDiagram(Diagram diagram) {
        return diagramsToResources.get(diagram);
    }

    public static JPAEditorDiagramTypeProvider getProviderByDiagram(Diagram diagram) {
        WeakReference<JPAEditorDiagramTypeProvider> ref = diagramsToProviders.get(diagram);
        if (ref == null) {
            return null;
        }
        return (JPAEditorDiagramTypeProvider)((Object)ref.get());
    }

    public static void mapDiagramToProvider(Diagram diagram, JPAEditorDiagramTypeProvider provider) {
        diagramsToProviders.put(diagram, new WeakReference<JPAEditorDiagramTypeProvider>(provider));
    }

    private static class Wrp {
        private Object o;

        private Wrp() {
        }

        public Object getObject() {
            return this.o;
        }

        public void setObject(Object o) {
            this.o = o;
        }
    }
}

