/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.modelintegration.ui;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.jpt.ui.diagrameditor.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.ui.diagrameditor.internal.util.IJPADiagramEditorInput;

public class JPADiagramEditorInput
extends DiagramEditorInput
implements IJPADiagramEditorInput {
    private Diagram diagram;
    private String projectName;

    public JPADiagramEditorInput(Diagram diagram, String diagramUriString, TransactionalEditingDomain domain, String providerId, boolean disposeEditingDomain) {
        super(diagramUriString, domain, providerId, disposeEditingDomain);
        this.diagram = diagram;
        this.projectName = ModelIntegrationUtil.getProjectByDiagram(diagram).getName();
    }

    public JPADiagramEditorInput(Diagram diagram, URI diagramUri, TransactionalEditingDomain domain, String providerId, boolean disposeEditingDomain) {
        super(diagramUri, domain, providerId, disposeEditingDomain);
        this.diagram = diagram;
        this.projectName = ModelIntegrationUtil.getProjectByDiagram(diagram).getName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(EObject.class)) {
            return this.getDiagram();
        }
        if (adapter.equals(Diagram.class)) {
            return this.getDiagram();
        }
        if (adapter.equals(TransactionalEditingDomain.class)) {
            return ModelIntegrationUtil.getTransactionalEditingDomain(this.diagram);
        }
        return null;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public static JPADiagramEditorInput createEditorInput(Diagram diagram, TransactionalEditingDomain domain, String providerId, boolean disposeEditingDomain) {
        Resource resource = diagram.eResource();
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        String fragment = resource.getURIFragment((EObject)diagram);
        URI fragmentUri = resource.getURI().appendFragment(fragment);
        JPADiagramEditorInput diagramEditorInput = new JPADiagramEditorInput(diagram, fragmentUri, domain, providerId, disposeEditingDomain);
        return diagramEditorInput;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public static /* bridge */ /* synthetic */ DiagramEditorInput createEditorInput(Diagram diagram, TransactionalEditingDomain transactionalEditingDomain, String string, boolean bl) {
        return JPADiagramEditorInput.createEditorInput(diagram, transactionalEditingDomain, string, bl);
    }
}

