/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.IGraphicsUpdater;
import org.eclipse.jpt.ui.diagrameditor.internal.util.IPeServiceUtil;

public class LayoutJPAEntityFeature
extends AbstractLayoutFeature {
    private IPeServiceUtil peUtil = null;

    public LayoutJPAEntityFeature(IJPAEditorFeatureProvider fp) {
        super((IFeatureProvider)fp);
        this.peUtil = fp.getPeUtil();
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        return bo instanceof JavaPersistentType;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        if (containerGa.getHeight() < 30) {
            containerGa.setHeight(30);
        }
        this.configureEntityCollapseExpandProperty(containerShape, containerGa);
        if (containerGa.getWidth() < 50) {
            containerGa.setWidth(50);
            anythingChanged = true;
        }
        int containerWidth = containerGa.getWidth();
        for (Shape shape : containerShape.getChildren()) {
            anythingChanged = this.layoutContainerEntityChildren(anythingChanged, containerWidth, shape);
        }
        Property property = this.peUtil.getProperty((PropertyContainer)containerShape, "collapseFeatures");
        if (property == null) {
            IGraphicsUpdater gu = this.getFeatureProvider().getGraphicsUpdater();
            gu.updateEntityHeigth(containerShape);
        }
        return anythingChanged;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private void configureEntityCollapseExpandProperty(ContainerShape containerShape, GraphicsAlgorithm containerGa) {
        if (containerGa.getHeight() == 30) {
            this.peUtil.setPropertyValue((PropertyContainer)containerShape, "collapseFeatures", String.valueOf(30));
        } else if (containerGa.getHeight() > 30) {
            this.peUtil.removeProperty((PropertyContainer)containerShape, "collapseFeatures");
        }
    }

    private boolean layoutContainerEntityChildren(boolean anythingChanged, int containerWidth, Shape shape) {
        GraphicsAlgorithm graphicsAlgorithm = shape.getGraphicsAlgorithm();
        IDimension size = Graphiti.getGaService().calculateSize(graphicsAlgorithm);
        if (containerWidth != size.getWidth()) {
            if (graphicsAlgorithm instanceof Polyline) {
                anythingChanged = this.layoutPolyline(containerWidth, graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof Rectangle) {
                Rectangle rect = (Rectangle)graphicsAlgorithm;
                EList gra = rect.getGraphicsAlgorithmChildren();
                for (GraphicsAlgorithm gr : gra) {
                    if (gr instanceof Image) {
                        this.layoutHeaderIcon(shape, graphicsAlgorithm);
                        continue;
                    }
                    if (!(gr instanceof Text)) continue;
                    Text txt = (Text)gr;
                    if (!txt.getFont().isItalic()) {
                        this.layoutHeaderText(containerWidth, graphicsAlgorithm, gr);
                        continue;
                    }
                    this.layoutAttributesGroups(anythingChanged, gr, containerWidth);
                }
                anythingChanged = true;
            }
        }
        return anythingChanged;
    }

    private void layoutHeaderText(int containerWidth, GraphicsAlgorithm graphicsAlgorithm, GraphicsAlgorithm gr) {
        Graphiti.getGaService().setWidth(graphicsAlgorithm, containerWidth - 25);
        Graphiti.getGaService().setWidth(gr, containerWidth - 25);
    }

    private void layoutHeaderIcon(Shape shape, GraphicsAlgorithm graphicsAlgorithm) {
        GraphicsAlgorithm headerIconGraphicsAlg = shape.getGraphicsAlgorithm();
        Graphiti.getGaService().setWidth(graphicsAlgorithm, 24);
        Graphiti.getGaService().setWidth(headerIconGraphicsAlg, 24);
    }

    private boolean layoutPolyline(int containerWidth, GraphicsAlgorithm graphicsAlgorithm) {
        Polyline headerBottomLine = (Polyline)graphicsAlgorithm;
        Point secondPoint = (Point)headerBottomLine.getPoints().get(1);
        Point newSecondPoint = Graphiti.getGaService().createPoint(containerWidth, secondPoint.getY());
        headerBottomLine.getPoints().set(1, (Object)newSecondPoint);
        boolean anythingChanged = true;
        return anythingChanged;
    }

    private void layoutAttributesGroups(boolean anythingChanged, GraphicsAlgorithm graphicsAlgorithm, int containerWidth) {
        ContainerShape containerShape = (ContainerShape)Graphiti.getPeService().getActiveContainerPe(graphicsAlgorithm);
        this.layoutConcreteCompartmentShape(anythingChanged, containerShape, containerWidth);
    }

    private void layoutConcreteCompartmentShape(boolean anythingChanged, ContainerShape containerShape, int containerWidth) {
        this.layoutCompartmentShape(containerShape, containerWidth);
        for (Shape shape : containerShape.getChildren()) {
            GraphicsAlgorithm graphicsAlgorithm = shape.getGraphicsAlgorithm();
            if (!(graphicsAlgorithm instanceof Rectangle)) continue;
            Rectangle rect = (Rectangle)graphicsAlgorithm;
            EList gra = rect.getGraphicsAlgorithmChildren();
            if (gra.isEmpty()) {
                Graphiti.getGaService().setWidth(graphicsAlgorithm, containerWidth);
            }
            for (GraphicsAlgorithm gr : gra) {
                if (gr instanceof Image) {
                    this.layoutAttributeIcon(shape, graphicsAlgorithm);
                }
                if (!(gr instanceof Text)) continue;
                this.layoutAttributeText(containerWidth, graphicsAlgorithm, gr);
            }
            anythingChanged = true;
        }
    }

    private void layoutAttributeText(int containerWidth, GraphicsAlgorithm graphicsAlgorithm, GraphicsAlgorithm gr) {
        Graphiti.getGaService().setWidth(graphicsAlgorithm, containerWidth - 21);
        Graphiti.getGaService().setWidth(gr, containerWidth - 21);
    }

    private void layoutAttributeIcon(Shape shape, GraphicsAlgorithm graphicsAlgorithm) {
        GraphicsAlgorithm headerIconGraphicsAlg = shape.getGraphicsAlgorithm();
        Graphiti.getGaService().setWidth(graphicsAlgorithm, 20);
        Graphiti.getGaService().setWidth(headerIconGraphicsAlg, 20);
    }

    private void layoutCompartmentShape(ContainerShape containerShape, int containerWidth) {
        GraphicsAlgorithm graphic = containerShape.getGraphicsAlgorithm();
        EList graphics = graphic.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithm : graphics) {
            Graphiti.getGaService().setWidth(graphic, containerWidth);
            Graphiti.getGaService().setWidth(graphicsAlgorithm, containerWidth);
        }
    }
}

