/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.AddRelationFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.IRelation;
import org.eclipse.jpt.ui.diagrameditor.internal.util.GraphicsUpdater;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphicalRemoveAttributeFeature
extends AbstractCustomFeature {
    public GraphicalRemoveAttributeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        final PictogramElement pe = context.getInnerPictogramElement();
        if (pe == null) {
            return;
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pe);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                Shape sh = (Shape)pe;
                Object bo = GraphicalRemoveAttributeFeature.this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
                if (bo == null || !JavaPersistentType.class.isInstance(bo)) {
                    return;
                }
                ContainerShape entityShape = (ContainerShape)pe;
                ContainerShape primShape = GraphicsUpdater.getPrimaryShape(entityShape);
                ContainerShape relationShape = GraphicsUpdater.getRelationShape(entityShape);
                ContainerShape basicShape = GraphicsUpdater.getBasicShape(entityShape);
                GraphicalRemoveAttributeFeature.this.removeCompartmentChildren(primShape);
                GraphicalRemoveAttributeFeature.this.removeCompartmentChildren(relationShape);
                GraphicalRemoveAttributeFeature.this.removeCompartmentChildren(basicShape);
                GraphicalRemoveAttributeFeature.this.readdCompartmentsChildren((JavaPersistentType)bo, entityShape, primShape, relationShape, basicShape);
                GraphicalRemoveAttributeFeature.this.layoutPictogramElement((PictogramElement)entityShape);
                GraphicalRemoveAttributeFeature.this.reconnect((JavaPersistentType)bo);
            }
        });
    }

    public void reconnect(JavaPersistentType jpt) {
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        Collection<IRelation> rels = JpaArtifactFactory.instance().produceAllRelations(jpt, fp);
        JpaArtifactFactory.instance().refreshEntityModel(fp, jpt);
        for (IRelation rel : rels) {
            AddRelationFeature relF = new AddRelationFeature(fp);
            AnchorContainer acSource = (AnchorContainer)fp.getPictogramElementForBusinessObject(rel.getOwner());
            AnchorContainer acTarget = (AnchorContainer)fp.getPictogramElementForBusinessObject(rel.getInverse());
            AddConnectionContext ctx = new AddConnectionContext((Anchor)acSource.getAnchors().iterator().next(), (Anchor)acTarget.getAnchors().iterator().next());
            ctx.setNewObject((Object)rel);
            relF.add((IAddContext)ctx);
        }
    }

    private void readdCompartmentsChildren(JavaPersistentType javaPersistentType, ContainerShape entityShape, ContainerShape primaryShape, ContainerShape relationShape, ContainerShape basicShape) {
        UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(this.getFeatureProvider());
        updateFeature.addSeparatorsToShape(primaryShape);
        updateFeature.addSeparatorsToShape(relationShape);
        updateFeature.addSeparatorsToShape(basicShape);
        ListIterator attributeIter = javaPersistentType.attributes();
        while (attributeIter.hasNext()) {
            JavaPersistentAttribute attribute = (JavaPersistentAttribute)attributeIter.next();
            updateFeature.addAttributes(entityShape, attribute);
            this.getFeatureProvider().renewAttributeJoiningStrategyPropertyListener(attribute);
            this.getFeatureProvider().addJPTForUpdate(javaPersistentType.getName());
        }
    }

    private void removeCompartmentChildren(ContainerShape compartmentShape) {
        Shape shape;
        int y = 0;
        EList children = compartmentShape.getChildren();
        int i = 0;
        while (i < new ArrayList(compartmentShape.getChildren()).size()) {
            shape = (Shape)compartmentShape.getChildren().get(i);
            y = shape.getGraphicsAlgorithm().getY();
            Graphiti.getPeService().deletePictogramElement((PictogramElement)shape);
            ++i;
        }
        i = this.getFeatureProvider().getAttribsNum((Shape)compartmentShape);
        while (i > 0) {
            shape = (Shape)compartmentShape.getChildren().get(i);
            y = shape.getGraphicsAlgorithm().getY();
            Graphiti.getPeService().deletePictogramElement((PictogramElement)shape);
            this.getFeatureProvider().decreaseAttribsNum((Shape)compartmentShape);
            --i;
        }
        children = compartmentShape.getChildren();
        this.shiftUpLowerAttribs(y, (List<Shape>)children);
        compartmentShape.getGraphicsAlgorithm().setHeight(0);
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private void shiftUpLowerAttribs(int y, List<Shape> children) {
        int i = 0;
        while (i < children.size()) {
            Shape shp = children.get(i);
            if (shp != null) {
                int grY = children.get(i).getGraphicsAlgorithm().getY();
                if (grY > y) {
                    children.get(i).getGraphicsAlgorithm().setY(grY - 20);
                }
                children.get(i).setVisible(false);
                Graphiti.getPeService().deletePictogramElement((PictogramElement)children.get(i));
            }
            ++i;
        }
    }
}

