/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import java.text.MessageFormat;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.internal.features.context.impl.base.PictogramElementContext;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;

public class ClickRemoveAttributeButtonFeature
extends DefaultDeleteFeature {
    private String attrName = "";

    public ClickRemoveAttributeButtonFeature(IFeatureProvider provider) {
        super(provider);
    }

    protected String getQuestionToUser() {
        return MessageFormat.format(JPAEditorMessages.ClickRemoveAttributeButtonFeature_deleteAttributeQuestion, this.attrName);
    }

    public boolean canUndo(IContext context) {
        return false;
    }

    private String getAttrName(ContainerShape textShape) {
        String txt = ((Text)textShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getValue();
        String attrName = txt.substring(txt.indexOf(58) + 1);
        attrName = attrName.trim();
        return attrName;
    }

    private void deleteAttribute(ContainerShape pe, String attrName) {
        JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pe.getContainer().getContainer());
        JpaArtifactFactory.instance().deleteAttribute(jpt, attrName, this.getFeatureProvider());
    }

    public void delete(IDeleteContext context) {
        this.delete(context, true);
    }

    public void preDelete(IDeleteContext context) {
        super.preDelete(context);
    }

    public void delete(IDeleteContext context, boolean haveToAsk) {
        String attrName;
        PictogramElementContext ctx = (PictogramElementContext)context;
        ContainerShape textShape = (ContainerShape)ctx.getPictogramElement();
        if (textShape == null || textShape.getGraphicsAlgorithm() == null) {
            return;
        }
        this.attrName = attrName = this.getAttrName(textShape);
        if (haveToAsk && !this.getUserDecision()) {
            return;
        }
        this.preDelete(context);
        if (textShape.getGraphicsAlgorithm() == null) {
            return;
        }
        this.deleteAttribute(textShape, attrName);
    }

    protected void deleteBusinessObjects(Object[] businessObjects) {
        if (businessObjects != null) {
            Object[] objectArray = businessObjects;
            int n = businessObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object bo = objectArray[n2];
                this.deleteBusinessObject(bo);
                ++n2;
            }
        }
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public String getName() {
        return JPAEditorMessages.ClickRemoveAttributeButtonFeature_createAttributeButtonlabel;
    }

    public String getDescription() {
        return JPAEditorMessages.ClickRemoveAttributeButtonFeature_createAttributeButtonDescription;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }
}

