/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.ExpandCompartmentShapeFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.GraphicalAddAttributeFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.Wrp;

public class AddAttributeFeature
extends AbstractAddShapeFeature {
    private IAddFeature graphicalAdd;
    private ICustomFeature expandCompartmentFeature;

    public AddAttributeFeature(IFeatureProvider fp) {
        this(fp, (IAddFeature)new GraphicalAddAttributeFeature(fp), (ICustomFeature)new ExpandCompartmentShapeFeature(fp));
    }

    public AddAttributeFeature(IFeatureProvider fp, IAddFeature graphicalAdd, ICustomFeature expandFeature) {
        super(fp);
        this.graphicalAdd = graphicalAdd;
        this.expandCompartmentFeature = expandFeature;
    }

    public PictogramElement add(final IAddContext context) {
        Object o = context.getNewObject();
        if (!(o instanceof JavaPersistentAttribute)) {
            return null;
        }
        final JavaPersistentAttribute newAttr = (JavaPersistentAttribute)o;
        this.getFeatureProvider().putKeyToBusinessObject(this.getFeatureProvider().getKeyForBusinessObject(newAttr), newAttr);
        PictogramElement pe = this.getFeatureProvider().getPictogramElementForBusinessObject(newAttr);
        if (pe != null) {
            return pe;
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)context.getTargetContainer());
        final Wrp wrp = new Wrp();
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                ContainerShape textShape = AddAttributeFeature.this.graphicalAdd(context.getTargetContainer(), newAttr);
                AddAttributeFeature.this.expand(newAttr);
                AddAttributeFeature.this.enableDirectAfterAdding(textShape);
                wrp.setObj(textShape);
            }
        });
        return (PictogramElement)wrp.getObj();
    }

    private void expand(JavaPersistentAttribute jpa) {
        ContainerShape attributeShape = (ContainerShape)this.getFeatureProvider().getPictogramElementForBusinessObject(jpa);
        CustomContext customContext = new CustomContext(new PictogramElement[]{attributeShape.getContainer()});
        this.expandCompartmentFeature.execute((ICustomContext)customContext);
    }

    private ContainerShape graphicalAdd(ContainerShape entityShape, JavaPersistentAttribute newAttr) {
        AddContext context = new AddContext();
        context.setNewObject((Object)newAttr);
        context.setTargetContainer(entityShape);
        ContainerShape textShape = (ContainerShape)this.graphicalAdd.add((IAddContext)context);
        return textShape;
    }

    private void enableDirectAfterAdding(ContainerShape textShape) {
        GraphicsAlgorithm ga = textShape.getGraphicsAlgorithm();
        GraphicsAlgorithm graphicsAlgorithm = (GraphicsAlgorithm)ga.getGraphicsAlgorithmChildren().get(0);
        if (graphicsAlgorithm instanceof Text) {
            Text text = (Text)graphicsAlgorithm;
            IDirectEditingInfo directEditingInfo = this.getFeatureProvider().getDirectEditingInfo();
            directEditingInfo.setMainPictogramElement((PictogramElement)textShape);
            directEditingInfo.setPictogramElement((PictogramElement)textShape);
            directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        }
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public boolean canAdd(IAddContext context) {
        Object o = context.getNewObject();
        return o instanceof JavaPersistentAttribute;
    }
}

