/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import java.util.Iterator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.AddJPAEntityFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.modelintegration.util.ModelIntegrationUtil;

public class AddAllEntitiesFeature
extends AbstractCustomFeature
implements IAddFeature {
    int[] lowerEdges = new int[200];
    int numInARow;
    private static final int DIST_FROM_EDGE_H = 50;
    private static final int DIST_FROM_EDGE_V = 50;
    private static final int DIST_H = 100;
    private static final int DIST_V = 100;

    public AddAllEntitiesFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean isAvailable(IContext ctx) {
        return true;
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        Diagram d = this.getDiagram();
        JpaProject project = this.getTargetJPAProject();
        PersistenceUnit unit = (PersistenceUnit)project.getRootContextNode().getPersistenceXml().getPersistence().persistenceUnits().next();
        Point lowestRightestPointOfExistingDiagram = AddAllEntitiesFeature.getLowestRightestPoint(d);
        int i = 0;
        while (i < 200) {
            this.lowerEdges[i] = lowestRightestPointOfExistingDiagram.y + (i % 2 == 0 ? 1 : 2) * (lowestRightestPointOfExistingDiagram.y == 0 ? 50 : 100);
            ++i;
        }
        IDimension dim = this.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor().getCurrentSize();
        int dWidth = dim.getWidth();
        this.numInARow = (dWidth - 50 - 20 + 120) / 220;
        this.numInARow = this.numInARow > 0 ? this.numInARow : 1;
        this.lowerEdges[0] = lowestRightestPointOfExistingDiagram.y + (lowestRightestPointOfExistingDiagram.y == 0 ? 50 : 100);
        Iterator classRefs = unit.classRefs();
        while (classRefs.hasNext()) {
            PictogramElement pe;
            JavaPersistentType jpt;
            ClassRef classRef = (ClassRef)classRefs.next();
            if (classRef.getJavaPersistentType() == null || (jpt = classRef.getJavaPersistentType()).getMappingKey() != "entity" || (pe = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)jpt)) != null) continue;
            final AddContext ctx = new AddContext();
            ctx.setTargetContainer((ContainerShape)d);
            ctx.setNewObject((Object)jpt);
            IndexAndLowerEdge ie = this.getMinLowerEdge();
            int x = 50 + ie.index * 220;
            ctx.setLocation(x, ie.lowerEdge);
            final AddJPAEntityFeature ft = new AddJPAEntityFeature(this.getFeatureProvider());
            Diagram targetDiagram = (Diagram)ctx.getTargetContainer();
            TransactionalEditingDomain ted = ModelIntegrationUtil.getTransactionalEditingDomain(targetDiagram);
            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    ft.add((IAddContext)ctx);
                }
            });
            ContainerShape entityShape = (ContainerShape)this.getFeatureProvider().getPictogramElementForBusinessObject((Object)jpt);
            this.lowerEdges[ie.index] = entityShape.getGraphicsAlgorithm().getY() + entityShape.getGraphicsAlgorithm().getHeight() + 100;
        }
    }

    private IndexAndLowerEdge getMinLowerEdge() {
        IndexAndLowerEdge res = new IndexAndLowerEdge();
        res.lowerEdge = 10000000;
        int i = 0;
        while (i < this.numInARow) {
            if (this.lowerEdges[i] < res.lowerEdge) {
                res.lowerEdge = this.lowerEdges[i];
                res.index = i;
            }
            ++i;
        }
        return res;
    }

    private JpaProject getTargetJPAProject() {
        return ModelIntegrationUtil.getProjectByDiagram(this.getDiagram());
    }

    public static Point getLowestRightestPoint(Diagram d) {
        EList shapes = d.getChildren();
        Iterator it = shapes.iterator();
        int x = 0;
        int y = 0;
        while (it.hasNext()) {
            Shape sh = (Shape)it.next();
            int rightEdge = sh.getGraphicsAlgorithm().getX() + sh.getGraphicsAlgorithm().getWidth();
            x = Math.max(x, rightEdge);
            int lowerEdge = sh.getGraphicsAlgorithm().getY() + sh.getGraphicsAlgorithm().getHeight();
            y = Math.max(y, lowerEdge);
        }
        x = Math.max(x, 660);
        return new Point(x, y);
    }

    public PictogramElement add(IAddContext context) {
        this.execute((ICustomContext)new CustomContext());
        return null;
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    private class IndexAndLowerEdge {
        int index;
        int lowerEdge;

        private IndexAndLowerEdge() {
        }
    }
}

