/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorConstants;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;

public class JPACheckSum {
    private static JPACheckSum instance = null;
    private static MessageDigest md5 = null;

    public static synchronized JPACheckSum INSTANCE() {
        if (instance == null) {
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                System.err.println("Couldn't create instance of MD5");
                e.printStackTrace();
                return null;
            }
            instance = new JPACheckSum();
        }
        return instance;
    }

    public String getSavedShapeMD5(Shape sh) {
        String checkSumString = Graphiti.getPeService().getPropertyValue((PropertyContainer)sh, "diagram.checksum");
        if (checkSumString == null) {
            return "";
        }
        return checkSumString;
    }

    public void assignEntityShapesMD5Strings(Diagram d, JpaProject jpaProject) {
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
        EList picts = d.getChildren();
        if (picts.size() == 0) {
            return;
        }
        for (Shape pict : picts) {
            String name = Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, JPAEditorConstants.PROP_ENTITY_CLASS_NAME);
            JavaPersistentType jpt = JpaArtifactFactory.instance().getJPT(name, pu);
            String hash = "";
            if (jpt != null) {
                ICompilationUnit cu = JPAEditorUtil.getCompilationUnit(jpt);
                hash = this.generateCompilationUnitMD5String(cu);
            }
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pict, "diagram.checksum", hash);
        }
    }

    public String generateCompilationUnitMD5String(ICompilationUnit cu) {
        String src = null;
        try {
            src = cu.getSource();
        }
        catch (JavaModelException e) {
            System.err.println("Can't get the source of the compilation unit");
            e.printStackTrace();
            return null;
        }
        byte[] res = md5.digest(src.getBytes());
        StringBuilder sb = new StringBuilder();
        byte[] byArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(Byte.toString(b));
            ++n2;
        }
        return sb.toString();
    }

    public boolean isEntityModelChanged(Shape sh, JpaProject jpaProject) {
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
        String name = Graphiti.getPeService().getPropertyValue((PropertyContainer)sh, JPAEditorConstants.PROP_ENTITY_CLASS_NAME);
        JavaPersistentType jpt = JpaArtifactFactory.instance().getJPT(name, pu);
        String savedMD5 = this.getSavedShapeMD5(sh);
        String actualMD5 = "";
        if (jpt != null) {
            ICompilationUnit cu = JPAEditorUtil.getCompilationUnit(jpt);
            actualMD5 = this.generateCompilationUnitMD5String(cu);
        }
        return !savedMD5.equals(actualMD5);
    }

    public boolean isModelDifferentFromDiagram(Diagram d, JpaProject jpaProject) {
        EList picts = d.getChildren();
        if (picts.size() == 0) {
            return false;
        }
        for (Shape pict : picts) {
            if (!this.isEntityModelChanged(pict, jpaProject)) continue;
            return true;
        }
        return false;
    }
}

