/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.relations;

import java.util.Hashtable;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.relations.IRelation;

public abstract class AbstractRelation
implements IRelation {
    protected static final String SEPARATOR = ";";
    protected JavaPersistentType owner;
    protected JavaPersistentType inverse;
    protected JavaPersistentAttribute ownerAnnotatedAttribute;
    protected JavaPersistentAttribute inverseAnnotatedAttribute;
    protected String ownerAttributeName;
    protected String inverseAttributeName;
    public static final Hashtable<IRelation.RelType, String> relTypeToIdPart = new Hashtable();
    public static final Hashtable<IRelation.RelDir, String> relDirToIdPart = new Hashtable();

    static {
        relTypeToIdPart.put(IRelation.RelType.ONE_TO_ONE, "1-1");
        relTypeToIdPart.put(IRelation.RelType.ONE_TO_MANY, "1-N");
        relTypeToIdPart.put(IRelation.RelType.MANY_TO_ONE, "N-1");
        relTypeToIdPart.put(IRelation.RelType.MANY_TO_MANY, "N-N");
        relDirToIdPart.put(IRelation.RelDir.UNI, "->");
        relDirToIdPart.put(IRelation.RelDir.BI, "<->");
    }

    public AbstractRelation(JavaPersistentType owner, JavaPersistentType inverse) {
        this.owner = owner;
        this.inverse = inverse;
    }

    public String getId() {
        return AbstractRelation.generateId(this.owner, this.inverse, this.getOwnerAttributeName(), this.getRelType(), this.getRelDir());
    }

    public JavaPersistentType getOwner() {
        return this.owner;
    }

    public JavaPersistentType getInverse() {
        return this.inverse;
    }

    public JavaPersistentAttribute getInverseAnnotatedAttribute() {
        return this.inverseAnnotatedAttribute;
    }

    public JavaPersistentAttribute getOwnerAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    public void setOwnerAnnotatedAttribute(JavaPersistentAttribute ownerAnnotatedAttribute) {
        this.ownerAnnotatedAttribute = ownerAnnotatedAttribute;
    }

    public void setInverseAnnotatedAttribute(JavaPersistentAttribute inverseAnnotatedAttribute) {
        this.inverseAnnotatedAttribute = inverseAnnotatedAttribute;
    }

    public void setOwnerAttributeName(String ownerAttributeName) {
        this.ownerAttributeName = ownerAttributeName;
    }

    public String getOwnerAttributeName() {
        if (this.ownerAnnotatedAttribute != null) {
            return this.ownerAnnotatedAttribute.getName();
        }
        return this.ownerAttributeName;
    }

    public void setInverseAttributeName(String inverseAttributeName) {
        this.inverseAttributeName = inverseAttributeName;
    }

    public String getInverseAttributeName() {
        if (this.inverseAnnotatedAttribute != null) {
            return this.inverseAnnotatedAttribute.getName();
        }
        return this.inverseAttributeName;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object otherRel) {
        if (!IRelation.class.isInstance(otherRel)) {
            return false;
        }
        return this.getId().equals(((IRelation)otherRel).getId());
    }

    public abstract IRelation.RelType getRelType();

    public abstract IRelation.RelDir getRelDir();

    public static String generateId(JavaPersistentType owner, JavaPersistentType inverse, String ownerAttributeName, IRelation.RelType relType, IRelation.RelDir relDir) {
        String id = String.valueOf(owner.getName()) + "-" + inverse.getName() + SEPARATOR + relTypeToIdPart.get((Object)relType) + SEPARATOR + relDirToIdPart.get((Object)relDir) + SEPARATOR + ownerAttributeName;
        return id;
    }
}

