/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.provider;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.dt.AbstractDiagramTypeProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.diagrameditor.internal.JPADiagramEditor;
import org.eclipse.jpt.ui.diagrameditor.internal.facade.EclipseFacade;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.AddAllEntitiesFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.AddJPAEntityFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.RemoveRelationFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.AddEntityContext;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.JPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.JPAEditorToolBehaviorProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPACheckSum;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorConstants;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPASolver;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.ui.diagrameditor.internal.util.SizePosition;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class JPAEditorDiagramTypeProvider
extends AbstractDiagramTypeProvider {
    private IToolBehaviorProvider[] toolBehaviorProviders;
    public static final String ID = "org.eclipse.jpt.ui.diagrameditor.provider.JPAEditorDiagramTypeProvider";
    boolean isDisposed = false;
    boolean readOnly = false;

    public JPAEditorDiagramTypeProvider() {
        JPAEditorFeatureProvider fp = new JPAEditorFeatureProvider((IDiagramTypeProvider)this, new JPASolver());
        this.setFeatureProvider(fp);
    }

    public void init(Diagram diagram, IDiagramEditor diagramEditor) {
        JPAEditorDiagramTypeProvider provider;
        super.init(diagram, diagramEditor);
        if (this.getTargetJPAProject() == null) {
            this.closeEditor();
        }
        if ((provider = ModelIntegrationUtil.getProviderByDiagram(diagram)) != null && provider.isAlive()) {
            provider.getDiagramEditor().getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)provider.getDiagramEditor(), true);
        }
        ModelIntegrationUtil.mapDiagramToProvider(this.getDiagram(), this);
    }

    public IToolBehaviorProvider[] getAvailableToolBehaviorProviders() {
        if (this.toolBehaviorProviders == null) {
            this.toolBehaviorProviders = new IToolBehaviorProvider[]{new JPAEditorToolBehaviorProvider((IDiagramTypeProvider)this, EclipseFacade.INSTANCE)};
        }
        return this.toolBehaviorProviders;
    }

    public JPAEditorFeatureProvider getFeatureProvider() {
        return (JPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public boolean hasToAdd() {
        JpaProject project = this.getTargetJPAProject();
        PersistenceUnit unit = (PersistenceUnit)project.getRootContextNode().getPersistenceXml().getPersistence().persistenceUnits().next();
        Iterator classRefs = unit.classRefs();
        while (classRefs.hasNext()) {
            PictogramElement pe;
            JavaPersistentType jpt;
            ClassRef classRef = (ClassRef)classRefs.next();
            if (classRef.getJavaPersistentType() == null || (jpt = classRef.getJavaPersistentType()).getMappingKey() != "entity" || (pe = this.getFeatureProvider().getPictogramElementForBusinessObject(jpt)) != null) continue;
            return true;
        }
        return false;
    }

    public void postInit() {
        String jptName = this.getDiagramEditor().getPartProperty("JPADiagramEditor_openWholePersistenceUnit");
        if (jptName != null) {
            boolean hasToAdd = this.hasToAdd();
            boolean readOnly = this.openPersistedDiagram(hasToAdd);
            if (hasToAdd && !readOnly) {
                this.addRemainingEntities();
            }
        } else {
            try {
                this.openPersistedDiagram(false);
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
    }

    private void addRemainingEntities() {
        final AddAllEntitiesFeature feature = new AddAllEntitiesFeature(this.getFeatureProvider());
        final CustomContext context = new CustomContext();
        TransactionalEditingDomain ted = ModelIntegrationUtil.getTransactionalEditingDomain(feature.getFeatureProvider().getDiagramTypeProvider().getDiagram());
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                feature.execute((ICustomContext)context);
            }
        });
    }

    private void closeEditor() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.closeEditor((IEditorPart)JPAEditorDiagramTypeProvider.this.getDiagramEditor(), false);
            }
        });
    }

    private boolean openPersistedDiagram(boolean hasToAdd) {
        boolean readOnly;
        final Diagram diagram = this.getDiagram();
        final JpaProject proj = this.getTargetJPAProject();
        IProject project = proj.getProject();
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(proj);
        String diagramName = pu.getName();
        IPath path = ModelIntegrationUtil.getDiagramsFolderPath(project).append(diagramName).addFileExtension("xmi");
        IFile f = project.getFile(path);
        boolean bl = readOnly = f != null && f.exists() && f.isReadOnly();
        if (readOnly) {
            if (JPACheckSum.INSTANCE().isModelDifferentFromDiagram(diagram, proj) || hasToAdd) {
                String message = hasToAdd ? JPAEditorMessages.JPAEditorDiagramTypeProvider_JPADiagramReadOnlyHasToAddMsg : JPAEditorMessages.JPAEditorDiagramTypeProvider_JPADiagramReadOnlyMsg;
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), JPAEditorMessages.JPAEditorDiagramTypeProvider_JPADiagramReadOnlyTitle, null, message, 2, new String[]{JPAEditorMessages.BTN_OK, JPAEditorMessages.BTN_CANCEL}, 0){

                    protected int getShellStyle() {
                        return 0x10820 | 3.getDefaultOrientation();
                    }
                };
                if (dialog.open() == 1) {
                    this.closeEditor();
                    return true;
                }
                IStatus stat = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{f}, null);
                if (!stat.isOK()) {
                    message = NLS.bind((String)JPAEditorMessages.JPAEditorDiagramTypeProvider_cantMakeDiagramWritableMsg, (Object)stat.getMessage());
                    dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), JPAEditorMessages.JPAEditorDiagramTypeProvider_cantMakeDiagramWritableTitle, null, message, 1, new String[]{JPAEditorMessages.BTN_OK}, 0){

                        protected int getShellStyle() {
                            return 0x10860 | 4.getDefaultOrientation();
                        }
                    };
                    dialog.open();
                    this.closeEditor();
                    return true;
                }
                readOnly = false;
            } else {
                return readOnly;
            }
        }
        this.removeConnections();
        final Hashtable<String, SizePosition> marks = new Hashtable<String, SizePosition>();
        EList picts = diagram.getChildren();
        if (picts.size() == 0) {
            return readOnly;
        }
        Iterator it = picts.iterator();
        HashSet<Shape> toDelete = new HashSet<Shape>();
        while (it.hasNext()) {
            Shape pict = (Shape)it.next();
            String name = Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, JPAEditorConstants.PROP_ENTITY_CLASS_NAME);
            SizePosition rectSP = this.loadSizeAndPosition(pict);
            marks.put(name, rectSP);
            toDelete.add(pict);
        }
        final Iterator iter = toDelete.iterator();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                while (iter.hasNext()) {
                    Graphiti.getPeService().deletePictogramElement((PictogramElement)iter.next());
                }
                EList cns = diagram.getConnections();
                Iterator itera = cns.iterator();
                HashSet<Connection> toDel = new HashSet<Connection>();
                while (itera.hasNext()) {
                    toDel.add((Connection)itera.next());
                }
                itera = toDel.iterator();
                while (itera.hasNext()) {
                    Graphiti.getPeService().deletePictogramElement((PictogramElement)itera.next());
                }
                Enumeration itr = marks.keys();
                while (itr.hasMoreElements()) {
                    String entityName = (String)itr.nextElement();
                    JavaPersistentType jpt = JpaArtifactFactory.instance().getContextPersistentType(proj, entityName);
                    if (jpt == null) continue;
                    SizePosition sp = (SizePosition)marks.get(entityName);
                    AddEntityContext ctx = new AddEntityContext(sp.primaryCollapsed, sp.relationCollapsed, sp.basicCollapsed);
                    ctx.setNewObject(jpt);
                    ctx.setTargetContainer((ContainerShape)JPAEditorDiagramTypeProvider.this.getDiagram());
                    ctx.setWidth(sp.getWidth());
                    ctx.setHeight(sp.getHeight());
                    ctx.setX(sp.getX());
                    ctx.setY(sp.getY());
                    AddJPAEntityFeature ft = new AddJPAEntityFeature(JPAEditorDiagramTypeProvider.this.getFeatureProvider());
                    ft.add((IAddContext)ctx);
                }
            }
        });
        this.getDiagramEditor().saveWithoutEntities((IProgressMonitor)new NullProgressMonitor());
        return false;
    }

    private SizePosition loadSizeAndPosition(Shape pict) {
        RoundedRectangle rect = (RoundedRectangle)pict.getGraphicsAlgorithm();
        SizePosition rectSP = new SizePosition(rect.getWidth(), rect.getHeight(), rect.getX(), rect.getY());
        rectSP.primaryCollapsed = JPAEditorConstants.TRUE_STRING.equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, "primary collapsed"));
        rectSP.relationCollapsed = JPAEditorConstants.TRUE_STRING.equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, "relation collapsed"));
        rectSP.basicCollapsed = JPAEditorConstants.TRUE_STRING.equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)pict, "basic collapsed"));
        return rectSP;
    }

    private void removeConnections() {
        EList cons = this.getDiagram().getConnections();
        Iterator consIt = cons.iterator();
        HashSet<Connection> allCons = new HashSet<Connection>();
        while (consIt.hasNext()) {
            Connection con = (Connection)consIt.next();
            allCons.add(con);
        }
        for (Connection con : allCons) {
            RemoveContext ctx = new RemoveContext((PictogramElement)con);
            RemoveRelationFeature ft = new RemoveRelationFeature(this.getFeatureProvider());
            ft.remove((IRemoveContext)ctx);
        }
    }

    public JPADiagramEditor getDiagramEditor() {
        return (JPADiagramEditor)super.getDiagramEditor();
    }

    private JpaProject getTargetJPAProject() {
        return ModelIntegrationUtil.getProjectByDiagram(this.getDiagram());
    }

    public boolean isAlive() {
        return !this.isDisposed;
    }

    public void dispose() {
        super.dispose();
        this.setFeatureProvider(null);
        this.isDisposed = true;
    }
}

