/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.propertypage;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jpt.ui.diagrameditor.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.preferences.JPAEditorPreferencesPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class JPADiagramPropertyPage
extends PropertyPage {
    private Text txtDefaultEntityPackageField;
    private Text txtDefaultTableNamePrefix;
    private Button checkDirectEditAffectsClass;
    private Group groupAccessType;
    private Button btnFieldBasedAccess;
    private Button btnPropertBasedAccess;
    private static final String QUALIFIER = "org.eclipse.jpt.ui.diagrameditor.propertypage";
    public static final QualifiedName PROP_DEFAULT_PACKAGE = new QualifiedName("org.eclipse.jpt.ui.diagrameditor.propertypage", "defaultPackage");
    public static final QualifiedName PROP_DEFAULT_TABLE_NAME_PREFIX = new QualifiedName("org.eclipse.jpt.ui.diagrameditor.propertypage", "defaultTableNamePrefix");
    public static final QualifiedName PROP_DIRECT_EDIT_AFFECTS_CLASS = new QualifiedName("org.eclipse.jpt.ui.diagrameditor.propertypage", "directEditAffectsClass");
    public static final QualifiedName PROP_ACCESS_TYPE = new QualifiedName("org.eclipse.jpt.ui.diagrameditor.propertypage", "accessType");
    private IPreferenceStore store = JPADiagramEditorPlugin.getDefault().getPreferenceStore();

    protected Control createContents(Composite parent) {
        Composite composite = this.createCompositeContainer(parent);
        this.createDefaultPackageControl(composite);
        this.createDefaultTableNamePrefixControl(composite);
        this.createDirectEditAffectsClassControl(composite);
        this.createAccessTypeControl(composite);
        Dialog.applyDialogFont((Control)composite);
        this.validatePage();
        return composite;
    }

    private Composite createCompositeContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        return composite;
    }

    private void createDefaultPackageControl(Composite composite) {
        Label lblDefaultPackage = new Label(composite, 4);
        lblDefaultPackage.setText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageToUse);
        lblDefaultPackage.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        GridData gd = new GridData();
        lblDefaultPackage.setLayoutData((Object)gd);
        this.txtDefaultEntityPackageField = new Text(composite, 0x800804);
        lblDefaultPackage.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.txtDefaultEntityPackageField.setLayoutData((Object)gd);
        IResource resource = (IResource)this.getElement();
        String defaultPackageName = null;
        try {
            defaultPackageName = resource.getPersistentProperty(PROP_DEFAULT_PACKAGE);
        }
        catch (CoreException e) {
            System.err.println("Cannot load default package name for creating entities in the project " + resource.getName());
            e.printStackTrace();
        }
        if (defaultPackageName == null) {
            defaultPackageName = this.store.getString("org.eclipse.jpt.ui.diagrameditor.entity.defaultPackage");
        }
        this.txtDefaultEntityPackageField.setText(defaultPackageName);
        this.txtDefaultEntityPackageField.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        this.txtDefaultEntityPackageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPADiagramPropertyPage.this.validatePage();
            }
        });
    }

    private void createDefaultTableNamePrefixControl(Composite composite) {
        Label lblDefaultTableNamePrfix = new Label(composite, 4);
        lblDefaultTableNamePrfix.setText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNameLabel);
        lblDefaultTableNamePrfix.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        GridData gd = new GridData();
        lblDefaultTableNamePrfix.setLayoutData((Object)gd);
        this.txtDefaultTableNamePrefix = new Text(composite, 0x800800);
        lblDefaultTableNamePrfix.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.txtDefaultTableNamePrefix.setLayoutData((Object)gd);
        IResource resource = (IResource)this.getElement();
        String defaultTableNamePrefix = null;
        try {
            defaultTableNamePrefix = resource.getPersistentProperty(PROP_DEFAULT_TABLE_NAME_PREFIX);
        }
        catch (CoreException e) {
            System.err.println("Cannot load default table name prefix for creating entities in the project " + resource.getName());
            e.printStackTrace();
        }
        if (defaultTableNamePrefix == null) {
            defaultTableNamePrefix = this.store.getString("org.eclipse.jpt.ui.diagrameditor.entity.defaultTableNamePrefix");
        }
        this.txtDefaultTableNamePrefix.setText(defaultTableNamePrefix);
        this.txtDefaultTableNamePrefix.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        this.txtDefaultTableNamePrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPADiagramPropertyPage.this.validatePage();
            }
        });
    }

    private void createDirectEditAffectsClassControl(Composite composite) {
        this.checkDirectEditAffectsClass = new Button(composite, 0x800020);
        this.checkDirectEditAffectsClass.setText(JPAEditorMessages.JPAEditorPreferencesPage_directEditAffectsClass);
        this.checkDirectEditAffectsClass.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_directEditAffectsClassTooltip);
        this.checkDirectEditAffectsClass.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        IResource resource = (IResource)this.getElement();
        String defaultDirectEditAffectsClassProp = null;
        boolean defaultDirectEditAffectsClass = true;
        try {
            defaultDirectEditAffectsClassProp = resource.getPersistentProperty(PROP_DIRECT_EDIT_AFFECTS_CLASS);
            if (defaultDirectEditAffectsClassProp != null) {
                defaultDirectEditAffectsClass = defaultDirectEditAffectsClassProp.equals("true");
            }
        }
        catch (CoreException e) {
            System.err.println("Cannot load project default package name for creating entities in the project " + resource.getName());
            e.printStackTrace();
        }
        if (defaultDirectEditAffectsClassProp == null) {
            defaultDirectEditAffectsClass = this.store.getBoolean("org.eclipse.jpt.ui.diagrameditor.entity.defaultDirectEditClassName");
        }
        this.checkDirectEditAffectsClass.setSelection(defaultDirectEditAffectsClass);
    }

    private void createAccessTypeControl(Composite composite) {
        this.groupAccessType = new Group(composite, 0);
        this.groupAccessType.setText(JPAEditorMessages.JPAEditorPreferencesPage_entityAccessTypeButtonGroupLabel);
        this.groupAccessType.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_entityAccessTypeButtonGroupTooltip);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.groupAccessType.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        this.groupAccessType.setLayout((Layout)gl);
        IResource resource = (IResource)this.getElement();
        String defaultAccessType = null;
        try {
            defaultAccessType = resource.getPersistentProperty(PROP_ACCESS_TYPE);
        }
        catch (CoreException e) {
            System.err.println("Cannot load default access type for newly created entities in the project " + resource.getName());
            e.printStackTrace();
        }
        if (defaultAccessType == null) {
            defaultAccessType = this.store.getString("org.eclipse.jpt.ui.diagrameditor.entity.defaultEntityAccessType");
        }
        this.btnFieldBasedAccess = new Button((Composite)this.groupAccessType, 0x800010);
        this.btnFieldBasedAccess.setText(JPAEditorMessages.JPAEditorPreferencesPage_entityFieldBasedAccessButtonLabel);
        gd = new GridData();
        this.btnFieldBasedAccess.setLayoutData((Object)gd);
        this.btnFieldBasedAccess.setSelection(defaultAccessType.equals("field"));
        this.btnPropertBasedAccess = new Button((Composite)this.groupAccessType, 0x800010);
        this.btnPropertBasedAccess.setText(JPAEditorMessages.JPAEditorPreferencesPage_entityPropertyBasedAccessButtonLabel);
        gd = new GridData();
        this.btnPropertBasedAccess.setLayoutData((Object)gd);
        this.btnPropertBasedAccess.setSelection(defaultAccessType.equals("property"));
    }

    protected void performDefaults() {
        String defaultPackageName = this.store.getString("org.eclipse.jpt.ui.diagrameditor.entity.defaultPackage");
        this.txtDefaultEntityPackageField.setText(defaultPackageName);
        String defaultTableNamePrefix = this.store.getString("org.eclipse.jpt.ui.diagrameditor.entity.defaultTableNamePrefix");
        this.txtDefaultTableNamePrefix.setText(defaultTableNamePrefix);
        boolean defaultDirectEditAffectsClass = this.store.getBoolean("org.eclipse.jpt.ui.diagrameditor.entity.defaultDirectEditClassName");
        this.checkDirectEditAffectsClass.setSelection(defaultDirectEditAffectsClass);
        String defaultAccessType = this.store.getString("org.eclipse.jpt.ui.diagrameditor.entity.defaultEntityAccessType");
        this.btnFieldBasedAccess.setSelection(defaultAccessType.equals("field"));
        this.btnPropertBasedAccess.setSelection(defaultAccessType.equals("property"));
        super.performDefaults();
    }

    protected synchronized void validatePage() {
        IStatus statPack = JPAEditorPreferencesPage.validateDefaultPackage(this.txtDefaultEntityPackageField.getText().trim());
        IStatus statPref = JPAEditorPreferencesPage.validateTableNamePrefix(this.txtDefaultTableNamePrefix.getText().trim());
        if (statPack.getSeverity() == 4) {
            this.setErrorMessage(statPack.getMessage());
            this.setValid(false);
            return;
        }
        if (statPref.getSeverity() == 4) {
            this.setErrorMessage(statPref.getMessage());
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
        if (statPack.getSeverity() == 2) {
            this.setMessage(statPack.getMessage(), 2);
            return;
        }
        if (statPref.getSeverity() == 2) {
            this.setMessage(statPref.getMessage(), 2);
            return;
        }
        this.setMessage(null, 0);
    }

    protected void performApply() {
        this.saveSettings();
    }

    public boolean performOk() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        IResource resource = (IResource)this.getElement();
        try {
            resource.setPersistentProperty(PROP_DEFAULT_PACKAGE, this.txtDefaultEntityPackageField.getText().trim());
            resource.setPersistentProperty(PROP_DEFAULT_TABLE_NAME_PREFIX, this.txtDefaultTableNamePrefix.getText().trim());
            resource.setPersistentProperty(PROP_DIRECT_EDIT_AFFECTS_CLASS, "" + this.checkDirectEditAffectsClass.getSelection());
            resource.setPersistentProperty(PROP_ACCESS_TYPE, this.btnFieldBasedAccess.getSelection() ? "field" : "property");
        }
        catch (CoreException e) {
            System.err.println("Cannot set the new properties for project " + resource.getName());
            e.printStackTrace();
        }
    }
}

