/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.preferences;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jpt.ui.diagrameditor.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JPAEditorPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.eclipse.jpt.ui.diagrameditor.preferences.JPAEditorPreferencesPage";
    private StringFieldEditor fDefaultEntityPackageField;
    private StringFieldEditor fDefaultTableNamePrefix;
    private JPABooleanFieldEditor directEditAffectsClass;
    private RadioGroupFieldEditor entityAccessTypeChooser;

    public JPAEditorPreferencesPage() {
        super(1);
        this.setPreferenceStore(JPADiagramEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(JPAEditorMessages.JPAEditorPreferencesPage_pageDescription);
    }

    public void init(IWorkbench workbench) {
    }

    public void setErrorMessage(String newMessage) {
        if (this.fDefaultEntityPackageField.getErrorMessage() != null) {
            super.setErrorMessage(this.fDefaultEntityPackageField.getErrorMessage());
        } else {
            super.setErrorMessage(this.fDefaultTableNamePrefix.getErrorMessage());
        }
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.fDefaultEntityPackageField = new CustomStringFieldEditor("org.eclipse.jpt.ui.diagrameditor.entity.defaultPackage", JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageToUse, this.getFieldEditorParent(), true){

            protected IStatus validateValue() {
                return JPAEditorPreferencesPage.validateDefaultPackage(JPAEditorPreferencesPage.this.fDefaultEntityPackageField.getStringValue().trim());
            }
        };
        this.fDefaultEntityPackageField.getLabelControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        this.fDefaultEntityPackageField.getTextControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        this.addField((FieldEditor)this.fDefaultEntityPackageField);
        this.fDefaultTableNamePrefix = new CustomStringFieldEditor("org.eclipse.jpt.ui.diagrameditor.entity.defaultTableNamePrefix", JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNameLabel, this.getFieldEditorParent(), false){

            protected IStatus validateValue() {
                return JPAEditorPreferencesPage.validateTableNamePrefix(JPAEditorPreferencesPage.this.fDefaultTableNamePrefix.getStringValue().trim());
            }
        };
        this.fDefaultTableNamePrefix.getLabelControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        this.fDefaultTableNamePrefix.getTextControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        this.addField((FieldEditor)this.fDefaultTableNamePrefix);
        this.directEditAffectsClass = new JPABooleanFieldEditor("", JPAEditorMessages.JPAEditorPreferencesPage_directEditAffectsClass, 0, parent);
        this.directEditAffectsClass.setPreferenceName("org.eclipse.jpt.ui.diagrameditor.entity.defaultDirectEditClassName");
        this.directEditAffectsClass.getCheckBox(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_directEditAffectsClassTooltip);
        this.addField((FieldEditor)this.directEditAffectsClass);
        this.entityAccessTypeChooser = new RadioGroupFieldEditor("org.eclipse.jpt.ui.diagrameditor.entity.defaultEntityAccessType", JPAEditorMessages.JPAEditorPreferencesPage_entityAccessTypeButtonGroupLabel, 1, (String[][])new String[][]{{JPAEditorMessages.JPAEditorPreferencesPage_entityFieldBasedAccessButtonLabel, "field"}, {JPAEditorMessages.JPAEditorPreferencesPage_entityPropertyBasedAccessButtonLabel, "property"}}, parent, true);
        this.entityAccessTypeChooser.setPreferenceStore(this.getPreferenceStore());
        this.entityAccessTypeChooser.getRadioBoxControl(parent).setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_entityAccessTypeButtonGroupTooltip);
        this.addField((FieldEditor)this.entityAccessTypeChooser);
    }

    public static IStatus validateDefaultPackage(String defaultPackage) {
        if (defaultPackage.contains(" ")) {
            String message = MessageFormat.format(JPAEditorMessages.JPAEditorPreferencesPage_invalidPackage, defaultPackage);
            return new Status(4, "org.eclipse.jpt.ui.diagrameditor", message);
        }
        IStatus validateDefaultPackageStatus = JavaConventions.validatePackageName((String)defaultPackage, (String)"1.5", (String)"1.5");
        if (validateDefaultPackageStatus.getSeverity() != 0) {
            return new Status(validateDefaultPackageStatus.getSeverity(), "org.eclipse.jpt.ui.diagrameditor", validateDefaultPackageStatus.getMessage());
        }
        return new Status(0, "org.eclipse.jpt.ui.diagrameditor", null);
    }

    public static IStatus validateTableNamePrefix(String tableNamePrefix) {
        String s = tableNamePrefix;
        if (s.isEmpty()) {
            return new Status(0, "org.eclipse.jpt.ui.diagrameditor", null);
        }
        if (Character.isDigit(s.charAt(0))) {
            String message = MessageFormat.format(JPAEditorMessages.JPAEditorPreferencesPage_invalidTableNamePrefix, tableNamePrefix);
            return new Status(4, "org.eclipse.jpt.ui.diagrameditor", message);
        }
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '_') {
                String message = MessageFormat.format(JPAEditorMessages.JPAEditorPreferencesPage_invalidTableNamePrefix, tableNamePrefix);
                return new Status(4, "org.eclipse.jpt.ui.diagrameditor", message);
            }
            ++i;
        }
        return new Status(0, "org.eclipse.jpt.ui.diagrameditor", null);
    }

    public abstract class CustomStringFieldEditor
    extends StringFieldEditor {
        private boolean aboutPackage;
        String packageMsg;
        String prefixMsg;

        public CustomStringFieldEditor(String defaultEntityPackage, String jPAEditorPreferencesPageDefaultPackageToUse, Composite fieldEditorParent, boolean aboutPackage) {
            super(defaultEntityPackage, jPAEditorPreferencesPageDefaultPackageToUse, fieldEditorParent);
            this.aboutPackage = aboutPackage;
        }

        protected void setMessage(String message) {
            if (this.aboutPackage) {
                this.packageMsg = message;
            } else {
                this.prefixMsg = message;
            }
            if (this.packageMsg != null) {
                JPAEditorPreferencesPage.this.setMessage(this.packageMsg, 2);
            } else if (this.prefixMsg != null) {
                JPAEditorPreferencesPage.this.setMessage(this.prefixMsg, 2);
            } else {
                JPAEditorPreferencesPage.this.setMessage(null, 0);
            }
        }

        protected boolean doCheckState() {
            IStatus stat = this.validateValue();
            if (stat.getSeverity() == 4) {
                this.setErrorMessage(stat.getMessage());
                return false;
            }
            if (stat.getSeverity() == 2) {
                this.setErrorMessage(null);
                this.setMessage(stat.getMessage());
                return true;
            }
            this.setMessage(null);
            this.setErrorMessage(null);
            return true;
        }

        protected abstract IStatus validateValue();
    }

    public class JPABooleanFieldEditor
    extends BooleanFieldEditor {
        public JPABooleanFieldEditor(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public Button getCheckBox(Composite parent) {
            return this.getChangeControl(parent);
        }
    }
}

