/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.RemoveAttributeFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.RestoreEntityFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class RemoveJPAEntityFeature
extends DefaultRemoveFeature {
    public RemoveJPAEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void preRemove(IRemoveContext context) {
        PictogramElement pe = context.getPictogramElement();
        RestoreEntityFeature ft = new RestoreEntityFeature(this.getFeatureProvider());
        CustomContext customContext = new CustomContext(new PictogramElement[]{pe});
        ft.execute((ICustomContext)customContext);
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        HashSet<Shape> shapesForDeletion = new HashSet<Shape>();
        if (bo instanceof JavaPersistentType) {
            IJPAEditorFeatureProvider fp = this.getFeatureProvider();
            EList lst = ((ContainerShape)pe).getChildren();
            int i = lst.size() - 1;
            while (i >= 0) {
                Shape textShape = (Shape)lst.get(i);
                Object o = fp.getBusinessObjectForPictogramElement((PictogramElement)textShape);
                if (o != null && o instanceof JavaPersistentAttribute) {
                    shapesForDeletion.add(textShape);
                }
                --i;
            }
            Iterator it = shapesForDeletion.iterator();
            while (it.hasNext()) {
                RemoveAttributeFeature f = new RemoveAttributeFeature(fp, false, true);
                RemoveContext ctx = new RemoveContext((PictogramElement)it.next());
                f.remove((IRemoveContext)ctx);
            }
            String name = ((PersistentType)bo).getName();
            this.getFeatureProvider().remove(name, true);
        }
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void execute(IContext ctx) {
        if (!IRemoveContext.class.isInstance(ctx)) {
            return;
        }
        IRemoveContext context = (IRemoveContext)ctx;
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (!JavaPersistentType.class.isInstance(bo)) {
            return;
        }
        JavaPersistentType jpt = (JavaPersistentType)bo;
        if (JPAEditorUtil.isEntityOpenElsewhere(jpt, true)) {
            String shortEntName = JPAEditorUtil.cutFromLastDot(JpaArtifactFactory.instance().getEntityName(jpt));
            String message = NLS.bind((String)JPAEditorMessages.RemoveJPAEntityFeature_discardWarningMsg, (Object)shortEntName);
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), JPAEditorMessages.JPASolver_closeEditors, null, message, 4, new String[]{JPAEditorMessages.BTN_OK, JPAEditorMessages.BTN_CANCEL}, 0){

                protected int getShellStyle() {
                    return 0x10860 | 1.getDefaultOrientation();
                }
            };
            if (dialog.open() != 0) {
                return;
            }
        }
        super.execute((IContext)context);
    }
}

