/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.GraphicsUpdater;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;

public class ExpandEntityFeature
extends AbstractCustomFeature {
    public ExpandEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        final PictogramElement el = context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement(el);
        if (bo instanceof JavaPersistentType) {
            final ContainerShape containerShape = (ContainerShape)el;
            TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)containerShape);
            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    GraphicsUpdater.updateEntityShape(containerShape);
                    GraphicsUpdater.updateEntityHeigth(containerShape);
                    Graphiti.getPeService().removeProperty((PropertyContainer)el, "collapseFeatures");
                    JPAEditorUtil.rearrangeAllConnections(containerShape, ExpandEntityFeature.this.getFeatureProvider(), false);
                }
            });
        }
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public boolean isAvailable(IContext context) {
        PictogramElement[] pes;
        boolean ret = false;
        if (context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()) != null && pes.length > 0) {
            boolean expandPossible = false;
            int i = 0;
            while (i < pes.length) {
                Property property;
                PictogramElement pe = pes[i];
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (!(bo instanceof JavaPersistentType)) {
                    return false;
                }
                if (!expandPossible && (property = Graphiti.getPeService().getProperty((PropertyContainer)pe, "collapseFeatures")) != null) {
                    expandPossible = true;
                }
                ++i;
            }
            if (expandPossible) {
                return true;
            }
        }
        return ret;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }
}

