/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.ui.diagrameditor.internal.feature.CreateJPAEntityFeature;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;

public class CreateJPAEntityFromMappedSuperclassFeature
extends AbstractCreateFeature {
    private IPreferenceStore jpaPreferenceStore = JPADiagramEditorPlugin.getDefault().getPreferenceStore();

    public CreateJPAEntityFromMappedSuperclassFeature(IFeatureProvider fp) {
        super(fp, JPAEditorMessages.CreateJPAEntityFromMappedSuperclassFeature_createInheritedEntityFeatureName, JPAEditorMessages.CreateJPAEntityFromMappedSuperclassFeature_createInheritedEntityFeatureDescription);
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        EList shapes = this.getFeatureProvider().getDiagramTypeProvider().getDiagram().getChildren();
        IProject targetProject = null;
        JpaProject jpaProject = null;
        if (shapes == null || shapes.size() == 0) {
            jpaProject = this.getTargetJPAProject();
            targetProject = jpaProject.getProject();
        } else {
            Shape sh = (Shape)shapes.get(0);
            JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (jpt == null) {
                return new Object[0];
            }
            jpaProject = jpt.getJpaProject();
            targetProject = jpaProject.getProject();
        }
        String mappedSuperclassName = this.getFeatureProvider().getJPAEditorUtil().generateUniqueMappedSuperclassName(jpaProject, JPAEditorUtil.getDefaultPackage(jpaProject.getProject()), this.getFeatureProvider());
        if (!JptCorePlugin.discoverAnnotatedClasses((IProject)jpaProject.getProject())) {
            JPAEditorUtil.createRegisterEntityInXMLJob(jpaProject, mappedSuperclassName);
        }
        try {
            this.getFeatureProvider().getJPAEditorUtil().createEntityFromMappedSuperclassInProject(targetProject, mappedSuperclassName, this.jpaPreferenceStore);
        }
        catch (Exception e1) {
            System.err.println("Cannot create an entity in the project " + targetProject.getName());
            e1.printStackTrace();
        }
        CreateJPAEntityFeature createEntityFeature = new CreateJPAEntityFeature(this.getFeatureProvider(), true, mappedSuperclassName);
        return createEntityFeature.create(context);
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.ui.diagrameditor.mapped_superclass";
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private JpaProject getTargetJPAProject() {
        return this.getFeatureProvider().getMoinIntegrationUtil().getProjectByDiagram(this.getDiagram());
    }
}

