/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import java.io.IOException;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.diagrameditor.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class CreateJPAEntityFeature
extends AbstractCreateFeature {
    private String PERSISTENCE_PROVIDER_LIBRARY_STRING = "javax/persistence/";
    private IPreferenceStore jpaPreferenceStore = JPADiagramEditorPlugin.getDefault().getPreferenceStore();
    private boolean isMappedSuperclassChild;
    private String mappedSuperclassName;
    private String mappedSuperclassPackage;
    private boolean hasPrimarykey;

    public CreateJPAEntityFeature(IFeatureProvider fp) {
        super(fp, JPAEditorMessages.CreateJPAEntityFeature_jpaEntityFeatureName, JPAEditorMessages.CreateJPAEntityFeature_jpaEntityFeatureDescription);
    }

    public CreateJPAEntityFeature(IFeatureProvider fp, boolean isMappedSuperclassChild, String mappedSuperclassName, String mappedSuperClassPackage) {
        this(fp, isMappedSuperclassChild, mappedSuperclassName, mappedSuperClassPackage, false);
    }

    public CreateJPAEntityFeature(IFeatureProvider fp, boolean isMappedSuperclassChild, String mappedSuperclassName) {
        this(fp, isMappedSuperclassChild, mappedSuperclassName, null, false);
    }

    public CreateJPAEntityFeature(IFeatureProvider fp, boolean isMappedSuperclassChild, String mappedSuperclassName, String mappedSuperClassPackage, boolean hasPrimaryKey) {
        this(fp);
        this.isMappedSuperclassChild = isMappedSuperclassChild;
        this.mappedSuperclassName = mappedSuperclassName;
        this.mappedSuperclassPackage = mappedSuperClassPackage;
        this.hasPrimarykey = hasPrimaryKey;
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        EList shapes = this.getFeatureProvider().getDiagramTypeProvider().getDiagram().getChildren();
        IProject targetProject = null;
        JpaProject jpaProject = null;
        if (shapes == null || shapes.size() == 0) {
            jpaProject = this.getTargetJPAProject();
            targetProject = jpaProject.getProject();
        } else {
            Shape sh = (Shape)shapes.get(0);
            JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (jpt == null) {
                return new Object[0];
            }
            jpaProject = jpt.getJpaProject();
            targetProject = jpaProject.getProject();
        }
        String entityName = this.getFeatureProvider().getJPAEditorUtil().generateUniqueEntityName(jpaProject, JPAEditorUtil.getDefaultPackage(jpaProject.getProject()), this.getFeatureProvider());
        if (!this.checkIsSetPersistenceProviderLibrary(jpaProject)) {
            Shell shell = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            Status status = new Status(4, "org.eclipse.jpt.ui.diagrameditor", JPAEditorMessages.CreateJPAEntityFeature_createEntityErrorStatusMsg);
            ErrorDialog.openError((Shell)shell, (String)JPAEditorMessages.CreateJPAEntityFeature_createEntityErrorMsgTitle, (String)JPAEditorMessages.CreateJPAEntityFeature_createEntityErrorMsg, (IStatus)status);
            return new Object[0];
        }
        if (!JptCorePlugin.discoverAnnotatedClasses((IProject)targetProject)) {
            JPAEditorUtil.createRegisterEntityInXMLJob(jpaProject, entityName);
        }
        try {
            this.getFeatureProvider().getJPAEditorUtil().createEntityInProject(targetProject, entityName, this.jpaPreferenceStore, this.isMappedSuperclassChild, this.mappedSuperclassName, this.mappedSuperclassPackage, this.hasPrimarykey);
        }
        catch (Exception e1) {
            System.err.println("Cannot create an entity in the project " + targetProject.getName());
            e1.printStackTrace();
        }
        try {
            jpaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            System.err.println("Cannot refresh the project");
            e1.printStackTrace();
        }
        ListIterator lit = jpaProject.getRootContextNode().getPersistenceXml().getPersistence().persistenceUnits();
        PersistenceUnit pu = (PersistenceUnit)lit.next();
        JavaPersistentType jpt = (JavaPersistentType)pu.getPersistentType(entityName);
        int cnt = 0;
        while (jpt == null && cnt < 25) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                System.err.println("Thread sleep interrupted");
                e.printStackTrace();
            }
            jpt = (JavaPersistentType)pu.getPersistentType(entityName);
            ++cnt;
        }
        if (jpt != null) {
            this.addGraphicalRepresentation((IAreaContext)context, jpt);
            IWorkbenchPartSite ws = ((IEditorPart)this.getDiagramEditor()).getSite();
            ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(jpt);
            this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
            return new Object[]{jpt};
        }
        System.err.println("The JPA entity " + entityName + " could not be created");
        Exception e = new Exception();
        e.printStackTrace();
        return new Object[0];
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.ui.diagrameditor.add_entity";
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private JpaProject getTargetJPAProject() {
        return this.getFeatureProvider().getMoinIntegrationUtil().getProjectByDiagram(this.getDiagram());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPersistenceProviderLibraryInClasspath(String classPathEntry) {
        try {
            JarEntry entry;
            JarFile jar = new JarFile(classPathEntry);
            Enumeration<JarEntry> entries = jar.entries();
            do {
                if (entries.hasMoreElements()) continue;
                return false;
            } while (!(entry = entries.nextElement()).getName().equals(this.PERSISTENCE_PROVIDER_LIBRARY_STRING));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkIsSetPersistenceProviderLibrary(JpaProject jpaProject) {
        IJavaProject javaProject = JavaCore.create((IProject)jpaProject.getProject());
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        JavaSearchScope scope = (JavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        boolean isAdded = false;
        IPath[] paths = scope.enclosingProjectsAndJars();
        int i = 1;
        while (i < paths.length) {
            IPath path = paths[i];
            if (this.isPersistenceProviderLibraryInClasspath(path.toString())) {
                isAdded = true;
                break;
            }
            ++i;
        }
        return isAdded;
    }
}

