/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.GraphicsUpdater;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorUtil;

public class CollapseCompartmentShapeFeature
extends AbstractCustomFeature {
    public CollapseCompartmentShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        PictogramElement el = context.getPictogramElements()[0];
        final ContainerShape containerShape = (ContainerShape)el;
        final ContainerShape entityShape = containerShape.getContainer();
        final GraphicsAlgorithm algo = el.getGraphicsAlgorithm();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)algo);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                algo.setHeight(13);
                GraphicsUpdater.updateEntityShape(entityShape);
                GraphicsUpdater.setCollapsed(containerShape, true);
                JPAEditorUtil.rearrangeAllConnections(entityShape, CollapseCompartmentShapeFeature.this.getFeatureProvider(), false);
            }
        });
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public boolean isAvailable(IContext context) {
        PictogramElement[] pes;
        boolean ret = false;
        if (context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()) != null && pes.length > 0) {
            boolean collapsePossible = false;
            int i = 0;
            while (i < pes.length) {
                PictogramElement pe = pes[i];
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo != null) {
                    return false;
                }
                if (!collapsePossible && !GraphicsUpdater.isCollapsed((ContainerShape)pe)) {
                    collapsePossible = true;
                }
                ++i;
            }
            if (collapsePossible) {
                return true;
            }
        }
        return ret;
    }
}

