/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.feature;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JpaArtifactFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class ClickAddAttributeButtonFeature
extends AbstractCreateFeature {
    public ClickAddAttributeButtonFeature(IFeatureProvider provider) {
        super(provider, "", "");
    }

    public boolean canExecute(IContext context) {
        return true;
    }

    public boolean canUndo(IContext context) {
        return false;
    }

    public boolean canCreate(ICreateContext context) {
        return true;
    }

    public Object[] create(ICreateContext context) {
        ContainerShape entityShape = context.getTargetContainer();
        JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)entityShape);
        String newAttrName = JpaArtifactFactory.instance().createNewAttribute(jpt, false, this.getFeatureProvider());
        JpaArtifactFactory.instance().refreshEntityModel(this.getFeatureProvider(), jpt);
        JavaPersistentAttribute newAttr = jpt.getAttributeNamed(newAttrName);
        int cnt = 0;
        while (newAttr == null && cnt < 25) {
            newAttr = jpt.getAttributeNamed(newAttrName);
            if (newAttr == null) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    System.err.println("Thread sleep interrupted");
                    e.printStackTrace();
                }
            }
            ++cnt;
        }
        this.getFeatureProvider().addAddIgnore((JavaPersistentType)newAttr.getParent(), newAttr.getName());
        this.addGraphicalRepresentation((IAreaContext)context, newAttr);
        this.getFeatureProvider().getDirectEditingInfo().setActive(true);
        IWorkbenchPartSite ws = ((IEditorPart)this.getDiagramEditor()).getSite();
        ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(jpt);
        this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
        return new Object[]{newAttr};
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public String getName() {
        return JPAEditorMessages.ClickAddAttributeButtonFeature_createAttributeButtonLabel;
    }

    public String getDescription() {
        return JPAEditorMessages.ClickAddAttributeButtonFeature_createAttributeButtonDescription;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }
}

