/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.diagrameditor.internal.dialog;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jpt.ui.diagrameditor.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.ui.diagrameditor.internal.util.JPAEditorConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

public class SelectTypeDialog
extends TitleAreaDialog {
    protected String title = JPAEditorMessages.SelectTypeDialog_chooseAttributeTypeDialogTitle;
    protected String message;
    protected Label label;
    protected Text text;
    protected String type;
    protected Button browseButton;
    protected ContentProposalAdapter contentProposalAdapter;
    protected static KeyStroke ks = null;

    static {
        try {
            ks = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException e1) {
            System.err.println("Can't create keystroke object");
            e1.printStackTrace();
        }
    }

    public SelectTypeDialog(String message, String initialType) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        this.message = message;
        this.type = initialType;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.text.setText(this.type);
        this.text.setSelection(0, this.type.length());
        return contents;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(JPAEditorMessages.SelectTypeDialog_chooseAttributeTypeDialogWindowTitle);
    }

    protected Point getInitialSize() {
        return new Point(this.convertHorizontalDLUsToPixels(320), this.convertVerticalDLUsToPixels(120));
    }

    public String getTypeName() {
        return this.type;
    }

    protected void buttonPressed(int buttonId) {
        this.type = this.text.getText();
        super.buttonPressed(buttonId);
    }

    protected boolean isResizable() {
        return true;
    }

    private void createLabel(Composite composite) {
        this.label = new Label(composite, 16384);
        this.label.setText(JPAEditorMessages.SelectTypeDialog_typeLabel);
    }

    private void createTextField(Composite composite) {
        this.text = new Text(composite, 2052);
    }

    private void createBrowseBtn(Composite composite) {
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(JPAEditorMessages.SelectTypeDialog_browseBtnTxt);
        this.browseButton.setToolTipText(JPAEditorMessages.SelectTypeDialog_browseBtnDesc);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                SelectionDialog d = null;
                try {
                    d = JavaUI.createTypeDialog((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)256, (boolean)false, (String)SelectTypeDialog.this.text.getText().trim());
                }
                catch (JavaModelException e1) {
                    System.err.println("Can't create type selaction dialog instance");
                    e1.printStackTrace();
                }
                d.open();
                Object[] res = d.getResult();
                if (res == null) {
                    return;
                }
                Object[] obj = d.getResult();
                if (obj == null) {
                    return;
                }
                IType tp = (IType)obj[0];
                SelectTypeDialog.this.text.setText(tp.getFullyQualifiedName());
                SelectTypeDialog.this.text.setSelection(0, tp.getFullyQualifiedName().length());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private IContentProposalProvider createContentProposalProvider() {
        SimpleContentProposalProvider contProvider = new SimpleContentProposalProvider(JPAEditorConstants.PRIMITIVE_TYPES);
        contProvider.setFiltering(true);
        this.contentProposalAdapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)contProvider, ks, new char[]{'b', 'c', 'd', 'i', 'f', 'l', 's', 'j'});
        this.contentProposalAdapter.setEnabled(true);
        this.contentProposalAdapter.setProposalAcceptanceStyle(2);
        return contProvider;
    }

    public Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout rowLayout = new GridLayout(3, false);
        Composite composite = new Composite(parentComposite, 0);
        GridData d = new GridData(1808);
        d.grabExcessHorizontalSpace = true;
        d.heightHint = 400;
        composite.setLayoutData((Object)d);
        rowLayout.marginLeft = 5;
        rowLayout.marginTop = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginBottom = 30;
        composite.setLayout((Layout)rowLayout);
        this.createLabel(composite);
        GridData data = new GridData(40, 20);
        data.verticalAlignment = 0x1000000;
        data.horizontalAlignment = 1;
        this.label.setLayoutData((Object)data);
        this.createTextField(composite);
        data = new GridData(300, 17);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 0x1000000;
        this.text.setLayoutData((Object)data);
        this.createBrowseBtn(composite);
        data = new GridData(100, 25);
        data.verticalAlignment = 128;
        data.horizontalAlignment = 16384;
        data.minimumWidth = 80;
        this.browseButton.setLayoutData((Object)data);
        this.createContentProposalProvider();
        return parentComposite;
    }
}

