package com.leagueplanet.ui;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.rpc.ServiceException;

import com.leagueplanet.GameDetail;
import com.leagueplanet.Update;
import com.leagueplanet.UpdateService;
import com.leagueplanet.UpdateServiceLocator;

/**
 * Servlet implementation class for Servlet: UpdateScoreServlet
 * 
 */
public class UpdateScoreServlet extends javax.servlet.http.HttpServlet
		implements javax.servlet.Servlet {

	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		long gameId = getLongParam(request, "gameId", 0);
		forwardGameDetail(request, response, gameId, "/score-form.jsp");
	}

	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		long gameId = getLongParam(request, "gameId", 0);
		int visitorScore = (int) getLongParam(request, "visitorScore", -1);
		int homeScore = (int) getLongParam(request, "homeScore", -1);

		try {
			// call the Web service to update the game score
			UpdateService service = new UpdateServiceLocator();
			Update port = service.getUpdate();
			port.updateScore(gameId, visitorScore, homeScore);

			forwardGameDetail(request, response, gameId,
					"/score-confirmation.jsp");
		} catch (ServiceException e) {
			e.printStackTrace();
		}
	}

	private void forwardGameDetail(HttpServletRequest request,
			HttpServletResponse response, long gameId, String url)
			throws ServletException, IOException {
		try {
			// call the Web service to get the game details
			UpdateService service = new UpdateServiceLocator();
			Update port = service.getUpdate();
			GameDetail gameDetail = port.getGameDetail(gameId);

			// add the game details object to the session
			HttpSession session = request.getSession(true);
			session.setAttribute("gameDetail", gameDetail);

			// forward the request to the JSP
			ServletContext context = getServletContext();
			RequestDispatcher dispatcher = context.getRequestDispatcher(url);
			dispatcher.forward(request, response);

		} catch (ServiceException e) {
			e.printStackTrace();
		}
	}

	private long getLongParam(HttpServletRequest request, String name,
			long value) {

		String param = request.getParameter(name);
		if (param != null) {
			try {
				value = Long.parseLong(param);
			} catch (NumberFormatException e) {
			}
		}

		return value;
	}
}