/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.functionblock.tests.validator;

import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.DatatypeFactory;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockFactory;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.editor.functionblock.tests.validator.CrossReferenceTestTemplate;
import org.eclipse.vorto.editor.functionblock.validation.FunctionblockValidator;
import org.eclipse.xtext.junit4.validation.AssertableDiagnostics;
import org.junit.Assert;
import org.junit.Test;

public class FBOperationCrossReferenceTest
extends CrossReferenceTestTemplate {
    @Test
    public void test_OperationName_Same_EnumName_FromTypeFile() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fbmodel = _fBFactoryInstance.createFunctionblockModel();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        FunctionBlock fb = _fBFactoryInstance_1.createFunctionBlock();
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        Operation op1 = _fBFactoryInstance_2.createOperation();
        op1.setName("bCD");
        EList _operations = fb.getOperations();
        _operations.add((Object)op1);
        fbmodel.setFunctionblock(fb);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkOpNameAgainstEntityName(fbmodel);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Operation name cannot be same as custom type (Enum / Entity) name");
    }

    @Test
    public void test_OperationName_Same_EntityName_FromFbFile() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fbmodel = _fBFactoryInstance.createFunctionblockModel();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        FunctionBlock fb = _fBFactoryInstance_1.createFunctionBlock();
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        Operation op1 = _fBFactoryInstance_2.createOperation();
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Entity ent = _dTFactoryInstance.createEntity();
        op1.setName("transAction");
        ent.setName("TransAction");
        EList _operations = fb.getOperations();
        _operations.add((Object)op1);
        EList _entities = fbmodel.getEntities();
        _entities.add((Object)ent);
        fbmodel.setFunctionblock(fb);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkOpNameAgainstEntityName(fbmodel);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Operation name cannot be same as custom type (Enum / Entity) name");
    }

    @Test
    public void test_OperationName_Same_EnumName_FromFbFile() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fbmodel = _fBFactoryInstance.createFunctionblockModel();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        FunctionBlock fb = _fBFactoryInstance_1.createFunctionBlock();
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        Operation op1 = _fBFactoryInstance_2.createOperation();
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Enum ent = _dTFactoryInstance.createEnum();
        op1.setName("transAction");
        ent.setName("TransAction");
        EList _operations = fb.getOperations();
        _operations.add((Object)op1);
        EList _enums = fbmodel.getEnums();
        _enums.add((Object)ent);
        fbmodel.setFunctionblock(fb);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkOpNameAgainstEntityName(fbmodel);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Operation name cannot be same as custom type (Enum / Entity) name");
    }

    @Test
    public void test_OperationName_Diff_EntityEnumName() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fbmodel = _fBFactoryInstance.createFunctionblockModel();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        FunctionBlock fb = _fBFactoryInstance_1.createFunctionBlock();
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        Operation op1 = _fBFactoryInstance_2.createOperation();
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Enum enu = _dTFactoryInstance.createEnum();
        DatatypeFactory _dTFactoryInstance_1 = this.getDTFactoryInstance();
        Entity ent = _dTFactoryInstance_1.createEntity();
        op1.setName("transActionz");
        enu.setName("TransAction");
        ent.setName("TransActionZZ");
        EList _operations = fb.getOperations();
        _operations.add((Object)op1);
        EList _enums = fbmodel.getEnums();
        _enums.add((Object)enu);
        EList _entities = fbmodel.getEntities();
        _entities.add((Object)ent);
        fbmodel.setFunctionblock(fb);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkOpNameAgainstEntityName(fbmodel);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_OperationName_Same_EntityName_Multiple_Op() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fbmodel = _fBFactoryInstance.createFunctionblockModel();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        FunctionBlock fb = _fBFactoryInstance_1.createFunctionBlock();
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        Operation op1 = _fBFactoryInstance_2.createOperation();
        FunctionblockFactory _fBFactoryInstance_3 = this.getFBFactoryInstance();
        Operation op2 = _fBFactoryInstance_3.createOperation();
        DatatypeFactory _dTFactoryInstance = this.getDTFactoryInstance();
        Entity ent = _dTFactoryInstance.createEntity();
        DatatypeFactory _dTFactoryInstance_1 = this.getDTFactoryInstance();
        Entity ent1 = _dTFactoryInstance_1.createEntity();
        op1.setName("transAction");
        op2.setName("action");
        ent.setName("TransAction");
        ent1.setName("Trans");
        EList _operations = fb.getOperations();
        _operations.add((Object)op1);
        EList _operations_1 = fb.getOperations();
        _operations_1.add((Object)op2);
        EList _entities = fbmodel.getEntities();
        _entities.add((Object)ent);
        EList _entities_1 = fbmodel.getEntities();
        _entities_1.add((Object)ent1);
        fbmodel.setFunctionblock(fb);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkOpNameAgainstEntityName(fbmodel);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Operation name cannot be same as custom type (Enum / Entity) name");
    }

    @Test
    public void test_OperationName_Same_EntityNameFromTypeFile_Multiple_Op() {
        FunctionblockFactory _fBFactoryInstance = this.getFBFactoryInstance();
        FunctionblockModel fbmodel = _fBFactoryInstance.createFunctionblockModel();
        FunctionblockFactory _fBFactoryInstance_1 = this.getFBFactoryInstance();
        FunctionBlock fb = _fBFactoryInstance_1.createFunctionBlock();
        FunctionblockFactory _fBFactoryInstance_2 = this.getFBFactoryInstance();
        Operation op1 = _fBFactoryInstance_2.createOperation();
        FunctionblockFactory _fBFactoryInstance_3 = this.getFBFactoryInstance();
        Operation op2 = _fBFactoryInstance_3.createOperation();
        op1.setName("abc");
        op2.setName("abc");
        EList _operations = fb.getOperations();
        _operations.add((Object)op1);
        EList _operations_1 = fb.getOperations();
        _operations_1.add((Object)op2);
        fbmodel.setFunctionblock(fb);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkOpNameAgainstEntityName(fbmodel);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        Diagnostic _diagnostic = _diagnose.getDiagnostic();
        List diags = _diagnostic.getChildren();
        int _size = diags.size();
        Assert.assertEquals((long)2L, (long)_size);
        Diagnostic _get = (Diagnostic)diags.get(1);
        String _message = _get.getMessage();
        Assert.assertEquals((Object)"Operation name cannot be same as custom type (Enum / Entity) name", (Object)_message);
        Diagnostic _get_1 = (Diagnostic)diags.get(0);
        String _message_1 = _get_1.getMessage();
        Assert.assertEquals((Object)"Operation name cannot be same as custom type (Enum / Entity) name", (Object)_message_1);
    }
}

