/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;

public class PrivilegedAccessHelper {
    private static boolean shouldCheckPrivilegedAccess = true;
    private static boolean shouldUsePrivilegedAccess = false;
    private static Map<String, Class> primitiveClasses = new HashMap<String, Class>();

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("void", Void.TYPE);
        primitiveClasses.put("short", Short.TYPE);
    }

    private static Field findDeclaredField(Class javaClass, String fieldName) throws NoSuchFieldException {
        try {
            return javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return PrivilegedAccessHelper.findDeclaredField(superclass, fieldName);
        }
    }

    private static Method findMethod(Class javaClass, String methodName, Class[] methodParameterTypes) throws NoSuchMethodException {
        try {
            return javaClass.getDeclaredMethod(methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            try {
                return PrivilegedAccessHelper.findMethod(superclass, methodName, methodParameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ex;
            }
        }
    }

    public static Class getClassForName(String className) throws ClassNotFoundException {
        Class primitive = primitiveClasses.get(className);
        if (primitive != null) {
            return primitive;
        }
        return Class.forName(className);
    }

    public static Class getClassForName(String className, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        Class primitive = primitiveClasses.get(className);
        if (primitive != null) {
            return primitive;
        }
        return Class.forName(className, initialize, loader);
    }

    public static ClassLoader getClassLoaderForClass(Class clazz) {
        return clazz.getClassLoader();
    }

    public static ClassLoader privilegedGetClassLoaderForClass(Class clazz) {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(clazz));
        }
        catch (PrivilegedActionException ex) {
            throw (RuntimeException)ex.getCause();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Constructor getConstructorFor(Class javaClass, Class[] args, boolean shouldSetAccessible) throws NoSuchMethodException {
        block9: {
            result /* !! */  = null;
            try {
                result /* !! */  = javaClass.getConstructor(args);
                break block9;
            }
            catch (NoSuchMethodException missing) {
                var8_5 = javaClass.getConstructors();
                var7_6 = var8_5.length;
                var6_7 = 0;
                ** while (var6_7 < var7_6)
            }
lbl-1000:
            // 1 sources

            {
                constructor = var8_5[var6_7];
                if (constructor.getParameterTypes().length == args.length) {
                    found = true;
                    index = 0;
                    while (index < args.length) {
                        parameterType = Helper.getObjectClass(constructor.getParameterTypes()[index]);
                        if (!parameterType.isAssignableFrom(argType = Helper.getObjectClass(args[index])) && !argType.isAssignableFrom(parameterType)) {
                            found = false;
                            break;
                        }
                        ++index;
                    }
                    if (found) {
                        result /* !! */  = constructor;
                        break;
                    }
                }
                ++var6_7;
                continue;
            }
lbl26:
            // 2 sources

            if (result /* !! */  == null) {
                throw missing;
            }
        }
        if (shouldSetAccessible) {
            result /* !! */ .setAccessible(true);
        }
        return result /* !! */ ;
    }

    public static ClassLoader getContextClassLoader(Thread thread) {
        return thread.getContextClassLoader();
    }

    public static Constructor getDeclaredConstructorFor(Class javaClass, Class[] args, boolean shouldSetAccessible) throws NoSuchMethodException {
        Constructor result = javaClass.getDeclaredConstructor(args);
        if (shouldSetAccessible) {
            result.setAccessible(true);
        }
        return result;
    }

    public static Field getField(Class javaClass, String fieldName, boolean shouldSetAccessible) throws NoSuchFieldException {
        Field field = PrivilegedAccessHelper.findDeclaredField(javaClass, fieldName);
        if (shouldSetAccessible) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field getDeclaredField(Class javaClass, String fieldName, boolean shouldSetAccessible) throws NoSuchFieldException {
        Field field = javaClass.getDeclaredField(fieldName);
        if (shouldSetAccessible) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field[] getDeclaredFields(Class clazz) {
        return clazz.getDeclaredFields();
    }

    public static Field[] getFields(Class clazz) {
        return clazz.getFields();
    }

    public static Method getDeclaredMethod(Class clazz, String methodName, Class[] methodParameterTypes) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(methodName, methodParameterTypes);
    }

    public static Method getMethod(Class javaClass, String methodName, Class[] methodParameterTypes, boolean shouldSetAccessible) throws NoSuchMethodException {
        Method method = PrivilegedAccessHelper.findMethod(javaClass, methodName, methodParameterTypes);
        if (shouldSetAccessible) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method getPublicMethod(Class javaClass, String methodName, Class[] methodParameterTypes, boolean shouldSetAccessible) throws NoSuchMethodException {
        Method method = javaClass.getMethod(methodName, methodParameterTypes);
        if (shouldSetAccessible) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method[] getDeclaredMethods(Class clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Class getFieldType(Field field) {
        return field.getType();
    }

    public static String getLineSeparator() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("file.separator");
                }
            });
        }
        return Helper.cr();
    }

    public static Class[] getMethodParameterTypes(Method method) {
        return method.getParameterTypes();
    }

    public static Class getMethodReturnType(Method method) {
        return method.getReturnType();
    }

    public static Method[] getMethods(Class clazz) {
        return clazz.getMethods();
    }

    public static Object getValueFromField(Field field, Object object) throws IllegalAccessException {
        return field.get(object);
    }

    public static Object invokeConstructor(Constructor constructor, Object[] args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return constructor.newInstance(args);
    }

    public static Object invokeMethod(Method method, Object object) throws IllegalAccessException, InvocationTargetException {
        return PrivilegedAccessHelper.invokeMethod(method, object, null);
    }

    public static Object invokeMethod(Method method, Object object, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method.invoke(object, parameters);
    }

    public static Object newInstanceFromClass(Class clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    public static void setValueInField(Field field, Object object, Object value) throws IllegalAccessException {
        field.set(object, value);
    }

    public static boolean shouldUsePrivilegedAccess() {
        if (shouldCheckPrivilegedAccess) {
            if (System.getSecurityManager() != null) {
                Boolean privilegedPropertySet = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String usePrivileged = System.getProperty("eclipselink.security.usedoprivileged");
                        if (usePrivileged != null && usePrivileged.equalsIgnoreCase("true")) {
                            return true;
                        }
                        return false;
                    }
                });
                shouldUsePrivilegedAccess = privilegedPropertySet;
            } else {
                shouldUsePrivilegedAccess = false;
            }
            shouldCheckPrivilegedAccess = false;
        }
        return shouldUsePrivilegedAccess;
    }
}

