/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.ServletContext;
import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.gemini.web.core.WebApplicationStartFailedException;
import org.eclipse.gemini.web.core.spi.ServletContainer;
import org.eclipse.gemini.web.core.spi.WebApplicationHandle;
import org.eclipse.gemini.web.internal.EventManager;
import org.eclipse.gemini.web.internal.WebApplicationStartFailureRetryController;
import org.eclipse.gemini.web.internal.WebContainerUtils;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardWebApplication
implements WebApplication {
    private static final String BUNDLE_STATE_UNKNOWN = "UNKNOWN";
    private static final String BUNDLE_STATE_UNINSTALLED = "UNINSTALLED";
    private static final String BUNDLE_STATE_STOPPING = "STOPPING";
    private static final String BUNDLE_STATE_STARTING = "STARTING";
    private static final String BUNDLE_STATE_RESOLVED = "RESOLVED";
    private static final String BUNDLE_STATE_INSTALLED = "INSTALLED";
    private static final String BUNDLE_STATE_ACTIVE = "ACTIVE";
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardWebApplication.class);
    private final Bundle bundle;
    private final Bundle extender;
    private final BundleContext thisBundleContext;
    private final WebApplicationHandle handle;
    private final ServletContainer container;
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();
    private final EventManager eventManager;
    private boolean started = false;
    private final Object monitor = new Object();
    private final WebApplicationStartFailureRetryController retryController;

    public StandardWebApplication(Bundle bundle, Bundle extender, WebApplicationHandle handle, ServletContainer container, EventManager eventManager, WebApplicationStartFailureRetryController retryController, BundleContext thisBundleContext) {
        this.bundle = bundle;
        this.extender = extender;
        this.handle = handle;
        this.container = container;
        this.eventManager = eventManager;
        this.retryController = retryController;
        this.thisBundleContext = thisBundleContext;
    }

    @Override
    public ServletContext getServletContext() {
        return this.handle.getServletContext();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.handle.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        boolean localStarted;
        Object object = this.monitor;
        synchronized (object) {
            localStarted = this.started;
        }
        if (!localStarted) {
            String webContextPath = this.getContextPath();
            this.eventManager.sendDeploying(this.getBundle(), this.extender, webContextPath);
            boolean startOK = false;
            try {
                this.container.startWebApplication(this.handle);
                startOK = true;
                this.publishServletContext();
                Object object2 = this.monitor;
                synchronized (object2) {
                    localStarted = this.started = true;
                }
                this.eventManager.sendDeployed(this.getBundle(), this.extender, webContextPath);
            }
            catch (RuntimeException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Failed to start web application at context path '" + webContextPath + "'", (Throwable)e);
                }
                try {
                    this.retryController.recordFailure(this);
                    Set<Long> webContextPathBundleIds = this.getWebContextPathBundleIds(webContextPath);
                    boolean collision = webContextPathBundleIds.size() > 1;
                    this.eventManager.sendFailed(this.getBundle(), this.extender, webContextPath, e, collision ? webContextPath : null, collision ? webContextPathBundleIds : null);
                }
                finally {
                    if (!localStarted && startOK) {
                        this.container.stopWebApplication(this.handle);
                    }
                }
                throw new WebApplicationStartFailedException(e);
            }
        }
    }

    private Set<Long> getWebContextPathBundleIds(String webContextPath) {
        HashSet<Long> bundleIds = new HashSet<Long>();
        Bundle[] bundleArray = this.thisBundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (webContextPath.equals(WebContainerUtils.getContextPath(bundle))) {
                bundleIds.add(bundle.getBundleId());
            }
            ++n2;
        }
        return bundleIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        boolean localStarted;
        Object object = this.monitor;
        synchronized (object) {
            localStarted = this.started;
            this.started = false;
        }
        if (localStarted) {
            this.eventManager.sendUndeploying(this.getBundle(), this.extender, this.getContextPath());
            this.container.stopWebApplication(this.handle);
            this.tracker.unregisterAll();
            this.eventManager.sendUndeployed(this.getBundle(), this.extender, this.getContextPath());
        }
        this.retryController.retryFailures(this);
    }

    private void publishServletContext() {
        Dictionary<String, String> properties = this.constructServletContextProperties();
        BundleContext bundleContext = this.getBundle().getBundleContext();
        if (bundleContext == null) {
            throw new IllegalStateException("Cannot register ServletContext as OSGi service. BundleContext is not available. Possible reason is a bundle refresh. Current bundle state is " + this.getStateAsString(this.bundle.getState()) + ".");
        }
        this.tracker.track(bundleContext.registerService(ServletContext.class, (Object)this.getServletContext(), properties));
    }

    String getContextPath() {
        return this.handle.getServletContext().getContextPath();
    }

    Bundle getBundle() {
        return this.bundle;
    }

    private Dictionary<String, String> constructServletContextProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        WebContainerUtils.setServletContextBundleProperties(properties, this.getBundle());
        ((Dictionary)properties).put("osgi.web.contextpath", this.getContextPath());
        return properties;
    }

    private String getStateAsString(int state) {
        String stateAsString;
        switch (state) {
            case 32: {
                stateAsString = BUNDLE_STATE_ACTIVE;
                break;
            }
            case 2: {
                stateAsString = BUNDLE_STATE_INSTALLED;
                break;
            }
            case 4: {
                stateAsString = BUNDLE_STATE_RESOLVED;
                break;
            }
            case 8: {
                stateAsString = BUNDLE_STATE_STARTING;
                break;
            }
            case 16: {
                stateAsString = BUNDLE_STATE_STOPPING;
                break;
            }
            case 1: {
                stateAsString = BUNDLE_STATE_UNINSTALLED;
                break;
            }
            default: {
                stateAsString = BUNDLE_STATE_UNKNOWN;
            }
        }
        return stateAsString;
    }
}

