/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy.javassist;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.webbeans.proxy.Factory;
import org.apache.webbeans.proxy.MethodHandler;
import org.apache.webbeans.proxy.javassist.OpenWebBeansClassLoaderProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistFactory
implements Factory {
    @Override
    public Class<?> getProxyClass(Class<?> superClass, Class<?>[] interfaces) {
        ProxyFactory fact = new ProxyFactory();
        fact.setInterfaces((Class[])interfaces);
        if (superClass != null) {
            fact.setSuperclass(superClass);
        }
        fact.setFilter((MethodFilter)FinalizeMethodFilter.INSTANCE);
        return JavassistFactory.getProxyClass(fact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getProxyClass(ProxyFactory factory) {
        ProxyFactory.ClassLoaderProvider classLoaderProvider = ProxyFactory.classLoaderProvider;
        try {
            Class<?> clazz = JavassistFactory.doPrivilegedCreateClass(factory);
            return clazz;
        }
        catch (RuntimeException e) {
            if (classLoaderProvider instanceof OpenWebBeansClassLoaderProvider) {
                ((OpenWebBeansClassLoaderProvider)classLoaderProvider).useCurrentClassLoader();
            }
            Class<?> clazz = JavassistFactory.doPrivilegedCreateClass(factory);
            return clazz;
        }
        finally {
            if (classLoaderProvider instanceof OpenWebBeansClassLoaderProvider) {
                ((OpenWebBeansClassLoaderProvider)classLoaderProvider).reset();
            }
        }
    }

    @Override
    public Object createProxy(Class<?> proxyClass) throws InstantiationException, IllegalAccessException {
        return proxyClass.newInstance();
    }

    private static Class<?> doPrivilegedCreateClass(ProxyFactory factory) {
        if (System.getSecurityManager() == null) {
            return factory.createClass();
        }
        return (Class)AccessController.doPrivileged(new PrivilegedActionForProxyFactory(factory));
    }

    @Override
    public boolean isProxyInstance(Object o) {
        return o instanceof ProxyObject;
    }

    @Override
    public Object createProxy(MethodHandler handler, Class<?>[] interfaces) throws InstantiationException, IllegalAccessException {
        ProxyFactory pf = new ProxyFactory();
        pf.setInterfaces((Class[])interfaces);
        pf.setHandler((javassist.util.proxy.MethodHandler)handler);
        return JavassistFactory.getProxyClass(pf).newInstance();
    }

    @Override
    public void setHandler(Object proxy, MethodHandler handler) {
        ((ProxyObject)proxy).setHandler((javassist.util.proxy.MethodHandler)handler);
    }

    public static class FinalizeMethodFilter
    implements MethodFilter {
        private static final String FINALIZE = "finalize".intern();
        public static final FinalizeMethodFilter INSTANCE = new FinalizeMethodFilter();

        public boolean isHandled(Method method) {
            return method.getName() != FINALIZE || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrivilegedActionForProxyFactory
    implements PrivilegedAction<Object> {
        private ProxyFactory factory;

        protected PrivilegedActionForProxyFactory(ProxyFactory factory) {
            this.factory = factory;
        }

        @Override
        public Object run() {
            return this.factory.createClass();
        }
    }
}

