/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.applistener.internal;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.eclipse.virgo.web.enterprise.openejb.deployer.VirgoDeployerEjb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenEjbApplicationListener
implements LifecycleListener {
    private static Object monitor = new Object();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(StandardContext standardContext) throws Exception {
        ServletContext context = standardContext.getServletContext();
        String contextPath = context.getContextPath();
        VirgoDeployerEjb deployer = new VirgoDeployerEjb(contextPath, context.getClassLoader());
        try {
            String realPath = context.getRealPath("");
            Object object = monitor;
            synchronized (object) {
                if (realPath != null) {
                    deployer.deploy(realPath, standardContext);
                } else {
                    deployer.deploy(this.getAppModuleId(standardContext.getDocBase()), standardContext);
                }
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Failed to initialise enterprise container for application with context path '" + contextPath + "'", (Throwable)e);
            }
            throw e;
        }
    }

    public void undeploy(StandardContext standardContext) throws Exception {
        ServletContext context = standardContext.getServletContext();
        String contextPath = context.getContextPath();
        VirgoDeployerEjb deployer = new VirgoDeployerEjb(contextPath, context.getClassLoader());
        try {
            String realPath = context.getRealPath("");
            if (realPath != null) {
                deployer.undeploy(realPath);
            } else {
                deployer.undeploy(new File(this.getAppModuleId(standardContext.getDocBase())).getAbsolutePath());
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Failed to destroy enterprise container for application with context path '" + contextPath + "'", (Throwable)e);
            }
            throw e;
        }
    }

    private String getAppModuleId(String docBase) {
        File appLocation = new File(docBase);
        String appModuleId = !appLocation.isAbsolute() ? String.valueOf(System.getProperty("org.eclipse.virgo.kernel.home")) + File.separator + docBase : docBase;
        return appModuleId;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Object source = event.getSource();
        if (source instanceof StandardContext) {
            StandardContext standardContext = (StandardContext)source;
            if ("before_start".equals(event.getType())) {
                Loader loader = standardContext.getLoader();
                if (loader != null && loader instanceof Lifecycle) {
                    ((Lifecycle)loader).addLifecycleListener((LifecycleListener)this);
                }
            } else if ("configure_start".equals(event.getType())) {
                try {
                    this.deploy(standardContext);
                }
                catch (Exception exception) {
                    standardContext.setConfigured(false);
                }
            } else if ("configure_stop".equals(event.getType())) {
                try {
                    this.undeploy(standardContext);
                }
                catch (Exception exception) {
                    standardContext.setConfigured(false);
                }
            }
        } else if (source instanceof Loader && "after_start".equals(event.getType())) {
            Container container = ((Loader)source).getContainer();
            LifecycleListener[] listeners = container.findLifecycleListeners();
            int i = 0;
            while (listeners != null && i < listeners.length) {
                if (listeners[i].equals(this)) {
                    container.removeLifecycleListener((LifecycleListener)this);
                }
                ++i;
            }
            container.addLifecycleListener((LifecycleListener)this);
        }
    }
}

